/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.bgsecure.client;

import bitel.billing.module.admin.TransferManager;
import bitel.billing.module.admin.bgsecure.ActionsPanel;
import bitel.billing.module.admin.bgsecure.ConfigPanel;
import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.BGControlPanelContractSelect;
import bitel.billing.module.common.BGControlPanelListSelect;
import bitel.billing.module.common.BGPasswordField;
import bitel.billing.module.common.ComboBoxItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableModel;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.ClientContext;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.bgbilling.kernel.bgsecure.client.ContractParameterTableModel;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuPanel;
import ru.bitel.bgbilling.kernel.bgsecure.client.MenuRestrictPanel;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserGroupService;
import ru.bitel.bgbilling.kernel.bgsecure.common.service.UserService;
import ru.bitel.bgbilling.kernel.contract.api.common.service.ContractGroupService;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanelRestoreOkCancelHelp;
import ru.bitel.common.client.tree.BGCheckTreeModel;
import ru.bitel.common.client.tree.BGUCheckTree;
import ru.bitel.common.function.Async;
import ru.bitel.common.model.Id;
import ru.bitel.oss.kernel.directories.domain.common.bean.Domain;
import ru.bitel.oss.kernel.directories.domain.common.service.DomainService;

public class UserEditor
extends BGUPanel {
    private UserService userService = null;
    private JTextField userName = new JTextField();
    private JTextField userLogin = new JTextField();
    private JTextField userEmail = new JTextField();
    private JTextField userDescr = new JTextField();
    private ActionsPanel actionsPanel = new ActionsPanel();
    private BGPasswordField userPassword1 = new BGPasswordField();
    private JPasswordField userPassword2 = new JPasswordField();
    private JCheckBox needChangePassword = new JCheckBox("\u0441\u043c\u0435\u043d\u0438\u0442\u044c \u043f\u0430\u0440\u043e\u043b\u044c \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435");
    private BGComboBox<ComboBoxItem> pidCombo = new BGComboBox();
    private BGComboBox<ComboBoxItem> statusCombo = new BGComboBox();
    private BGControlPanelListSelect groupListPanel = new BGControlPanelListSelect();
    private BGControlPanelListSelect contractGroupList = new BGControlPanelListSelect();
    private BGUCheckTree<Domain> domains = new BGUCheckTree((BGCheckTreeModel)new BGCheckTreeModel<Domain>("domains", Domain.class){
        private Icon folder;
        private Icon leaf;
        {
            this.folder = ClientUtils.getIcon((String)"fugue/tree");
            this.leaf = ClientUtils.getIcon((String)"fugue/leaf");
        }

        public Icon getIcon(Domain value) {
            return this.isLeaf(value) ? this.leaf : this.folder;
        }
    });
    private ContractParameterTableModel objectParameterTableModel = new ContractParameterTableModel("userObjectParameterAccess");
    private ContractParameterTableModel contractParameterTableModel = new ContractParameterTableModel("userContractParameterAccess");
    private JRadioButton contractGroupsModeAnd = new JRadioButton("\u0418");
    private JRadioButton contractGroupsModeOr = new JRadioButton("\u0418\u041b\u0418");
    private BGControlPanelContractSelect contractSelect = new BGControlPanelContractSelect(false, true, true);
    private ConfigPanel configPanel = new ConfigPanel();
    private Set<BGSAction> groupActionSet = new HashSet<BGSAction>();
    private MenuRestrictPanel menuRestrictPanel = new MenuRestrictPanel(false);
    private MenuPanel userMenuPanel = new MenuPanel();
    private User user;
    private User temporaryUser = null;
    private String lastActionCommand;
    private static boolean PANEL_DATA_LOADED = false;
    private JTabbedPane tabbedPanel = new JTabbedPane();
    AbstractBGUPanel.DefaultAction refreshAction = new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent e) throws Exception {
            UserEditor.this.asyncRefresh.perform();
            Async contractParameters = Async.of(() -> UserEditor.this.getUserService().contractParameters(0));
            Async contractCidParameters = Async.of(() -> UserEditor.this.getUserService().contractParameters(8));
            Async paramTable = Async.of(() -> {
                Request request = new Request();
                request.setModule("contract.object");
                request.setAction("ParamTable");
                return TransferManager.getDocument((Request)request);
            });
            try {
                JSONObject json = (JSONObject)contractParameters.get();
                UserEditor.this.contractParameterTableModel.setDefault(Utils.parseInteger((String)json.getString("userDefaultRead"), (Integer)1), Utils.parseInteger((String)json.getString("userDefaultWrite"), (Integer)1));
                UserEditor.this.contractParameterTableModel.setData(json.getJSONArray("contractParameters"));
                if (ClientUtils.checkStatus((Document)((Document)paramTable.get()))) {
                    Element tableElement = XMLUtils.selectElement((Node)((Node)paramTable.get()), (String)"//table");
                    UserEditor.this.objectParameterTableModel.setDefault(Utils.parseInteger((String)tableElement.getAttribute("groupDefaultRead"), (Integer)1), Utils.parseInteger((String)tableElement.getAttribute("groupDefaultWrite"), (Integer)1));
                    JSONArray jsonArray = new JSONArray();
                    for (Element element : XMLUtils.selectElements((Node)tableElement, (String)"data/row")) {
                        JSONObject row = new JSONObject();
                        row.put("id", (Object)element.getAttribute("id"));
                        row.put("title", (Object)element.getAttribute("title"));
                        jsonArray.put((Object)row);
                    }
                    UserEditor.this.objectParameterTableModel.setData(jsonArray);
                }
                json = (JSONObject)contractCidParameters.get();
                UserEditor.this.pidCombo.setModel((ComboBoxModel)ClientUtils.buildComboBox((JSONArray)json.getJSONArray("contractParameters"), (int)0, (String)"id", (String)"title"));
                UserEditor.this.pidCombo.insertItemAt((Object)new ComboBoxItem((Object)"0", ""), 0);
                UserEditor.this.pidCombo.setSelectedIndex(0);
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }
    };
    AbstractBGUPanel.AsyncAction<Void> asyncRefresh = new AbstractBGUPanel.AsyncAction<Void>("", ""){

        protected Void doInBackground() throws Exception {
            Async userGroups = Async.of(() -> ((UserGroupService)((ClientContext)UserEditor.this.getContext()).getPort(UserGroupService.class)).getUserGroupList(false));
            ClientUtils.buildList((JList)UserEditor.this.groupListPanel.getList(), (List)((List)userGroups.get()));
            Async contractGroups = Async.of(() -> ((ContractGroupService)((ClientContext)UserEditor.this.getContext()).getPort(ContractGroupService.class)).contractGroupList(true, null));
            ClientUtils.buildList((JList)UserEditor.this.contractGroupList.getList(), (List)((List)contractGroups.get()));
            UserEditor.this.actionsPanel.init(((ClientContext)UserEditor.this.getContext()).getModule(), ((ClientContext)UserEditor.this.getContext()).getModuleId());
            UserEditor.this.actionsPanel.setData();
            UserEditor.this.contractSelect.init(((ClientContext)UserEditor.this.getContext()).getModule(), ((ClientContext)UserEditor.this.getContext()).getModuleId());
            Domain root = ((DomainService)((ClientContext)UserEditor.this.getContext()).getPort(DomainService.class, 0)).domainTree();
            if (root != null) {
                root.setTitle("\u0414\u043e\u043c\u0435\u043d\u044b");
            }
            UserEditor.this.domains.setData((Id)root);
            UserEditor.this.domains.expand();
            UserEditor.this.actionsPanel.revalidate();
            UserEditor.this.actionsPanel.repaint();
            return null;
        }

        protected void done(Void v) throws Exception {
            PANEL_DATA_LOADED = true;
            UserEditor.this.setUser(UserEditor.this.temporaryUser);
        }
    };
    AbstractBGUPanel.DefaultAction okAction = new AbstractBGUPanel.DefaultAction("ok", "\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c"){

        public void actionPerformedImpl(ActionEvent actionEvent) throws Exception {
            if (UserEditor.this.userLogin.getText().trim().length() < 2) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u043e\u043b\u0435 \"\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\" \u0434\u043e\u043b\u0436\u043d\u043e \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 2 \u0434\u043e 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                return;
            }
            char[] pswd1 = UserEditor.this.userPassword1.getPassword();
            char[] pswd2 = UserEditor.this.userPassword1.getPassword();
            if (pswd1 == null || pswd1.length < 5) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u044c \u0434\u043e\u043b\u0436\u0435\u043d \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442\u044c \u043e\u0442 5 \u0434\u043e 20 \u0441\u0438\u043c\u0432\u043e\u043b\u043e\u0432");
                return;
            }
            boolean passwordsNotMatching = false;
            if (pswd2 == null || pswd1.length != pswd2.length) {
                passwordsNotMatching = true;
            } else {
                for (int i = 0; i < pswd1.length; ++i) {
                    if (pswd1[i] == pswd2[i]) continue;
                    passwordsNotMatching = true;
                    break;
                }
            }
            if (passwordsNotMatching) {
                ClientUtils.showErrorMessageDialog((String)"\u041f\u0430\u0440\u043e\u043b\u0438 \u043d\u0435 \u0441\u043e\u0432\u043f\u0430\u0434\u0430\u044e\u0442");
                return;
            }
            if (UserEditor.this.user == null) {
                UserEditor.this.user = new User();
            }
            UserEditor.this.user.setLogin(UserEditor.this.userLogin.getText().trim());
            UserEditor.this.user.setName(UserEditor.this.userName.getText().trim());
            UserEditor.this.user.setEmail(UserEditor.this.userEmail.getText().trim());
            UserEditor.this.user.setDescription(UserEditor.this.userDescr.getText().trim());
            UserEditor.this.user.setContractGroupsMode(UserEditor.this.contractGroupsModeOr.isSelected() ? 0 : 1);
            UserEditor.this.user.setContractGroups(UserEditor.this.contractGroupList.getValue());
            UserEditor.this.user.setDomainIds(UserEditor.this.domains.getChecked());
            UserEditor.this.user.setRuleAccessObjectParameter(Utils.toList((String)UserEditor.this.objectParameterTableModel.getValues()));
            UserEditor.this.user.setRuleAccessContractParameter(Utils.toList((String)UserEditor.this.contractParameterTableModel.getValues()));
            HashSet<BGSAction> userSet = new HashSet<BGSAction>(UserEditor.this.user.getActionList());
            HashSet<BGSAction> editSet = new HashSet<BGSAction>();
            for (BGSAction action : UserEditor.this.getActionListFromString(UserEditor.this.actionsPanel.getActions())) {
                if (UserEditor.this.groupActionSet.contains(action) && !userSet.contains(action)) continue;
                editSet.add(action);
            }
            UserEditor.this.user.setActionList(new ArrayList<BGSAction>(editSet));
            UserEditor.this.user.setPersonalAction(UserEditor.this.user.getActionList().size());
            ComboBoxItem item = (ComboBoxItem)UserEditor.this.statusCombo.getSelectedItem();
            UserEditor.this.user.setStatus(Integer.parseInt((String)item.getObject()));
            item = (ComboBoxItem)UserEditor.this.pidCombo.getSelectedItem();
            UserEditor.this.user.setContractPid(Integer.parseInt((String)item.getObject()));
            UserEditor.this.user.setContractCid(Utils.parseInt((String)UserEditor.this.contractSelect.getContracts(), (int)0));
            if (!"passwordpassword".equals(new String(pswd1))) {
                UserEditor.this.user.setPassword(Utils.getDigest((String)new String(pswd1), (String)"utf-8"));
            }
            UserEditor.this.user.setNeedChangePassword(UserEditor.this.needChangePassword.isSelected());
            UserEditor.this.user.setConfig(UserEditor.this.configPanel.getConfigText());
            UserEditor.this.user.setMenuId(UserEditor.this.userMenuPanel.getSelectedId());
            try {
                UserEditor.this.getUserService().updateUser(UserEditor.this.user, Utils.toIntegerList((String)UserEditor.this.groupListPanel.getListValues()));
                UserEditor.this.menuRestrictPanel.updateData();
            }
            catch (BGException ex) {
                ((ClientContext)UserEditor.this.getContext()).processException((Throwable)ex);
            }
            UserEditor.this.setVisible(false);
        }
    };

    public UserEditor() {
    }

    public UserEditor(ClientContext context) {
        super((LayoutManager)new GridBagLayout(), context);
        this.build();
    }

    protected void jbInit() throws Exception {
        BGButtonPanelRestoreOkCancelHelp okCancelPanel = new BGButtonPanelRestoreOkCancelHelp();
        okCancelPanel.addActionListener(e -> this.okCancelPerformed(e));
        this.add(this.getUserInfoPanel(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getTabbedPanel(), new GridBagConstraints(1, 0, 1, 3, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getPasswordPanel(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.getContractPanel(), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)okCancelPanel, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
    }

    private JPanel getContractPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.pidCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0414\u043e\u0433\u043e\u0432\u043e\u0440:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.contractSelect, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0440\u0438\u0432\u044f\u0437\u043a\u0430 \u043a \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0443 "));
        return panel;
    }

    private JPanel getPasswordPanel() {
        this.userPassword1.setMinimumSize(new Dimension(4, 24));
        this.userPassword1.setPreferredSize(new Dimension(4, 24));
        this.userPassword2.setMinimumSize(new Dimension(4, 24));
        this.userPassword2.setOpaque(true);
        this.userPassword2.setPreferredSize(new Dimension(4, 24));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u041f\u0430\u0440\u043e\u043b\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f "));
        panel.add((Component)new JLabel("\u041f\u0430\u0440\u043e\u043b\u044c:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u0434\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u0438\u0435:"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userPassword1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.userPassword2, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 5), 0, 0));
        panel.add((Component)this.needChangePassword, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 0, 0, 5), 0, 0));
        return panel;
    }

    private JPanel getUserInfoPanel() {
        this.statusCombo.addItem((Object)new ComboBoxItem(0, "\u0440\u0430\u0431\u043e\u0442\u0430\u0435\u0442"));
        this.statusCombo.addItem((Object)new ComboBoxItem(1, "\u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d"));
        this.userDescr.setMinimumSize(new Dimension(330, 24));
        this.userDescr.setPreferredSize(new Dimension(330, 24));
        this.userDescr.setColumns(30);
        this.userName.setMinimumSize(new Dimension(330, 24));
        this.userName.setPreferredSize(new Dimension(330, 24));
        this.userName.setColumns(30);
        this.userLogin.setMinimumSize(new Dimension(330, 24));
        this.userLogin.setPreferredSize(new Dimension(330, 24));
        this.userLogin.setColumns(30);
        this.userEmail.setMinimumSize(new Dimension(330, 24));
        this.userEmail.setPreferredSize(new Dimension(330, 24));
        this.userEmail.setColumns(30);
        int row = 0;
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder(" \u0418\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435 "));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userLogin, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 13, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041f\u043e\u043b\u043d\u043e\u0435 \u0438\u043c\u044f:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userName, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("E-mail:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userEmail, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.userDescr, new GridBagConstraints(1, row++, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)new JLabel("\u0421\u0442\u0430\u0442\u0443\u0441:"), new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.statusCombo, new GridBagConstraints(1, row, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JTabbedPane getTabbedPanel() {
        final JComboBox<String> cellEditorComboBox = new JComboBox<String>(this.contractParameterTableModel.getUserEditerItems());
        DefaultCellEditor cellEditor = new DefaultCellEditor(cellEditorComboBox){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                cellEditorComboBox.setSelectedIndex(Utils.parseInt((String)String.valueOf(value)));
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }

            @Override
            public Object getCellEditorValue() {
                return cellEditorComboBox.getSelectedIndex();
            }
        };
        this.groupListPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.actionsPanel.setBorder(BorderFactory.createEmptyBorder(3, 5, 5, 5));
        this.configPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        this.contractGroupList.setToolTipText("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432, \u0441 \u043a\u043e\u0442\u043e\u0440\u044b\u043c\u0438 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u044b \u0432\u044b\u0431\u0440\u0430\u043d\u043d\u044b\u0435 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        this.configPanel.setToolTipText("\u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u0435\u0439");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.contractGroupsModeOr);
        buttonGroup.add(this.contractGroupsModeAnd);
        JPanel contractGroupPanel = new JPanel(new GridBagLayout());
        contractGroupPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        contractGroupPanel.add((Component)new JLabel("\u0420\u0435\u0436\u0438\u043c \u0441\u043e\u0432\u043f\u0430\u0434\u0435\u043d\u0438\u044f:"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 10), 0, 0));
        contractGroupPanel.add((Component)this.contractGroupsModeAnd, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        contractGroupPanel.add((Component)this.contractGroupsModeOr, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        contractGroupPanel.add((Component)this.contractGroupList, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 17, 1, new Insets(3, 0, 0, 0), 0, 0));
        BGUTable contractParameterTable = new BGUTable((TableModel)((Object)this.contractParameterTableModel));
        contractParameterTable.setSelectionMode(0);
        contractParameterTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        contractParameterTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        BGUTable objectParameterTable = new BGUTable((TableModel)((Object)this.objectParameterTableModel));
        objectParameterTable.setSelectionMode(0);
        objectParameterTable.getColumnModel().getColumn(1).setCellEditor(cellEditor);
        objectParameterTable.getColumnModel().getColumn(2).setCellEditor(cellEditor);
        this.tabbedPanel.add((Component)this.groupListPanel, "\u0413\u0440\u0443\u043f\u043f\u044b");
        this.tabbedPanel.add((Component)this.actionsPanel, "\u0414\u0435\u0439\u0441\u0442\u0432\u0438\u044f");
        this.tabbedPanel.add((Component)contractGroupPanel, "\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        this.tabbedPanel.add((Component)new JScrollPane((Component)this.domains), "\u0414\u043e\u043c\u0435\u043d\u044b");
        this.tabbedPanel.add((Component)new JScrollPane((Component)contractParameterTable), "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
        this.tabbedPanel.add((Component)new JScrollPane((Component)objectParameterTable), "\u0414\u043e\u0441\u0442\u0443\u043f \u043a \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0430\u043c \u043e\u0431\u044a\u0435\u043a\u0442\u043e\u0432");
        this.tabbedPanel.add((Component)((Object)this.menuRestrictPanel), "\u041f\u0443\u043d\u043a\u0442\u044b \u043c\u0435\u043d\u044e");
        this.tabbedPanel.add((Component)((Object)this.userMenuPanel), "\u041c\u0435\u043d\u044e");
        this.tabbedPanel.add((Component)this.configPanel, "\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f");
        return this.tabbedPanel;
    }

    private void okCancelPerformed(ActionEvent e) {
        this.lastActionCommand = e.getActionCommand();
        if ("reset".equals(this.lastActionCommand)) {
            this.performAction("refresh");
        } else if ("ok".equals(this.lastActionCommand)) {
            this.performAction("ok");
        } else if ("cancel".equals(this.lastActionCommand)) {
            this.setUser(null);
            this.setVisible(false);
        }
    }

    public void setUser(User user) {
        if (!PANEL_DATA_LOADED) {
            this.temporaryUser = user;
            return;
        }
        this.user = user;
        if (user != null) {
            try {
                user.setActionList(this.getUserService().loadUserActions(user.getId()));
                this.setGroupAction();
                this.userLogin.setText(user.getLogin());
                this.userName.setText(user.getName());
                this.userEmail.setText(user.getEmail());
                this.userDescr.setText(user.getDescription());
                this.userPassword1.setText("passwordpassword");
                this.userPassword2.setText("passwordpassword");
                this.needChangePassword.setSelected(user.isNeedChangePassword());
                HashSet<BGSAction> allActionSet = new HashSet<BGSAction>();
                allActionSet.addAll(user.getActionList());
                allActionSet.addAll(this.groupActionSet);
                this.actionsPanel.setActions(this.getActionStringFromSet(allActionSet));
                this.actionsPanel.setDisabledActions(this.getActionStringFromSet(this.groupActionSet));
                if (this.groupListPanel != null) {
                    ClientUtils.setListSelection((JList)this.groupListPanel.getList(), (String)Utils.toString(user.getUserGroups()));
                }
                if (this.contractGroupList != null) {
                    this.contractGroupList.setListValues(Utils.maskToEnum((long)user.getContractGroups()));
                }
                (user.getContractGroupsMode() > 0 ? this.contractGroupsModeAnd : this.contractGroupsModeOr).setSelected(true);
                this.domains.clearChecked();
                user.getDomainIds().forEach(i -> this.domains.setChecked(i.intValue(), true));
                this.domains.expand();
                this.objectParameterTableModel.setValues(user.getRuleAccessObjectParameter());
                this.contractParameterTableModel.setValues(user.getRuleAccessContractParameter());
                ClientUtils.setComboBoxSelection(this.statusCombo, (int)user.getStatus());
                ClientUtils.setComboBoxSelection(this.pidCombo, (int)user.getContractPid());
                this.contractSelect.setContracts(String.valueOf(user.getContractCid()), user.getContractTitle());
                this.configPanel.setConfigText(user.getConfig());
                this.menuRestrictPanel.setUserOrGroupId(user.getId());
                this.menuRestrictPanel.setData();
                this.userMenuPanel.setSelected(user.getMenuId());
                this.userMenuPanel.setData();
                this.tabbedPanel.setSelectedIndex(0);
            }
            catch (BGException e) {
                ((ClientContext)this.getContext()).processException((Throwable)e);
            }
        } else {
            this.userName.setText("");
            this.userEmail.setText("");
            this.userDescr.setText("");
            this.userLogin.setText("");
            this.userPassword1.setText("");
            this.userPassword2.setText("");
            this.needChangePassword.setSelected(false);
            this.actionsPanel.setActions("");
            this.statusCombo.setSelectedIndex(0);
            this.pidCombo.setSelectedIndex(0);
            this.contractSelect.setContracts("", "");
            this.contractGroupList.setListItemSelected(false);
            this.contractParameterTableModel.setValues(new ArrayList<String>());
            this.objectParameterTableModel.setValues(new ArrayList<String>());
            this.contractGroupsModeOr.setSelected(true);
            this.userMenuPanel.setSelected(-1);
        }
        this.setVisible(true);
    }

    public void setGroupAction() {
        this.groupActionSet.clear();
        String groupList = this.groupListPanel.getListValues();
        StringTokenizer st = new StringTokenizer(groupList, ",");
        while (st.hasMoreTokens()) {
            String f = st.nextToken().trim();
            int groupid = Integer.parseInt(f);
            try {
                String actionsOfGroup = ((UserGroupService)((ClientContext)this.getContext()).getPort(UserGroupService.class)).getActionsOfGroup(groupid);
                this.groupActionSet.addAll(this.getActionListFromString(actionsOfGroup));
            }
            catch (BGException e) {
                ClientUtils.showErrorMessageDialog((Throwable)e);
            }
        }
    }

    private List<BGSAction> getActionListFromString(String str) {
        ArrayList<BGSAction> result = new ArrayList<BGSAction>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            BGSAction action = new BGSAction();
            String[] values = st.nextToken().trim().split("_");
            if (values.length != 2) continue;
            action.mid = values[0];
            action.actionID = Integer.valueOf(values[1]);
            result.add(action);
        }
        return result;
    }

    public String getLastActionCommand() {
        return this.lastActionCommand;
    }

    private String getActionStringFromSet(Set<BGSAction> set) {
        StringBuilder sb = new StringBuilder();
        for (BGSAction val : set) {
            sb.append(val.mid + "_" + val.actionID);
            sb.append(",");
        }
        if (sb.length() > 0) {
            sb.replace(sb.length() - 1, sb.length(), "");
        }
        return sb.toString();
    }

    private UserService getUserService() {
        if (this.userService == null) {
            this.userService = (UserService)((ClientContext)this.getContext()).getPort(UserService.class);
        }
        return this.userService;
    }
}

