/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.webmenu.client;

import bitel.billing.module.admin.DBInfo;
import bitel.billing.module.common.DBInfoManager;
import bitel.billing.module.common.TransferData;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGEditorDialog;
import ru.bitel.bgbilling.client.common.BGTextField;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.common.BGUPanel;
import ru.bitel.bgbilling.client.common.BGUTable;
import ru.bitel.bgbilling.client.common.table.renderer.DecimalTableCellRenderer;
import ru.bitel.bgbilling.client.common.table.renderer.RadioButtonTableCellRenderer;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuEditor;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuTree;
import ru.bitel.bgbilling.kernel.admin.webmenu.client.WebMenuUserObject;
import ru.bitel.bgbilling.kernel.admin.webmenu.common.bean.WebMenuItem;
import ru.bitel.common.client.AbstractBGUPanel;
import ru.bitel.common.client.BGButtonPanel;
import ru.bitel.common.client.list.BGUCheckList;
import ru.bitel.common.client.list.BGUList;
import ru.bitel.common.client.table.BGTableModel;
import ru.bitel.common.model.IdTitle;

public class WebMenuTreeEditor
extends BGUPanel
implements PropertyChangeListener {
    private int webMenuCurrentId = 0;
    private BGUTable webMenuTable = null;
    private WebMenuEditor webMenuEditor;
    private WebMenuTree webMenuTree = null;
    private WebMenuListTableModel menuListModel = null;
    private MenuItemPropertyModel menuItemPropertyModel = null;
    private BGButtonPanel buttonPanel = null;
    private BGUTable table;
    private JSONObject actionOperations;
    private BGUCheckList<IdTitle> operationList = new BGUCheckList();

    public WebMenuTreeEditor(WebMenuEditor webMenuEditor) {
        this.webMenuEditor = webMenuEditor;
    }

    protected void jbInit() throws Exception {
        this.setLayout(new BorderLayout());
        this.add(this.getListPanel(), "West");
        this.add(this.getEditorPanel(), "Center");
    }

    private JPanel getListPanel() {
        this.menuListModel = new WebMenuListTableModel();
        this.webMenuTable = new BGUTable((TableModel)((Object)this.menuListModel));
        this.webMenuTable.setSelectionMode(0);
        this.webMenuTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (WebMenuTreeEditor.this.webMenuTable.isEnabled()) {
                    if (event.getClickCount() == 2) {
                        WebMenuTreeEditor.this.performAction("edit");
                    }
                    WebMenuTreeEditor.this.loadWebMenuTreeData();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0421\u043f\u0438\u0441\u043e\u043a \u043c\u0435\u043d\u044e"));
        panel.add((Component)new JScrollPane((Component)this.webMenuTable), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void loadWebMenuTreeData() {
        try {
            this.webMenuCurrentId = ((WebMenuItem)((Object)this.menuListModel.getSelectedRow())).getId();
            this.webMenuTree.setEnabled(true);
            this.webMenuTree.setData(this.webMenuEditor.getWebMenuService().webMenuDataGet(this.webMenuCurrentId));
            this.menuItemPropertyModel.setData(new ArrayList());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
        }
    }

    private JPanel getEditorPanel() {
        this.buttonPanel = new BGButtonPanel(new BGButtonPanel.ButtonItem[]{BGButtonPanel.RESET, BGButtonPanel.GLUE, new BGButtonPanel.ButtonItem("\u0421\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c", "save"), BGButtonPanel.CANCEL});
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonPanel.setEnabled(false);
        this.buttonPanel.getButton("save").addActionListener(e -> {
            try {
                this.buttonPanel.setEnabled(false);
                this.webMenuEditor.getWebMenuService().webMenuDataUpdate(this.webMenuCurrentId, this.webMenuTree.getData());
                this.webMenuTable.setEnabled(true);
            }
            catch (BGException e1) {
                ClientUtils.showErrorMessageDialog((Throwable)e1);
            }
        });
        this.buttonPanel.getButton(BGButtonPanel.CANCEL).addActionListener(e -> {
            this.webMenuTable.setEnabled(true);
            this.buttonPanel.setEnabled(false);
            this.webMenuTree.setData("");
        });
        this.buttonPanel.getButton(BGButtonPanel.RESET).addActionListener(e -> {
            this.webMenuTable.setEnabled(true);
            this.buttonPanel.setEnabled(false);
            this.webMenuTree.reset();
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getTreePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.getRightPanel(), new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)this.buttonPanel, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getTreePanel() {
        this.webMenuTree = new WebMenuTree();
        this.webMenuTree.setData("");
        this.webMenuTree.setEnabled(false);
        this.webMenuTree.addPropertyChangeListener("changeData", this);
        this.webMenuTree.addPropertyChangeListener("deleteData", this);
        try {
            this.actionOperations = this.webMenuEditor.getWebMenuService().webActionOperations();
            this.webMenuTree.initPopupMenu(this.webMenuEditor.getWebMenuService().webMenuKernelItems(), this.webMenuEditor.getWebMenuService().webMenuModuleItems(), this.webMenuEditor.getWebMenuService().webMenuPluginItems());
        }
        catch (BGException ex) {
            ClientUtils.showErrorMessageDialog((String)ex.getLocalizedMessage());
        }
        this.webMenuTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object selectedObject;
                TreePath treePath = WebMenuTreeEditor.this.webMenuTree.getSelectionPath();
                if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedObject;
                    if (treeNode.isRoot()) {
                        WebMenuTreeEditor.this.menuItemPropertyModel.setData(new ArrayList());
                    } else {
                        Element element = ((WebMenuUserObject)treeNode.getUserObject()).getElement();
                        if ("group".equals(element.getNodeName()) && element.getAttribute("key").isEmpty()) {
                            WebMenuTreeEditor.this.webMenuTree.setKey(element);
                        }
                        String moduleName = null;
                        String action = null;
                        ArrayList list = new ArrayList();
                        NamedNodeMap nodeMap = element.getAttributes();
                        block8: for (int index = 0; index < nodeMap.getLength(); ++index) {
                            Node node = nodeMap.item(index);
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("title", node.getNodeName());
                            map.put("value", node.getNodeValue());
                            list.add(map);
                            switch (node.getNodeName()) {
                                case "action": {
                                    action = node.getNodeValue();
                                    continue block8;
                                }
                                case "moduleName": {
                                    moduleName = node.getNodeValue();
                                }
                            }
                        }
                        if (!list.stream().anyMatch(a -> "icon".equals(a.get("title")))) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("title", "icon");
                            map.put("value", "");
                            list.add(map);
                        }
                        if (!list.stream().anyMatch(a -> "description".equals(a.get("title")))) {
                            HashMap<String, String> map = new HashMap<String, String>();
                            map.put("title", "description");
                            map.put("value", "");
                            list.add(map);
                        }
                        WebMenuTreeEditor.this.menuItemPropertyModel.setData(list);
                        WebMenuTreeEditor.this.setOperationList(moduleName, action);
                    }
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder((Border)new BGTitleBorder("\u0421\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u043c\u0435\u043d\u044e"));
        panel.add((Component)new JScrollPane(this.webMenuTree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getRightPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.getPropertiesPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        panel.add((Component)this.getOperationPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getOperationPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(new TitledBorder("\u0420\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u043d\u044b\u0435 \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0438"));
        panel.add((Component)this.operationList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private JPanel getPropertiesPanel() {
        this.menuItemPropertyModel = new MenuItemPropertyModel();
        this.table = new BGUTable((TableModel)((Object)this.menuItemPropertyModel));
        this.table.setSelectionMode(0);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Map map;
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2 && (map = (Map)WebMenuTreeEditor.this.menuItemPropertyModel.getSelectedRow()) != null) {
                    if ("icon".equals(map.get("title"))) {
                        new IconEditor("\u0412\u044b\u0431\u043e\u0440 \u0444\u0430\u0439\u043b\u0430 \u0441 \u0438\u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u0438\u0435\u043c", map).getDialog().setVisible(true);
                    } else {
                        new PropertyTextEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u0441\u0432\u043e\u0439\u0441\u0442\u0432\u0430", map, "description".equals(map.get("title"))).getDialog().setVisible(true);
                    }
                }
            }
        });
        Dimension dimension = new Dimension(400, 250);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setMinimumSize(dimension);
        panel.setPreferredSize(dimension);
        panel.setBorder((Border)new BGTitleBorder("\u0421\u0432\u043e\u0439\u0441\u0442\u0432\u0430"));
        panel.add((Component)new JScrollPane((Component)this.table), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setOperationList(String name, String action) {
        ArrayList<IdTitle> idTitles = new ArrayList<IdTitle>();
        this.setOperationList(idTitles, this.actionOperations.optJSONArray("modules"), name, action);
        this.setOperationList(idTitles, this.actionOperations.optJSONArray("plugins"), name, action);
        this.operationList.setData(idTitles);
    }

    private void setOperationList(List<IdTitle> idTitles, JSONArray array, String name, String action) {
        if (name != null && action != null) {
            int len = array.length();
            block0: for (int index = 0; index < len; ++index) {
                JSONObject moduleJson = array.getJSONObject(index);
                if (!name.equals(moduleJson.optString("name"))) continue;
                JSONArray actions = moduleJson.optJSONArray("actions");
                int alen = actions.length();
                for (int a = 0; a < alen; ++a) {
                    JSONObject actionJson = actions.getJSONObject(a);
                    if (!action.equals(actionJson.optString("action"))) continue;
                    JSONArray operations = actionJson.optJSONArray("operations");
                    int olen = operations.length();
                    for (int o = 0; o < olen; ++o) {
                        JSONObject operationJson = operations.getJSONObject(o);
                        idTitles.add(new IdTitle(o, operationJson.optString("title")));
                    }
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("deleteData".equals(event.getPropertyName())) {
            this.menuItemPropertyModel.setData(new ArrayList());
        }
        boolean fl = event.getNewValue().equals(event.getOldValue());
        this.webMenuTable.setEnabled(fl);
        this.buttonPanel.setEnabled(!fl);
    }

    protected void initActions() {
        new AbstractBGUPanel.DefaultAction("new", "\u041d\u043e\u0432\u044b\u0439 \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                new MenuEditor("\u041d\u043e\u0432\u043e\u0435 \u043c\u0435\u043d\u044e", new WebMenuItem()).getDialog().setVisible(true);
            }
        };
        new AbstractBGUPanel.DefaultAction("edit", "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u044d\u043b\u0435\u043c\u0435\u043d\u0442"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                WebMenuItem rowData = (WebMenuItem)((Object)WebMenuTreeEditor.this.menuListModel.getSelectedRow());
                if (rowData != null) {
                    new MenuEditor("\u0420\u0435\u0434\u0430\u043a\u0442\u043e\u0440 \u043c\u0435\u043d\u044e", rowData).getDialog().setVisible(true);
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u043c\u0435\u043d\u044e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("delete", "\u0423\u0434\u0430\u043b\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                WebMenuItem rowData = (WebMenuItem)((Object)WebMenuTreeEditor.this.menuListModel.getSelectedRow());
                if (rowData != null && rowData.getCount() == 0) {
                    if (JOptionPane.showConfirmDialog(JOptionPane.getRootFrame(), "\u0412\u044b \u0443\u0432\u0435\u0440\u0435\u043d\u044b, \u0447\u0442\u043e \u0445\u043e\u0442\u0438\u0442\u0435\n\u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u043e\u0435 \u043c\u0435\u043d\u044e?", "\u0421\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435", 0) == 0) {
                        WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().webMenuDataDelete(rowData.getId());
                        WebMenuTreeEditor.this.performAction("refresh");
                    }
                } else {
                    ClientUtils.showErrorMessageDialog((String)"\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435 \u0437\u0430\u043f\u0440\u0435\u0449\u0435\u043d\u043e, \u0442\u0430\u043a \u043a\u0430\u043a\n\u043c\u0435\u043d\u044e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f \u0432 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430\u0445!");
                }
            }
        };
        new AbstractBGUPanel.DefaultAction("refresh", "\u041e\u0431\u043d\u043e\u0432\u0438\u0442\u044c"){

            public void actionPerformedImpl(ActionEvent e) throws Exception {
                WebMenuTreeEditor.this.webMenuTable.setEnabled(true);
                WebMenuTreeEditor.this.menuListModel.setData(WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().webMenuList(true));
            }
        };
    }

    class WebMenuListTableModel
    extends BGTableModel<WebMenuItem> {
        public WebMenuListTableModel() {
            super(WebMenuListTableModel.class.getName());
        }

        protected void initColumns() {
            this.addColumnId();
            this.addColumn("V", 30, 30, 30, "default").setTableCellRenderer((TableCellRenderer)new RadioButtonTableCellRenderer());
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", "title", false);
            this.addColumn("\u0414\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432", 90, 90, 90, "count", false).setTableCellRenderer(DecimalTableCellRenderer.INTEGER);
        }
    }

    class MenuItemPropertyModel
    extends BGTableModel<Map<String, String>> {
        public MenuItemPropertyModel() {
            super(MenuItemPropertyModel.class.getName());
        }

        protected void initColumns() {
            this.addColumn("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435", 150, 150, 150, "title", true);
            this.addColumn("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435", "value", false);
        }
    }

    class IconEditor
    extends BGEditorDialog<Map<String, String>> {
        private BGUList<KeyValue> dirs;
        private BGUList<KeyValue> files;
        private JTextField path;
        private JLabel iconCanvas;

        public IconEditor(String title, Map<String, String> data) {
            super(title, data);
            this.dirs = new BGUList();
            this.files = new BGUList();
            this.path = new JTextField(30);
            this.iconCanvas = new JLabel();
        }

        public void doDialogPanel() {
            this.iconCanvas.setBackground(Color.WHITE);
            this.iconCanvas.setOpaque(true);
            this.panel.add((Component)this.getPathPanel(), new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            this.panel.add((Component)this.getIconPanel(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(10, 5, 0, 0), 0, 0));
            try {
                this.dirs.setData(WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().getIconDirs());
                this.dirs.addListSelectionListener(e -> this.setFilesList());
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        private JPanel getPathPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041e\u0442\u043d\u043e\u0441\u0438\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u043f\u0443\u0442\u044c \u0438\u043b\u0438 URL:"), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.path, new GridBagConstraints(-1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getIconPanel() {
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)this.getDirsPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.getFilesPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.getPreviewPanel(), new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            return panel;
        }

        private JPanel getDirsPanel() {
            Dimension dimension = new Dimension(200, 300);
            JScrollPane scrollPane = new JScrollPane((Component)this.dirs);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            this.dirs.setSelectionMode(0);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041a\u0430\u0442\u0430\u043b\u043e\u0433 (webroot/img/*):"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 10, 0), 0, 0));
            return panel;
        }

        private JPanel getFilesPanel() {
            this.files.setSelectionMode(0);
            Dimension dimension = new Dimension(400, 300);
            JScrollPane scrollPane = new JScrollPane((Component)this.files);
            scrollPane.setMinimumSize(dimension);
            scrollPane.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u0424\u0430\u0439\u043b\u044b:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)scrollPane, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 10, 0), 0, 0));
            return panel;
        }

        private JPanel getPreviewPanel() {
            Dimension dimension = new Dimension(300, 300);
            this.iconCanvas.setMinimumSize(dimension);
            this.iconCanvas.setPreferredSize(dimension);
            JPanel panel = new JPanel(new GridBagLayout());
            panel.add((Component)new JLabel("\u041f\u0440\u0435\u0434\u043f\u0440\u043e\u0441\u043c\u043e\u0442\u0440:"), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 0), 0, 0));
            panel.add((Component)this.iconCanvas, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(2, 0, 10, 0), 0, 0));
            return panel;
        }

        private void setFilesList() {
            Stream.of(this.files.getListSelectionListeners()).forEach(a -> this.files.removeListSelectionListener(a));
            try {
                KeyValue keyValue = (KeyValue)this.dirs.getSelectedValue();
                this.files.setData(keyValue != null ? WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().getIconFiles(keyValue.getKey()) : new ArrayList());
                this.files.addListSelectionListener(a -> {
                    KeyValue selectItem = (KeyValue)this.files.getSelectedValue();
                    if (selectItem != null) {
                        String fileName = keyValue.getValue() + "/" + selectItem.getValue();
                        this.path.setText(fileName);
                        if (!fileName.startsWith("http")) {
                            try {
                                Path tmpPath = Files.createTempFile(fileName.replace('/', '_'), "", new FileAttribute[0]);
                                DBInfo dbInfo = DBInfoManager.getManager().getActiveDBInfo();
                                TransferData transferData = dbInfo != null ? dbInfo.getTransferData() : null;
                                transferData.downloadFile("kernel/0/downloadWebIconFile/" + fileName, 0, 0, tmpPath.toFile());
                                ImageIcon imageIcon = new ImageIcon(tmpPath.toString());
                                Image image = imageIcon.getImage();
                                Image newimg = image.getScaledInstance(300, 300, 4);
                                imageIcon = new ImageIcon(newimg);
                                this.iconCanvas.setIcon(imageIcon);
                            }
                            catch (Exception ex) {
                                ClientUtils.showErrorMessageDialog((Throwable)ex);
                            }
                        }
                    }
                });
            }
            catch (BGException ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
        }

        public boolean doApply() throws Exception {
            Object selectedObject;
            ((Map)this.data).put("value", this.path.getText());
            TreePath treePath = WebMenuTreeEditor.this.webMenuTree.getSelectionPath();
            if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedObject;
                Element element = ((WebMenuUserObject)treeNode.getUserObject()).getElement();
                for (Map map : WebMenuTreeEditor.this.menuItemPropertyModel.getRows()) {
                    element.setAttribute((String)map.get("title"), (String)map.get("value"));
                }
                ((DefaultTreeModel)WebMenuTreeEditor.this.webMenuTree.getModel()).reload(treeNode);
                WebMenuTreeEditor.this.webMenuTree.aa("changeData");
            }
            return true;
        }
    }

    class PropertyTextEditor
    extends BGEditorDialog<Map<String, String>> {
        private JTextField title;
        private JTextField value;
        private boolean isDescription;
        private JTextArea description;

        public PropertyTextEditor(String title, Map<String, String> data, boolean isDescription) {
            super(title, data);
            this.title = new JTextField(40);
            this.value = new JTextField(40);
            this.isDescription = false;
            this.description = new JTextArea(5, 40);
            this.isDescription = isDescription;
        }

        public void doDialogPanel() {
            this.title.setEnabled(false);
            this.description.setMargin(new Insets(3, 3, 3, 3));
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 5), 0, 0));
            this.panel.add((Component)this.title, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)new JLabel("\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 5), 0, 0));
            if (this.isDescription) {
                this.panel.add((Component)new JScrollPane(this.description), new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            } else {
                this.panel.add((Component)this.value, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            }
            this.title.setText((String)((Map)this.data).get("title"));
            if (this.isDescription) {
                this.description.setText((String)((Map)this.data).get("value"));
            } else {
                this.value.setText((String)((Map)this.data).get("value"));
            }
        }

        public boolean doApply() throws Exception {
            Object selectedObject;
            ((Map)this.data).put("value", this.isDescription ? this.description.getText() : this.value.getText());
            TreePath treePath = WebMenuTreeEditor.this.webMenuTree.getSelectionPath();
            if (treePath != null && (selectedObject = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectedObject;
                Element element = ((WebMenuUserObject)treeNode.getUserObject()).getElement();
                for (Map map : WebMenuTreeEditor.this.menuItemPropertyModel.getRows()) {
                    element.setAttribute((String)map.get("title"), (String)map.get("value"));
                }
                ((DefaultTreeModel)WebMenuTreeEditor.this.webMenuTree.getModel()).reload(treeNode);
                WebMenuTreeEditor.this.webMenuTree.aa("changeData");
            }
            return true;
        }
    }

    class MenuEditor
    extends BGEditorDialog<WebMenuItem> {
        private BGTextField webMenuTitle;
        private JCheckBox webMenuDefault;

        public MenuEditor(String title, WebMenuItem data) {
            super(title, (Object)data);
            this.webMenuTitle = new BGTextField(30);
            this.webMenuDefault = new JCheckBox("\u043c\u0435\u043d\u044e \u043f\u043e \u0443\u043c\u043e\u043b\u0447\u0430\u043d\u0438\u044e");
        }

        public void doDialogPanel() {
            this.webMenuTitle.setText(((WebMenuItem)((Object)this.data)).getTitle());
            this.webMenuDefault.setSelected(((WebMenuItem)((Object)this.data)).isDefault());
            WebMenuTreeEditor.this.webMenuCurrentId = ((WebMenuItem)((Object)this.data)).getId();
            this.panel.add((Component)new JLabel("\u041d\u0430\u0437\u0432\u0430\u043d\u0438\u0435:"), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.webMenuTitle, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
            this.panel.add((Component)this.webMenuDefault, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        }

        public boolean doApply() throws Exception {
            if (this.webMenuTitle.getText().trim().isBlank()) {
                ClientUtils.showErrorMessageDialog((String)"\u0412\u0432\u0435\u0434\u0438\u0442\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043c\u0435\u043d\u044e");
                return false;
            }
            ((WebMenuItem)((Object)this.data)).setId(WebMenuTreeEditor.this.webMenuCurrentId);
            ((WebMenuItem)((Object)this.data)).setTitle(this.webMenuTitle.getText());
            ((WebMenuItem)((Object)this.data)).setDefault(this.webMenuDefault.isSelected());
            try {
                this.data = WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().webMenuInfoUpdate((WebMenuItem)((Object)this.data));
                if (WebMenuTreeEditor.this.webMenuCurrentId == 0) {
                    WebMenuTreeEditor.this.menuListModel.addRow((Object)((WebMenuItem)((Object)this.data)));
                    WebMenuTreeEditor.this.menuListModel.setSelectedRow((Object)((WebMenuItem)((Object)this.data)));
                }
                WebMenuTreeEditor.this.menuListModel.setData(WebMenuTreeEditor.this.webMenuEditor.getWebMenuService().webMenuList(true), true);
                WebMenuTreeEditor.this.loadWebMenuTreeData();
            }
            catch (Exception ex) {
                ClientUtils.showErrorMessageDialog((Throwable)ex);
            }
            return true;
        }
    }
}

