/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.load;

import bitel.billing.server.load.BaseLoader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.util.Calendar;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.TimeUtils;

public abstract class LoadOut {
    protected BaseLoader loader;
    protected DefaultServerSetup setup;

    public LoadOut(BaseLoader loader) {
        this.loader = loader;
        this.setup = loader.getSetup();
    }

    public void insertSourceData(Connection con, long size, long lm) {
        try {
            String source_data = "source_data_" + TimeUtils.format((Calendar)this.loader.getHour(), (String)"yyyyMM");
            String query = "CREATE TABLE IF NOT EXISTS " + source_data + " ( source_id int(10) unsigned NOT NULL default '0', dt datetime NOT NULL default '0000-00-00 00:00:00', size bigint(20) NOT NULL default '0', modtime bigint(20) NOT NULL default '0', process tinyint(4) NOT NULL default '0', KEY source_id (source_id,dt) )";
            Statement st = con.createStatement();
            st.execute(query);
            st.close();
            String dateTime = TimeUtils.format((Calendar)this.loader.getHour(), (String)"yyyy'-'MM'-'dd HH':00:00'");
            query = "UPDATE " + source_data + " SET size=?, modtime=? WHERE source_id=? AND dt=?";
            PreparedStatement psUpdateSourceData = con.prepareStatement(query);
            psUpdateSourceData.setLong(1, size);
            psUpdateSourceData.setLong(2, lm);
            psUpdateSourceData.setInt(3, this.loader.getSource().getId());
            psUpdateSourceData.setString(4, dateTime);
            if (psUpdateSourceData.executeUpdate() == 0) {
                query = "INSERT INTO " + source_data + " ( source_id, dt, size, modtime ) VALUES ( ?, ?, ?, ? )";
                PreparedStatement psInsertSourceData = con.prepareStatement(query);
                psInsertSourceData.setInt(1, this.loader.getSource().getId());
                psInsertSourceData.setString(2, dateTime);
                psInsertSourceData.setLong(3, size);
                psInsertSourceData.setLong(4, lm);
                psInsertSourceData.executeUpdate();
                psInsertSourceData.close();
            }
            psUpdateSourceData.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public void addProcessTask(Connection con) {
        this.addProcessTask(con, true);
    }

    public void addProcessTask(Connection con, boolean addProcessTask) {
        try {
            String dateTime = TimeUtils.format((Calendar)this.loader.getHour(), (String)"yyyy'-'MM'-'dd HH':00:00'");
            String query = "DELETE FROM task_load WHERE id=? OR count<=0";
            PreparedStatement psDeleteTaskLoad = con.prepareStatement(query);
            psDeleteTaskLoad.setInt(1, this.loader.getTaskId());
            psDeleteTaskLoad.executeUpdate();
            psDeleteTaskLoad.close();
            if (addProcessTask) {
                query = "DELETE FROM task_proccess WHERE mid=? AND dt=? AND param=?";
                PreparedStatement psDeleteTaskProccess = con.prepareStatement(query);
                psDeleteTaskProccess.setInt(1, this.loader.getSource().getMid());
                psDeleteTaskProccess.setString(2, dateTime);
                psDeleteTaskProccess.setInt(3, this.loader.getSource().getId());
                psDeleteTaskProccess.executeUpdate();
                psDeleteTaskProccess.close();
                query = "INSERT INTO task_proccess ( mid, dt, param ) VALUES ( ?, ?, ? )";
                PreparedStatement psInsertTaskProccess = con.prepareStatement(query);
                psInsertTaskProccess.setInt(1, this.loader.getSource().getMid());
                psInsertTaskProccess.setString(2, dateTime);
                psInsertTaskProccess.setInt(3, this.loader.getSource().getId());
                psInsertTaskProccess.executeUpdate();
                psInsertTaskProccess.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void prepareInsert(Connection con) {
    }

    public abstract void addRecord(Object var1);

    public void finishLoad() {
    }

    public long getFileTime() {
        return 0L;
    }

    public long getFileSize() {
        return 0L;
    }
}

