/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.client;

import bitel.billing.module.common.BGComboBox;
import bitel.billing.module.common.ComboBoxItem;
import bitel.billing.module.common.IntTextField;
import bitel.billing.module.contract.directory.AddressList;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.common.BGTitleBorder;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.bean.Request;
import ru.bitel.common.XMLUtils;

public class GateFilterPanel
extends BGPanel {
    private BGComboBox<ComboBoxItem> type = new BGComboBox();
    private BGComboBox<ComboBoxItem> cityComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> areaComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> streetComboBox = new BGComboBox();
    private BGComboBox<ComboBoxItem> quarterComboBox = new BGComboBox();
    private IntTextField podField = new IntTextField();
    private IntTextField houseField = new IntTextField();
    private IntTextField floorField = new IntTextField();
    private JTextField host = new JTextField();
    private JTextField comment = new JTextField();
    private JTextField fracField = new JTextField();
    private boolean filterWasInit = false;
    private AddressList areasList = null;
    private AddressList quartersList = null;
    private AddressList streetsList = null;
    private BGPanel parentPanel = null;

    public GateFilterPanel(BGPanel parentPanel) {
        this.initGUI();
        this.parentPanel = parentPanel;
    }

    private void initGUI() {
        this.setLayout(new GridBagLayout());
        JPanel addressFilter = this.createAddressPanel();
        JPanel gateFilterPanel = this.createGateFilterPanel();
        JButton applyButton = new JButton();
        applyButton.setText("\u041d\u0430\u0439\u0442\u0438");
        applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateFilterPanel.this.parentPanel.setData();
            }
        });
        JButton reserButton = new JButton();
        reserButton.setText("\u0421\u0431\u0440\u043e\u0441");
        reserButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateFilterPanel.this.cityComboBox.setSelectedIndex(0);
                GateFilterPanel.this.streetComboBox.setSelectedIndex(0);
                GateFilterPanel.this.quarterComboBox.setSelectedIndex(0);
                GateFilterPanel.this.areaComboBox.setSelectedIndex(0);
                GateFilterPanel.this.houseField.setText(null);
                GateFilterPanel.this.fracField.setText(null);
                GateFilterPanel.this.houseField.setText(null);
                GateFilterPanel.this.podField.setText(null);
                GateFilterPanel.this.floorField.setText(null);
                GateFilterPanel.this.host.setText(null);
                GateFilterPanel.this.comment.setText(null);
                GateFilterPanel.this.type.setSelectedIndex(0);
            }
        });
        this.add(gateFilterPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(addressFilter, new GridBagConstraints(0, 1, 3, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(applyButton, new GridBagConstraints(1, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(reserButton, new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private JPanel createGateFilterPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        JLabel hostLabel = new JLabel();
        hostLabel.setText(" \u0425\u043e\u0441\u0442: ");
        JLabel typeLabel = new JLabel();
        typeLabel.setText(" \u0422\u0438\u043f: ");
        JLabel commentLabel = new JLabel();
        commentLabel.setText(" \u041a\u043e\u043c\u043c\u0435\u043d\u0442\u0430\u0440\u0438\u0439: ");
        result.add((Component)hostLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)this.host, new GridBagConstraints(0, 1, 1, 1, 0.1, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)typeLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)this.type, new GridBagConstraints(1, 1, 1, 1, 0.1, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)commentLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        result.add((Component)this.comment, new GridBagConstraints(2, 1, 1, 1, 0.8, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
        return result;
    }

    private JPanel createAddressPanel() {
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new GridBagLayout());
        filterPanel.setBorder((Border)new BGTitleBorder("\u0410\u0434\u0440\u0435\u0441"));
        this.fracField.setCaretColor(Color.black);
        this.fracField.setEditable(true);
        this.fracField.setHorizontalAlignment(0);
        this.fracField.setColumns(7);
        this.fracField.setMaximumSize(new Dimension(70, 25));
        this.houseField.setColumns(7);
        this.houseField.setMaximumSize(new Dimension(70, 25));
        JLabel cityLabel = new JLabel();
        JLabel streetLabel = new JLabel();
        JLabel areaLabel = new JLabel();
        JLabel quarterLabel = new JLabel();
        JLabel houseLabel = new JLabel();
        JLabel podLabel = new JLabel();
        JLabel floorLabel = new JLabel();
        cityLabel.setText(" \u0413\u043e\u0440\u043e\u0434: ");
        streetLabel.setText(" \u0423\u043b\u0438\u0446\u0430: ");
        areaLabel.setText(" \u0420\u0430\u0439\u043e\u043d: ");
        quarterLabel.setText(" \u041a\u0432\u0430\u0440\u0442\u0430\u043b: ");
        houseLabel.setText(" \u0414\u043e\u043c / \u0414\u0440\u043e\u0431\u044c: ");
        podLabel.setText(" \u041f\u043e\u0434\u044a\u0435\u0434 ");
        floorLabel.setText(" \u042d\u0442\u0430\u0436 ");
        this.cityComboBox.setMaximumSize(new Dimension(120, 24));
        this.cityComboBox.setPreferredSize(new Dimension(120, 24));
        this.streetComboBox.setMaximumSize(new Dimension(120, 24));
        this.streetComboBox.setPreferredSize(new Dimension(120, 24));
        filterPanel.add((Component)cityLabel, new GridBagConstraints(0, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.cityComboBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)areaLabel, new GridBagConstraints(1, 0, 2, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.areaComboBox, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)quarterLabel, new GridBagConstraints(3, 0, 2, 1, 0.3, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.quarterComboBox, new GridBagConstraints(3, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)streetLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.streetComboBox, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)houseLabel, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.houseField, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)this.fracField, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)podLabel, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.podField, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        filterPanel.add((Component)floorLabel, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        filterPanel.add((Component)this.floorField, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.cityComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GateFilterPanel.this.setAddressToFilter();
            }
        });
        return filterPanel;
    }

    public void initFilter() {
        if (!this.filterWasInit) {
            Request request = new Request();
            request.setModule("admin");
            request.setAction("GetAddressInfo");
            Document doc = this.getDocument(request);
            if (ClientUtils.checkStatus((Document)doc)) {
                this.areasList = new AddressList(XMLUtils.getNode((Document)doc, (String)"areas"));
                this.streetsList = new AddressList(XMLUtils.getNode((Document)doc, (String)"streets"));
                this.quartersList = new AddressList(XMLUtils.getNode((Document)doc, (String)"quarters"));
                ClientUtils.buildComboBox(this.cityComboBox, (Node)XMLUtils.getNode((Document)doc, (String)"cities"), null);
                ComboBoxItem comboBoxItem = new ComboBoxItem((Object)"0", "\u043b\u044e\u0431\u043e\u0439");
                ((DefaultComboBoxModel)this.cityComboBox.getModel()).insertElementAt(comboBoxItem, 0);
                ((DefaultComboBoxModel)this.cityComboBox.getModel()).setSelectedItem(comboBoxItem);
                this.filterWasInit = true;
            }
            Request req = new Request();
            req.setModule(this.module);
            req.setModuleId(this.getModuleId());
            req.setAction("GateTypeList");
            doc = this.getDocument(req);
            if (ClientUtils.checkStatus((Document)doc)) {
                ClientUtils.buildComboBox(this.type, (Node)XMLUtils.getElement((Document)doc, (String)"list"), (String)"");
                this.type.insertItemAt((Object)new ComboBoxItem((Object)"0", "\u041f\u0430\u043f\u043a\u0430"), 0);
                this.type.insertItemAt((Object)new ComboBoxItem((Object)"-1", "\u041b\u044e\u0431\u043e\u0439"), 0);
                this.type.setSelectedIndex(0);
                this.filterWasInit = true;
            }
        }
    }

    private void setAddressToFilter() {
        int cityid = Integer.valueOf(((ComboBoxItem)this.cityComboBox.getSelectedItem()).getObject().toString());
        this.areasList.buildComboBox(this.areaComboBox, cityid, true, false);
        this.quartersList.buildComboBox(this.quarterComboBox, cityid, true, false);
        this.streetsList.buildComboBox(this.streetComboBox, cityid, true, false);
    }

    public void setData() {
        this.initFilter();
    }

    public void addFilterParams(Request request) {
        request.setAttribute("host", this.host.getText());
        ComboBoxItem item = (ComboBoxItem)this.type.getSelectedItem();
        request.setAttribute("type", ((ComboBoxItem)this.type.getSelectedItem()).getObject());
        request.setAttribute("comment", this.comment.getText());
        request.setAttribute("cityId", ((ComboBoxItem)this.cityComboBox.getSelectedItem()).getObject());
        request.setAttribute("steetId", ((ComboBoxItem)this.streetComboBox.getSelectedItem()).getObject());
        request.setAttribute("areaId", ((ComboBoxItem)this.areaComboBox.getSelectedItem()).getObject());
        request.setAttribute("quarterId", ((ComboBoxItem)this.quarterComboBox.getSelectedItem()).getObject());
        request.setAttribute("house", this.houseField.getValue());
        request.setAttribute("frac", this.fracField.getText());
        request.setAttribute("pod", this.podField.getValue());
        request.setAttribute("floor", this.floorField.getValue());
    }
}

