/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.ipn.server.bean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;

public class AclOptions {
    public int id;
    public String name;
    public int fromPos;
    public int onContact;
    public int toPos;
    public Map<Integer, Set<Integer>> openRulesFrom = new HashMap<Integer, Set<Integer>>();
    public List<String> commands = new ArrayList<String>();

    public static Map<Integer, AclOptions> getAclMapById(Preferences defaultSetup) {
        Map aclOptions = defaultSetup.parseObjectsNoOrder("acl.");
        HashMap<Integer, AclOptions> aclMap = new HashMap<Integer, AclOptions>();
        for (Map.Entry me : aclOptions.entrySet()) {
            Map params;
            int id = Utils.parseInt((String)((String)me.getKey()), (int)0);
            AclOptions options = AclOptions.getAclOption(id, params = (Map)me.getValue());
            if (options == null) continue;
            aclMap.put(id, options);
        }
        return aclMap;
    }

    private static AclOptions getAclOption(int id, Map<String, String> params) {
        AclOptions options = new AclOptions();
        options.id = id;
        options.name = params.get("name");
        options.fromPos = Utils.parseInt((String)params.get("from.pos"), (int)100);
        options.toPos = Utils.parseInt((String)params.get("to.pos"), (int)10000000);
        options.onContact = Utils.parseInt((String)params.get("on.contract"), (int)100);
        if (id <= 0 || Utils.isBlankString((String)options.name)) {
            options = null;
        }
        return options;
    }

    public static List<AclOptions> getAclList(Preferences gateSetup) {
        ArrayList<AclOptions> result = new ArrayList<AclOptions>();
        Map aclOptions = gateSetup.parseObjectsNoOrder("acl.");
        for (Map.Entry me : aclOptions.entrySet()) {
            Map params;
            int id = Utils.parseInt((String)((String)me.getKey()), (int)0);
            AclOptions options = AclOptions.getAclOption(id, params = (Map)me.getValue());
            if (options == null) continue;
            result.add(options);
        }
        Comparator<AclOptions> cp = new Comparator<AclOptions>(){

            @Override
            public int compare(AclOptions o1, AclOptions o2) {
                return o1.name.compareTo(o2.name);
            }
        };
        Collections.sort(result, cp);
        return result;
    }
}

