/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.netflow.ipn.detail;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.netflow.ipn.detail.DialUpRowSelector;
import bitel.billing.server.netflow.ipn.detail.IPNRowSelector;
import bitel.billing.server.netflow.ipn.detail.RowSelector;
import bitel.billing.server.util.MailMsg;
import java.io.File;
import java.io.PrintStream;
import java.sql.Connection;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.bean.IPUtils;
import ru.bitel.bgbilling.kernel.network.datalog.IPDataLogUtils;
import ru.bitel.bgbilling.kernel.network.datalog.hourly.IPHourlyDataLog;
import ru.bitel.bgbilling.kernel.network.flow.Data;
import ru.bitel.bgbilling.modules.ipn.server.bean.DetailCreateTask;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class FlowDetailMaker {
    private static final Logger logger = LogManager.getLogger();

    protected void sendAlarm(String subject, String text) {
        String key = "ipn.collector.detailmaker";
        long time = System.currentTimeMillis();
        if (AlarmSender.needAlarmSend((String)"ipn.collector.detailmaker", (long)time, (long)0L)) {
            AlarmErrorMessage message = new AlarmErrorMessage("ipn.collector.detailmaker", subject, text);
            AlarmSender.sendAlarm((AlarmErrorMessage)message, (long)time);
        }
    }

    protected File getTempDirectory(ParameterMap setup, String name) {
        StringBuilder fileName = new StringBuilder();
        File dir = new File(new File("temp", "detail"), name);
        if (!dir.exists() && !dir.mkdirs()) {
            this.sendAlarm("\u041e\u0448\u0438\u0431\u043a\u0430 \u0441\u043e\u0437\u0434\u0430\u043d\u0438\u044f \u0434\u0438\u0440\u0435\u043a\u0442\u043e\u0440\u0438\u0438", fileName.toString());
        }
        return dir.exists() ? dir : null;
    }

    public void createDetail(DefaultServerSetup setup, Connection con, DetailCreateTask task) throws Exception {
        RowSelector selector;
        String subject;
        if (task.getModule() == 1) {
            subject = "Session traffic detail";
            selector = new DialUpRowSelector(task, (ParameterMap)setup);
        } else {
            subject = "IPN traffic detail";
            selector = new IPNRowSelector(task);
        }
        long startTime = System.currentTimeMillis();
        Iterable logs = IPDataLogUtils.newIPHourlyDataLogIterable((ParameterMap)setup, (String)"log.dir", (int)task.getSourceId(), selector.getLogHours());
        logger.info(Utils.memoryStatus());
        this.sendDetail(setup, con, task, selector, logs, subject);
        logger.info(Utils.memoryStatus());
        long endCreateTime = System.currentTimeMillis();
        logger.info("Detail created and sended by " + (endCreateTime - startTime) + ", sending to " + task.getEmail());
    }

    protected StringBuilder getMessageBody(DetailCreateTask task) {
        StringBuilder messageBody = new StringBuilder();
        if (task.getModule() == 1) {
            messageBody.append("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0441\u0435\u0441\u0441\u0438\u0438 \u043b\u043e\u0433\u0438\u043d\u0430 ");
            messageBody.append(task.getDialupLogin());
            messageBody.append(" \u0441 ");
            messageBody.append(TimeUtils.format((Calendar)task.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss"));
            messageBody.append(" \u043f\u043e ");
            messageBody.append(TimeUtils.format((Calendar)task.getSessionEnd(), (String)"dd.MM.yyyy HH:mm:ss"));
            messageBody.append("\n");
        } else {
            messageBody.append("\u0414\u0435\u0442\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f \u0442\u0440\u0430\u0444\u0438\u043a\u0430 \u0430\u0434\u0440\u0435\u0441\u043e\u0432 ");
            messageBody.append(IPUtils.convertLongIpToString((long)task.getIpnFromAddr()));
            messageBody.append("-");
            messageBody.append(IPUtils.convertLongIpToString((long)task.getIpnToAddr()));
            messageBody.append("\n");
            messageBody.append("\u0417\u0430: ");
            if (task.isMonthPeriod()) {
                messageBody.append(TimeUtils.format((Calendar)task.getSessionStart(), (String)"dd.MM.yyyy"));
                messageBody.append(" - ");
                messageBody.append(TimeUtils.format((Calendar)task.getSessionEnd(), (String)"dd.MM.yyyy"));
            } else {
                messageBody.append(TimeUtils.format((Calendar)task.getIpnHour(), (String)"dd.MM.yyyy HH"));
            }
            messageBody.append("\n");
        }
        return messageBody;
    }

    protected void sendDetail(DefaultServerSetup setup, Connection con, DetailCreateTask task, RowSelector selector, Iterable<IPHourlyDataLog> logs, String subject) throws Exception {
        if (task.getModule() == 1) {
            logger.info("Creating dialup session detail login " + task.getDialupLogin() + " from " + TimeUtils.format((Calendar)task.getSessionStart(), (String)"dd.MM.yyyy HH:mm:ss"));
        } else {
            logger.info("Creating ipn detail range " + IPUtils.convertLongIpToString((long)task.getIpnFromAddr()) + "-" + IPUtils.convertLongIpToString((long)task.getIpnToAddr()) + " from " + TimeUtils.format((Calendar)task.getIpnHour(), (String)"dd.MM.yyyy HH:mm:ss"));
        }
        StringBuilder messageBody = this.getMessageBody(task);
        this.sendDetailImpl(setup, con, task, selector, logs, messageBody, subject);
    }

    protected void sendDetailMail(DefaultServerSetup setup, DetailCreateTask task, String subject, StringBuilder messageBody, MimeBodyPart attach) throws BGException {
        MimeMultipart multipart = new MimeMultipart();
        try {
            if (attach != null) {
                multipart.addBodyPart((BodyPart)attach);
            }
            MimeBodyPart text = new MimeBodyPart();
            text.setText(messageBody.toString(), "utf-8");
            multipart.addBodyPart((BodyPart)text);
        }
        catch (MessagingException e) {
            throw new BGException((Throwable)e);
        }
        logger.info("Detail sending to " + task.getEmail() + "; subject " + subject);
        MailMsg msg = new MailMsg((Preferences)setup);
        msg.sendMessage(task.getEmail(), subject, (Multipart)multipart);
    }

    public void init(ParameterMap setup) {
    }

    protected final void printToCsv(PrintStream csvReport, Data flow, DateFormat dateFormat) {
        csvReport.append(TimeUtils.format((Date)new Date(flow.getMilliseconds()), (DateFormat)dateFormat));
        csvReport.append(";");
        csvReport.append(IPUtils.convertLongIpToString((long)flow.getSrcAddress()));
        csvReport.append(";");
        csvReport.print(flow.getSrcPort());
        csvReport.append(";");
        csvReport.append(IPUtils.convertLongIpToString((long)flow.getDstAddress()));
        csvReport.append(";");
        csvReport.print(flow.getDstPort());
        csvReport.append(";");
        csvReport.print(flow.getOctets());
        csvReport.append(";");
        csvReport.print(flow.getInputInterface());
        csvReport.append(";");
        csvReport.print(flow.getOutputInterface());
        csvReport.append("\n");
    }

    protected abstract void sendDetailImpl(DefaultServerSetup var1, Connection var2, DetailCreateTask var3, RowSelector var4, Iterable<IPHourlyDataLog> var5, StringBuilder var6, String var7) throws Exception;
}

