/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.inet.accounting.recalculate;

import java.util.Map;
import ru.bitel.bgbilling.apps.inet.accounting.Accounting;
import ru.bitel.bgbilling.apps.inet.accounting.InetConnectionRuntime;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.bgbilling.modules.inet.common.bean.AccountingTrafficAmount;
import ru.bitel.bgbilling.modules.inet.common.bean.InetSessionLog;
import ru.bitel.bgbilling.modules.inet.server.InetUtils;
import ru.bitel.bgbilling.modules.inet.server.runtime.InetServRuntime;
import ru.bitel.bgbilling.modules.inet.server.runtime.device.InetDeviceRuntime;
import ru.bitel.common.sql.ConnectionSet;

public class InetConnectionRecalculateRuntime
extends InetConnectionRuntime {
    private final String realm;

    public InetConnectionRecalculateRuntime(Accounting accounting, InetServRuntime inetServRuntime, InetSessionLog session) throws BGException {
        super(accounting, false, inetServRuntime, session.toConnection(), session.toSession());
        this.realm = inetServRuntime.inetServTypeRef.get().inetServType.getSessionInitiationType() == 1 ? null : InetUtils.getRealm(session.getUsername());
    }

    @Override
    public void addTraffics(int agentDeviceId, Long hour, Map<Integer, AccountingTrafficAmount> traffics) {
        boolean addToCalculate = ((InetDeviceRuntime)this.inetDeviceRuntimeRef.get()).sessionSplitOnDeviceState ? this.sessionDeviceState == 1 : true;
        super.addTraffics(agentDeviceId, hour, traffics, addToCalculate);
    }

    @Override
    public boolean tryFinish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, long now, long nowMillis) throws BGException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void finish(Accounting accounting, ConnectionSet connectionSet, BalanceDao balanceDao, boolean needStop, long nowMillis, boolean force) throws BGException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getRealm() {
        return this.realm;
    }
}

