/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.gazprombank.server;

import bitel.billing.server.ModuleBase;
import java.math.BigDecimal;
import java.sql.Connection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.autopayment.common.bean.Autopayment;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.events.system.ContractCreateEvent;
import ru.bitel.bgbilling.kernel.event.events.system.ContractDeleteEvent;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.AutopaymentManager;
import ru.bitel.bgbilling.modules.gazprombank.server.bean.TransactionManager;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankAutopaymentEvent;
import ru.bitel.bgbilling.modules.gazprombank.server.event.GazprombankCheckEvent;

public class Module
extends ModuleBase {
    private static final Logger log = LogManager.getLogger();

    public String[] getServerPackages() {
        return new String[]{"ru.bitel.bgbilling.modules.gazprombank.server"};
    }

    public void start(Connection con, final BGModule module) throws BGException {
        EventProcessor.getInstance().addListener((EventListener)new EventListener<GazprombankCheckEvent>(){

            public void notify(GazprombankCheckEvent event, EventListenerContext ctx) throws BGException {
                int moduleId = module.getId();
                Connection con = ctx.getConnection();
                TransactionManager transactionManager = new TransactionManager(con, moduleId);
                transactionManager.doCheckRequest(event.getContractId(), null);
                transactionManager.close();
            }
        }, GazprombankCheckEvent.class);
        EventProcessor.getInstance().addListener((EventListener)new EventListener<GazprombankAutopaymentEvent>(){

            public void notify(GazprombankAutopaymentEvent event, EventListenerContext ctx) throws BGException {
                int moduleId = module.getId();
                int contractId = event.getContractId();
                Connection con = ctx.getConnection();
                AutopaymentManager autopaymentManager = new AutopaymentManager(con, moduleId);
                Autopayment autopayment = autopaymentManager.getCurrentAutopayment(contractId);
                autopaymentManager.close();
                BigDecimal sum = event.getSum();
                if (sum == null) {
                    sum = autopayment.getSum();
                }
                if (autopayment != null && autopayment.getMode().getCode() == event.getMode()) {
                    ContractDao contractDao = new ContractDao(con, 0);
                    Contract contract = (Contract)contractDao.get(contractId);
                    contractDao.close();
                    if (contract != null) {
                        TransactionManager transactionManager = new TransactionManager(con, moduleId);
                        transactionManager.doAutopayment(contractId, contract.getTitle(), sum, autopayment);
                        transactionManager.close();
                    }
                }
            }
        }, GazprombankAutopaymentEvent.class);
    }

    public void moduleAction(ServerContext serverContext, int moduleId, Event event) throws Exception {
        super.moduleAction(serverContext, moduleId, event);
        int contractId = event.getContractId();
        try {
            ContractDeleteEvent contractDeleteEvent;
            Connection con = serverContext.getConnection();
            if (event instanceof ContractCreateEvent) {
                ContractCreateEvent contractCreateEvent = (ContractCreateEvent)event;
                if (!contractCreateEvent.isCheck()) {
                    this.enableAutopayment(contractCreateEvent.getPattern().getData(), "gazprombank", moduleId, contractId, con, serverContext.getUserId());
                }
            } else if (event instanceof ContractDeleteEvent && !(contractDeleteEvent = (ContractDeleteEvent)event).isCheck()) {
                this.removeAutopayment(moduleId, contractId, con);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

