/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.drweb.server.bean;

import java.math.BigDecimal;
import java.sql.Connection;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.modules.drweb.common.bean.AgentAVD;
import ru.bitel.bgbilling.modules.drweb.common.bean.TariffAVD;
import ru.bitel.bgbilling.modules.drweb.server.bean.AgentAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.TariffAVDManager;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDesc10;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDesc4;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDesc6;
import ru.bitel.bgbilling.modules.drweb.server.bean.api.AVDescAPI;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class DrWebManager {
    private static final Logger log = LogManager.getLogger();
    private Connection con;
    private String errorBalance = null;
    private boolean graceperiod = true;
    private int maxAgentCount = -1;
    private String maxAgentCountMessage = null;
    TariffAVDManager tariffManager = null;
    AgentAVDManager agentManager = null;
    private AVDescAPI serverAPI;

    public DrWebManager(Connection con, ParameterMap moduleSetup, int moduleId) {
        this.con = con;
        this.errorBalance = moduleSetup.get("drweb.error.balance.message", "\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0434\u0435\u043d\u0435\u0433 \u043d\u0430 \u0441\u0447\u0435\u0442\u0435");
        this.graceperiod = !moduleSetup.get("graceperiod", "yes").toLowerCase().equals("no");
        this.maxAgentCount = moduleSetup.getInt("drweb.agent.max.count", -1);
        this.maxAgentCountMessage = moduleSetup.get("drweb.error.max.count.message", "\u0412\u044b \u043f\u0440\u0435\u0432\u044b\u0441\u0438\u043b\u0438 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u0430\u0433\u0435\u043d\u0442\u043e\u0432");
        this.tariffManager = new TariffAVDManager(con, moduleId);
        this.agentManager = new AgentAVDManager(con, moduleId);
        int apiVersion = moduleSetup.getInt("drweb.api.version", 4);
        if (apiVersion == 10) {
            this.serverAPI = new AVDesc10(con, moduleSetup, moduleId, this.agentManager);
        } else if (apiVersion == 6) {
            this.serverAPI = new AVDesc6(con, moduleSetup, moduleId, this.agentManager);
        } else if (apiVersion == 4) {
            this.serverAPI = new AVDesc4(con, moduleSetup, moduleId, this.agentManager);
        }
    }

    private boolean checkBalance(int contractId) {
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            boolean bl = balanceUtils.getBalance(new Date(), contractId).compareTo(BigDecimal.ZERO) > 0;
            return bl;
        }
    }

    public AgentAVD newAgent(int contractId, int tariffId) throws BGException {
        TariffAVD tariff = (TariffAVD)this.tariffManager.get(tariffId);
        if (!this.graceperiod && !this.checkBalance(contractId)) {
            throw new BGException(this.errorBalance);
        }
        if (tariff == null) {
            throw new BGException("\u0422\u0430\u0440\u0438\u0444 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d, \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0443");
        }
        AgentAVD agent = this.serverAPI.getAgentFromAVD(contractId, tariff.getGroupTitle());
        agent.setGraceperiod(this.graceperiod);
        agent.setExpires(TimeUtils.convertLocalDateToDate((LocalDate)LocalDate.now().minusDays(1L)));
        agent.setTariffId(tariff.getId());
        agent.setContractId(contractId);
        agent.setStatus(1);
        agent.setNewAgent(true);
        this.agentManager.update(agent);
        return agent;
    }

    public List<AgentAVD> getAgentList(int cid) throws BGException {
        this.serverAPI.sinchronizeAgent(cid);
        List<AgentAVD> list = this.agentManager.getListById(cid);
        this.setTariffs(list);
        return list;
    }

    private void setTariffs(List<AgentAVD> list) throws BGException {
        Map<Integer, TariffAVD> tariffMap = this.tariffManager.getTariffMap();
        Iterator<AgentAVD> iterator = list.iterator();
        while (iterator.hasNext()) {
            AgentAVD agent;
            TariffAVD tariff = tariffMap.get((agent = iterator.next()).getTariffId());
            agent.setTariffTitle(tariff != null ? tariff.getTitle() : "\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
            tariff = tariffMap.get(agent.getNextTariffId());
            if (tariff == null) continue;
            agent.setNextTariffTitle(tariff.getTitle());
        }
    }

    public List<AgentAVD> getAgentListAll() throws BGException {
        List<AgentAVD> list = this.agentManager.getListAll();
        this.setTariffs(list);
        return list;
    }

    public AgentAVD getAgent(int id) throws BGException {
        AgentAVD agent = (AgentAVD)this.agentManager.get(id);
        if (agent == null) {
            return agent;
        }
        ArrayList<AgentAVD> list = new ArrayList<AgentAVD>();
        list.add(agent);
        this.setTariffs(list);
        return agent;
    }

    public List<AgentAVD> getAgentList(Date date) throws BGException {
        this.serverAPI.sinchronizeAgent(-1);
        List<AgentAVD> list = this.agentManager.getListByDate(date);
        return list;
    }

    public List<AgentAVD> getLockAgent() throws BGException {
        this.serverAPI.sinchronizeAgent(-1);
        List<AgentAVD> list = this.agentManager.getListLockAgent();
        return list;
    }

    public void prolongAgent(AgentAVD agent, Date dateTo) {
        int contractId = agent.getContractId();
        switch (agent.getNextStatus()) {
            case 0: 
            case 3: 
            case 4: {
                try {
                    agent.setLock(true);
                    agent.setBlockBegin(null);
                    agent.setBlockEnd(null);
                    if (this.checkBalance(contractId)) {
                        this.serverAPI.prolongAgentOnAVD(agent, null);
                        agent.setExpires(dateTo);
                        agent.setStatus(1);
                        this.agentManager.update(agent);
                        break;
                    }
                    this.serverAPI.prolongAgentOnAVD(agent, agent.getExpires());
                    agent.setStatus(2);
                    this.agentManager.update(agent);
                }
                catch (BGException ex) {
                    log.error("Error prolong drweb agent", (Throwable)ex);
                    this.setAgentToError(agent);
                }
                break;
            }
            case 1: {
                try {
                    this.serverAPI.blockOnAVD(agent, agent.getBlockBegin(), agent.getBlockEnd());
                    agent.setLock(true);
                    agent.setExpires(agent.getBlockEnd());
                    agent.setStatus(4);
                    agent.setNextStatus(4);
                    this.agentManager.update(agent);
                }
                catch (BGException e) {
                    log.error((Object)e);
                    this.setAgentToError(agent);
                }
                break;
            }
            case 2: {
                try {
                    agent.setExpires(agent.getExpires());
                    agent.setStatus(3);
                    agent.setNextStatus(2);
                    this.agentManager.update(agent);
                    break;
                }
                catch (BGException e) {
                    log.error((Object)e);
                    this.setAgentToError(agent);
                }
            }
        }
    }

    private void setAgentToError(AgentAVD agent) {
        try {
            this.serverAPI.prolongAgentOnAVD(agent, agent.getExpires());
            agent.setStatus(-1);
        }
        catch (BGException e) {
            log.error((Object)e);
            agent.setStatus(-2);
        }
        try {
            this.agentManager.update(agent);
        }
        catch (BGException e) {
            log.error((Object)e);
        }
    }

    public void blockAgent(AgentAVD agent, int monthCount) throws BGException {
        if (agent.getStatus() == 4 || agent.getStatus() == 3) {
            return;
        }
        if (monthCount < 1) {
            return;
        }
        GregorianCalendar dateFrom = new GregorianCalendar();
        GregorianCalendar dateTo = new GregorianCalendar();
        dateFrom.setTime(agent.getExpires());
        ((Calendar)dateFrom).add(2, 1);
        dateFrom.set(5, 1);
        dateTo.setTime(dateFrom.getTime());
        ((Calendar)dateTo).add(2, monthCount - 1);
        dateTo.set(5, ((Calendar)dateTo).getActualMaximum(5));
        agent.setNextStatus(1);
        agent.setBlockBegin(dateFrom.getTime());
        agent.setBlockEnd(dateTo.getTime());
        this.agentManager.update(agent);
    }

    public void deleteAgent(AgentAVD agent) throws BGException {
        if (agent.getStatus() == 3) {
            return;
        }
        GregorianCalendar dt = new GregorianCalendar();
        agent.setExpires(TimeUtils.getEndMonth((Calendar)dt).getTime());
        agent.setNextStatus(2);
        this.agentManager.update(agent);
        this.serverAPI.prolongAgentOnAVD(agent, agent.getExpires());
    }

    public void activeAgent(AgentAVD agent) throws BGException {
        if (agent.getStatus() == 4) {
            GregorianCalendar dateFrom = new GregorianCalendar();
            dateFrom.setTime(new Date());
            dateFrom.set(5, ((Calendar)dateFrom).getActualMaximum(5));
            agent.setNextStatus(4);
            agent.setExpires(dateFrom.getTime());
            this.agentManager.update(agent);
        } else if (agent.getNextStatus() == 1 || agent.getNextStatus() == 2) {
            agent.setNextStatus(0);
            this.agentManager.update(agent);
        }
    }

    public void toChangeTariff(AgentAVD agent, int nextTariffId) throws BGException {
        if (agent.getStatus() == 3 || agent.getTariffId() == nextTariffId) {
            if (agent.getTariffId() == nextTariffId && agent.getNextStatus() == 3) {
                agent.setNextTariffId(-1);
                agent.setNextStatus(0);
                this.agentManager.update(agent);
            }
            return;
        }
        GregorianCalendar dateFrom = new GregorianCalendar();
        dateFrom.setTime(agent.getExpires());
        ((Calendar)dateFrom).add(2, 1);
        dateFrom.set(5, 1);
        agent.setNextTariffId(nextTariffId);
        agent.setNextStatus(3);
        this.agentManager.update(agent);
    }

    public void doChanges(AgentAVD agent) throws BGException {
        log.debug("doChanges fo agent id=>" + agent.getId());
        TariffAVD tariff = null;
        boolean mustChange = false;
        if (agent.getNextStatus() != 3) {
            tariff = (TariffAVD)this.tariffManager.get(agent.getTariffId());
            mustChange = true;
        } else {
            tariff = (TariffAVD)this.tariffManager.get(agent.getTariffId());
        }
        TariffAVD tariffNext = this.getNextTariff(tariff, new Date());
        if (!tariffNext.equals((Object)tariff)) {
            tariff = tariffNext;
            mustChange = true;
        }
        if (mustChange) {
            this.serverAPI.changeTariffOnAVD(agent, tariff.getGroupTitle());
        }
        agent.setTariffId(tariff.getId());
        agent.setNextStatus(0);
        agent.setLock(false);
        if (!agent.isGraceperiod()) {
            agent.setNewAgent(false);
        }
        agent.setGraceperiod(false);
        this.agentManager.update(agent);
    }

    private TariffAVD getNextTariff(TariffAVD tariff, Date date) throws BGException {
        if (!TimeUtils.dateInRange((Date)date, (Date)tariff.getDateFromWork(), (Date)tariff.getDateToWork())) {
            tariff = (TariffAVD)this.tariffManager.get(tariff.getNextTariff());
            return this.getNextTariff(tariff, date);
        }
        return tariff;
    }

    public int getActualAgentCount(int cid) throws BGException {
        return this.agentManager.getActualAgentCount(cid);
    }

    public void checkMaxAgentCount(int cid) throws BGException {
        if (this.maxAgentCount > 0 && this.agentManager.getActualAgentCount(cid) >= this.maxAgentCount) {
            throw new BGException(this.maxAgentCountMessage);
        }
    }
}

