/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.dialup.server.radius;

import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.processor.LC_LimitChecker;
import bitel.billing.server.processor.dialup.DNSUpdater;
import bitel.billing.server.processor.dialup.DialUpSessionRealtime;
import bitel.billing.server.radius.RadiusSetup;
import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.common.Event;
import ru.bitel.bgbilling.kernel.event.common.QueueEvent;
import ru.bitel.bgbilling.kernel.network.radius.AccountingSession;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttribute;
import ru.bitel.bgbilling.kernel.network.radius.RadiusAttributeSet;
import ru.bitel.bgbilling.kernel.network.radius.RadiusDictionary;
import ru.bitel.bgbilling.kernel.network.radius.RadiusPacket;
import ru.bitel.bgbilling.kernel.network.radius.RadiusUtils;
import ru.bitel.bgbilling.kernel.network.radius.nas.Nas;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasConnection;
import ru.bitel.bgbilling.kernel.network.radius.nas.NasList;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpLogin;
import ru.bitel.bgbilling.modules.dialup.server.bean.DialUpSessionUtils;
import ru.bitel.bgbilling.modules.dialup.server.event.DisconnectByBalanceOverEvent;
import ru.bitel.bgbilling.modules.dialup.server.event.radius.SessionStoppedEvent;
import ru.bitel.bgbilling.modules.dialup.server.radius.DialUpNas;
import ru.bitel.bgbilling.server.util.DefaultServerSetup;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class DialUpNasConnection
extends NasConnection<DialUpSessionRealtime> {
    private static final Logger logger = LogManager.getLogger();
    private ScheduledFuture<?> checkerScheduledFuture = null;
    private final Object mutex = new Object();
    private final RadiusSetup setup;

    public DialUpNasConnection(DialUpSessionRealtime session, DefaultServerSetup setup, NasList<? extends NasConnection<?>, ? extends Nas<? extends NasConnection<?>, ?, ?>> nasList, int nasId) {
        super((AccountingSession)session, setup, nasList, nasId);
        this.setup = (RadiusSetup)setup;
    }

    protected void addPersonalRadiusAttributes(RadiusAttributeSet response) {
        DialUpLogin login;
        Map<String, List<String[]>> avp;
        List<String[]> pairs;
        String realm = ((DialUpSessionRealtime)this.session).getRealm();
        if (realm == null) {
            realm = "default";
        }
        if ((pairs = (avp = (login = (DialUpLogin)((DialUpSessionRealtime)this.session).getLogin()).getAvpPairs()).get(realm)) != null) {
            for (String[] pair : pairs) {
                RadiusAttribute ra = RadiusDictionary.newRadiusAttribute((String)pair[0], (String)pair[1]);
                if (ra == null) continue;
                response.addAttribute(ra);
            }
        }
        if (login.getRpMode() != 1) {
            String realmAttributes = null;
            realmAttributes = this.getNas().getConf().get("realm." + realm, null);
            response.addAttributes(RadiusAttributeSet.newRadiusAttributeSet((String)realmAttributes));
        }
    }

    public void modify(Set<Integer> ids) throws IOException {
        DialUpNas nas = (DialUpNas)this.getNas();
        if (nas != null) {
            RadiusAttributeSet authorization = RadiusAttributeSet.newRadiusAttributeSet((Map)nas.getAttributeSetMap(), ids);
            this.modify(nas, authorization);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startConnection(DialUpNas nas, RadiusPacket request, Connection con, Connection conSlave) {
        Object object = this.mutex;
        synchronized (object) {
            this.startConnectionImpl(nas, request, con, conSlave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnection(DialUpNas nas, RadiusPacket request, Connection con, Connection conSlave) {
        Object object = this.mutex;
        synchronized (object) {
            this.stopConnectionImpl(nas, request, con, conSlave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(DialUpNas nas, RadiusPacket request, RadiusPacket response, Connection con, Connection conSlave) {
        Object object = this.mutex;
        synchronized (object) {
            this.updateConnectionImpl(nas, request, response, con, conSlave);
        }
    }

    private void startConnectionImpl(DialUpNas nas, RadiusPacket request, Connection con, Connection conSlave) {
        DialUpSessionRealtime session = (DialUpSessionRealtime)this.getSession();
        session.addLogInfo("DialUpNASConnection startConnection mode=" + nas.getWorkMode());
        if (session.getZoneMap() != null) {
            for (DialUpSessionRealtime.TariffZoneEntry zone : session.getZoneMap().values()) {
                session.addLogInfo("Zone on start " + zone.getZone().getZone());
            }
        }
        try {
            if (this.getStatus() == NasConnection.Status.waiting) {
                if (request != null) {
                    String sessionId = request.getStringAttribute(-1, 44, "UNDEF");
                    session.setAcctSessionId(sessionId);
                    session.setStartTime(new GregorianCalendar());
                    session.setStopTime(new GregorianCalendar());
                    session.setCalculatedStopTime(new GregorianCalendar());
                    int ip = request.getIntAttribute(-1, 8, Integer.valueOf(0));
                    if (ip != 0) {
                        session.setIpAddress(Utils.unsignedIntToLong((int)ip));
                    }
                    String fromNumber = request.getStringAttribute(-1, 31, null);
                    String toNumber = request.getStringAttribute(-1, 30, null);
                    if (Utils.isBlankString((String)session.getFromNumber()) && Utils.notBlankString((String)fromNumber)) {
                        session.setFromNumber(fromNumber);
                    }
                    if (Utils.isBlankString((String)session.getToNumber()) && Utils.notBlankString((String)toNumber)) {
                        session.setToNumber(toNumber);
                    }
                    session.checkAndCreateTables(con, (DefaultServerSetup)this.setup);
                    session.createSession(con);
                    if (!session.isFakeSession()) {
                        RadiusUtils.addToLog((DefaultServerSetup)this.setup, (int)this.setup.getModuleId(), (RadiusPacket)request, (Date)session.getStartTime().getTime(), (int)session.getRequestLogRecordId());
                        DNSUpdater.getUpdater().registerHost(session);
                    }
                }
                if (nas.getWorkMode() == 2) {
                    if (!session.isFakeSession()) {
                        final int updateTime = nas.getConf().getInt("update.time", 10);
                        int sleepTime = nas.getConf().getInt("run.sleep", 3);
                        final ExecutorService executorService = nas.checkerUpdater;
                        this.checkerScheduledFuture = DialUpNas.scheduledExecutorService.scheduleAtFixedRate(new Runnable(){
                            private final 1CheckerUpdater updater;
                            {
                                class 1CheckerUpdater
                                implements Runnable {
                                    final /* synthetic */ int val$updateTime;

                                    1CheckerUpdater() {
                                        this.val$updateTime = n;
                                    }

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void run() {
                                        Object object = DialUpNasConnection.this.mutex;
                                        synchronized (object) {
                                            DialUpNasConnection.this.run(this.val$updateTime);
                                        }
                                    }
                                }
                                this.updater = new 1CheckerUpdater(DialUpNasConnection.this, updateTime);
                            }

                            @Override
                            public void run() {
                                executorService.execute(this.updater);
                            }
                        }, 0L, sleepTime, TimeUnit.SECONDS);
                    }
                    this.setStatus(NasConnection.Status.suspended);
                } else {
                    this.setStatus(NasConnection.Status.working);
                }
            } else {
                logger.warn("Duplicate start!!!\n");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void sendDisconnectedByBalanceEvent(DialUpSessionRealtime session, Connection con) throws BGException {
        BalanceUtils bu = new BalanceUtils(con);
        Contract contract = session.getContract();
        float balance = bu.getBalance(new Date(), contract.getId()).floatValue();
        bu.close();
        if (balance < contract.getBalanceLimit().floatValue()) {
            session.addLogInfo("Adding DisconnectByBalanceOverEvent..");
            EventProcessor.getInstance().publish((Event)new DisconnectByBalanceOverEvent(this.setup.getModuleId(), contract.getId()));
        }
    }

    private void stopConnectionImpl(DialUpNas nas, RadiusPacket request, Connection con, Connection conSlave) {
        ((DialUpSessionRealtime)this.session).addLogInfo("DialUpNASConnection stoppingConnection");
        ((DialUpSessionRealtime)this.session).addLogInfo("DialUpNASConnection has stop Packet => " + (request != null));
        DialUpSessionRealtime session = (DialUpSessionRealtime)this.getSession();
        try (BalanceUtils bu = new BalanceUtils(con);){
            if (this.getStatus() == NasConnection.Status.waiting) {
                logger.error("Stop without start!");
            } else if (this.getStatus() == NasConnection.Status.working || this.getStatus() == NasConnection.Status.suspended) {
                this.setStatus(NasConnection.Status.stopped);
                if (request != null) {
                    int time = request.getIntAttribute(-1, 46, Integer.valueOf(0));
                    if (this.setup.getInt("ignore.acct.session.time", 0) == 1) {
                        GregorianCalendar now = new GregorianCalendar();
                        Calendar startTime = session.getStartTime();
                        time = (int)((now.getTimeInMillis() - startTime.getTimeInMillis()) / 1000L);
                    }
                    session.addLogInfo("DialUpNASConnection sessionTime => " + time);
                    GregorianCalendar realStop = (GregorianCalendar)session.getStartTime().clone();
                    realStop.add(13, time);
                    session.setStopTime(realStop);
                    if (!session.isFakeSession()) {
                        session.calculate(this.setup, (Closeable)((Object)this), con, LC_LimitChecker.getLimitChecker(), false);
                        RadiusUtils.addToLog((DefaultServerSetup)this.setup, (int)this.setup.getModuleId(), (RadiusPacket)request, (Date)session.getStartTime().getTime(), (int)session.getRequestLogRecordId());
                    }
                    session.closeSession(con, 1);
                    if (!session.isFakeSession()) {
                        this.sendDisconnectedByBalanceEvent(session, con);
                    }
                } else {
                    session.closeSession(con, 2);
                }
                if (!session.isFakeSession()) {
                    int cid = session.getContract().getId();
                    new DialUpSessionUtils(con, this.setup.getModuleId()).setContractAccountFromSessionAccount(session.getStartTime(), cid);
                    bu.setBalanceFromAccount(session.getContract(), session.getStartTime());
                    SessionStoppedEvent event = new SessionStoppedEvent(this.setup.getModuleId(), this, request);
                    EventProcessor.getInstance().request((QueueEvent)event);
                }
            }
            if (!session.isFakeSession()) {
                DNSUpdater.getUpdater().unregisterHost(session);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void checkContractChanges(Nas<?, ?, ?> nas) {
        Calendar currentStop = ((DialUpSessionRealtime)this.session).getCalculatedStopTime();
        if (currentStop != null && ((DialUpSessionRealtime)this.session).getLogin().getDate2() != null && TimeUtils.dateBefore((Date)((DialUpSessionRealtime)this.session).getLogin().getDate2(), (Date)currentStop.getTime())) {
            ((DialUpSessionRealtime)this.session).addLogInfo("Killing session by changed login period");
            this.kill(nas);
        }
    }

    private void updateConnectionImpl(DialUpNas nas, RadiusPacket request, RadiusPacket response, Connection con, Connection conSlave) {
        ((DialUpSessionRealtime)this.session).addLogInfo("DialUpNASConnection update connection..");
        if (this.getStatus() == NasConnection.Status.waiting) {
            this.startConnection(nas, request, con, conSlave);
            ((DialUpSessionRealtime)this.session).addLogInfo("Starting session by UPDATE packet!");
        } else {
            int ip;
            DialUpSessionRealtime session = (DialUpSessionRealtime)this.session;
            if (request != null && (ip = request.getIntAttribute(-1, 8, Integer.valueOf(0)).intValue()) != 0) {
                session.setIpAddress(Utils.unsignedIntToLong((int)ip));
            }
            if (nas.getWorkMode() == 1) {
                if (!session.isFakeSession()) {
                    String acctSessionId = request.getStringAttribute(-1, 44, null);
                    if (Utils.notBlankString((String)acctSessionId) && !acctSessionId.equals(session.getAcctSessionId())) {
                        session.addLogError("Update with incorrect Acct-Session-Id!");
                        return;
                    }
                    GregorianCalendar now = new GregorianCalendar();
                    session.setStopTime(now);
                    try {
                        if (!session.calculate(this.setup, (Closeable)((Object)this), con, LC_LimitChecker.getLimitChecker(), true)) {
                            this.kill(nas);
                            session.addLogInfo("DialUpNASConnection killing connection after UPDATE");
                        } else {
                            this.checkContractChanges(nas);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                this.setStatus(NasConnection.Status.working);
            }
            if (this.isKill() && nas.getVendorCode() == 12341) {
                response.setAttribute((RadiusAttribute)new RadiusAttribute.RadiusAttributeInteger(12341, 154, 1));
            }
        }
    }

    public void setStatus(NasConnection.Status status) {
        super.setStatus(status);
        if (status == NasConnection.Status.stopped && this.checkerScheduledFuture != null) {
            this.checkerScheduledFuture.cancel(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(int updateTime) {
        if (this.getStatus() == NasConnection.Status.working) {
            DialUpSessionRealtime session = (DialUpSessionRealtime)this.getSession();
            session.addLogDebug("DialUpNASConnection checker RUN");
            GregorianCalendar now = new GregorianCalendar();
            now.clear(14);
            if (now.before(session.getCalculatedStopTime())) {
                return;
            }
            Nas nas = null;
            boolean result = false;
            Connection con = this.setup.getDBConnectionFromPool();
            try {
                session.addLogDebug("DialUpNASConnection recalculate session");
                Calendar toTime = (Calendar)session.getCalculatedStopTime().clone();
                toTime.add(13, updateTime);
                session.setStopTime(toTime);
                result = session.calculate(this.setup, (Closeable)((Object)this), con, LC_LimitChecker.getLimitChecker(), true);
                session.addLogDebug("DialUpNASConnection recalculate result => " + result);
                if (result) {
                    nas = this.nasList.get(session.getNasId());
                    if (nas != null) {
                        this.checkContractChanges(nas);
                    } else {
                        logger.error("Nas with id=" + session.getNasId() + " not found!");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                ServerUtils.closeConnection((Connection)con);
            }
            if (!result) {
                if (nas == null) {
                    nas = this.nasList.get(session.getNasId());
                    if (nas != null) {
                        this.kill(nas);
                    } else {
                        logger.error("Nas with id=" + session.getNasId() + " not found!");
                    }
                }
                this.setStatus(NasConnection.Status.suspended);
            }
        } else if (this.getStatus() == NasConnection.Status.stopped && this.checkerScheduledFuture != null && !this.checkerScheduledFuture.isCancelled()) {
            this.checkerScheduledFuture.cancel(false);
        }
    }

    public static void main(String[] args) {
        ScheduledExecutorService service = Executors.newScheduledThreadPool(2);
        for (int i = 0; i < 10; ++i) {
            final int ii = i;
            final AtomicReference ref = new AtomicReference();
            ScheduledFuture<?> f = service.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        System.out.println(ii);
                        Thread.sleep(20000L);
                        System.out.println(((ScheduledFuture)ref.get()).cancel(false));
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }, i * 3, 10L, TimeUnit.SECONDS);
            ref.set(f);
        }
    }
}

