/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.cerbercrypt.server.bean;

import bitel.billing.server.contract.bean.ContractManager;
import bitel.billing.server.tariff.TariffModuleTree;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.server.tree.TariffTreeSet;
import ru.bitel.bgbilling.kernel.tariff.server.tree.old.TariffRequest;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.CardPacket;
import ru.bitel.bgbilling.modules.cerbercrypt.common.bean.Packet;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TimeUtils;

public class TariffRequestManager {
    private static final Logger log = LogManager.getLogger();
    private Connection con;
    private int mid;
    private HashMap<Calendar, TariffTreeSet> contractTreeSets = new HashMap(8);

    public TariffRequestManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
    }

    public Set<Integer> getMultiroomIgnorePacket(ParameterMap moduleSetup, int cid, Calendar date) {
        try (ContractManager contractManager = new ContractManager(this.con);){
            TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(cid, date.getTime(), "cerbercrypt", this.mid, true);
            TariffModuleTree tree = tts.getTree(date.getTime());
            if (tree != null) {
                TariffRequest req = new TariffRequest();
                req.setRequestParam("check_update_packet", (Object)Boolean.TRUE);
                req.setRequestParam("date", (Object)date);
                tree.processRequest(req);
                Set multiroomIgnorePackets = (Set)req.getResponseParam("multiroom_ignore_packets");
                if (multiroomIgnorePackets != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(multiroomIgnorePackets);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public Set<Integer> getAutoaddPackets(ParameterMap moduleSetup, int cid, Calendar date) {
        try (ContractManager contractManager = new ContractManager(this.con);){
            TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(cid, date.getTime(), "cerbercrypt", this.mid, true);
            TariffModuleTree tree = tts.getTree(date.getTime());
            if (tree != null) {
                TariffRequest tariffRequest = new TariffRequest();
                tariffRequest.setRequestParam("check_update_packet", (Object)Boolean.TRUE);
                tariffRequest.setRequestParam("date", (Object)date);
                tree.processRequest(tariffRequest);
                Set autoaddPackets = (Set)tariffRequest.getResponseParam("autoadd_packets");
                if (autoaddPackets != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(autoaddPackets);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public Set<Integer> getPacketGroup(ParameterMap moduleSetup, int cid, Calendar date) {
        try (ContractManager contractManager = new ContractManager(this.con);){
            TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(cid, date.getTime(), "cerbercrypt", this.mid, true);
            TariffModuleTree tree = tts.getTree(date.getTime());
            if (tree != null) {
                TariffRequest tariffRequest = new TariffRequest();
                tariffRequest.setRequestParam("check_update_packet", (Object)Boolean.TRUE);
                tariffRequest.setRequestParam("sid", (Object)moduleSetup.getInt("cerbercrypt.base_group.serviceId", -1));
                tariffRequest.setRequestParam("date", (Object)date);
                tree.processRequest(tariffRequest);
                Set packetGroup = (Set)tariffRequest.getResponseParam("packet_group");
                if (packetGroup != null) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(packetGroup);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public Set<Integer> getPacketsAutosync(ParameterMap moduleSetup, int cid, Date date, AutosyncOnMode source) {
        try (ContractManager contractManager = new ContractManager(this.con);){
            TariffTreeSet tts = contractManager.getRealtimeTariffTreeSet(cid, date, "cerbercrypt", this.mid, true);
            TariffModuleTree tree = tts.getTree(date);
            if (tree != null) {
                TariffRequest req = new TariffRequest();
                req.setRequestParam("get_packets_autosync", (Object)Boolean.TRUE);
                req.setRequestParam("date", (Object)date);
                tree.processRequest(req);
                Set packets_autosync = (Set)req.getResponseParam("packets_autosync");
                Boolean on_card_add = (Boolean)req.getResponseParam("packets_autosync_on_card_add");
                Boolean on_tariff_change = (Boolean)req.getResponseParam("packets_autosync_on_tariff_change");
                if (packets_autosync != null && (source == null || source == AutosyncOnMode.ONCARDADD && on_card_add == Boolean.TRUE || source == AutosyncOnMode.ONTARIFFCHANGE && on_tariff_change == Boolean.TRUE)) {
                    HashSet<Integer> hashSet = new HashSet<Integer>(packets_autosync);
                    return hashSet;
                }
            }
        }
        return null;
    }

    public float getSubscriptionCost(int contractId, Date date, Map<Integer, Packet> packetMap, List<CardPacket> cardPacketList, boolean check) {
        TariffModuleTree tree;
        float result = 0.0f;
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        int daysInMonth = ((Calendar)calendar).getActualMaximum(5);
        TariffTreeSet treeSet = this.contractTreeSets.get(calendar);
        if (treeSet == null) {
            treeSet = new ContractManager(this.con).getTariffTreeSetForDay(contractId, (Calendar)calendar, "cerbercrypt", this.mid, true);
            this.contractTreeSets.put(calendar, treeSet);
        }
        if ((tree = treeSet.getTree(calendar.getTime())) != null) {
            Packet packet;
            ArrayList<Packet> packets = new ArrayList<Packet>(cardPacketList.size());
            for (CardPacket cardPacket : cardPacketList) {
                packet = new Packet();
                packet.setId(cardPacket.getPacketId());
                packets.add(packet);
            }
            for (CardPacket cardPacket : cardPacketList) {
                packet = packetMap.get(cardPacket.getPacketId());
                if (packet != null) {
                    TariffRequest req = new TariffRequest();
                    req.setRequestParam("packet", (Object)packet.getId());
                    req.setRequestParam("sid", (Object)packet.getServiceId());
                    req.setRequestParam("packet_count", (Object)cardPacketList.size());
                    req.setRequestParam("packet_list", packets);
                    req.setRequestParam("time", (Object)TimeUtils.convertDateToCalendar((Date)date));
                    tree.processRequest(req);
                    Float cost = (Float)req.getResponseParam("cost");
                    Integer type = (Integer)req.getResponseParam("type");
                    Float discount = (Float)req.getResponseParam("discount");
                    Set ignoreDiscountPackets = (Set)req.getResponseParam("packets_ignore_discount");
                    if (!req.wasAccepted() || cost == null || type == null || type <= 0) {
                        log.error("Wrong tariff response: " + req.toString());
                        if (!check) continue;
                        return Float.NaN;
                    }
                    float dayCost = 0.0f;
                    dayCost = type == 1 ? cost.floatValue() : cost.floatValue() / (float)daysInMonth;
                    if (!(packet.isVirtualCinema() || discount == null || !(discount.floatValue() > 0.0f) || ignoreDiscountPackets != null && ignoreDiscountPackets.contains(packet.getId()))) {
                        dayCost *= 1.0f - discount.floatValue() / 100.0f;
                    }
                    result += dayCost;
                    continue;
                }
                if (!check) continue;
                return Float.NaN;
            }
        } else if (check) {
            return Float.NaN;
        }
        return result;
    }

    public static enum AutosyncOnMode {
        ONCARDADD,
        ONTARIFFCHANGE;

    }
}

