/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.apps.cashcheck.frk.server;

import bitel.billing.common.VersionInfo;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.FrkException;
import ru.bitel.bgbilling.apps.cashcheck.frk.server.IDeviceDriver;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.BGCfg;
import ru.bitel.bgbilling.apps.cashcheck.frk.utils.FrkUtils;
import ru.bitel.common.io.InputStreamUnicodeReader;

public class CmdTcpServer
extends Thread {
    private Socket socket;
    private int num;
    private static IDeviceDriver device;
    private BufferedReader in;
    private BufferedWriter out;
    private static final String KILLSERVER_COMMAND = "!KILLSERVER%)";
    private static final String STATUSSERVER_COMMAND = "!STATUSSERVER%)";
    private static ServerSocket server;
    private static Logger log;
    private static long _startTime;

    public CmdTcpServer(Socket socket, int num) throws IOException {
        this.socket = socket;
        this.num = num;
        this.in = new BufferedReader(new InputStreamReader(socket.getInputStream(), "utf-8"));
        this.out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream(), "utf-8"));
        this.setDaemon(false);
        this.setPriority(5);
        this.setName("thread#" + num);
        this.start();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BGCfg getConfig() {
        String configName = System.getProperty("setupfrk", "/conf/setupfrk.config");
        URL url = CmdTcpServer.class.getResource(configName);
        if (url == null) {
            log.error("error foung config file " + configName);
            System.exit(1);
            return null;
        }
        try (FileInputStream fileInputStream = new FileInputStream(new File(url.toURI()));){
            BGCfg bGCfg;
            try (InputStreamUnicodeReader reader = new InputStreamUnicodeReader((InputStream)fileInputStream, "UTF-8");){
                bGCfg = new BGCfg((Reader)reader);
            }
            return bGCfg;
        }
        catch (Exception e) {
            log.error("error parse config file", (Throwable)e);
            System.exit(1);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void doStart() {
        try {
            try {
                BGCfg cfg = CmdTcpServer.getConfig();
                String serverPort = cfg.getString("port");
                String driver = cfg.getString("driver");
                device = (IDeviceDriver)Class.forName(driver).getConstructor(new Class[0]).newInstance(new Object[0]);
                log.info("server: driver: " + driver);
                HashMap<String, String> config = new HashMap<String, String>();
                Map<String, Object> driverMap = cfg.getMap(driver);
                if (driverMap != null) {
                    for (Map.Entry<String, Object> rec : driverMap.entrySet()) {
                        if (rec.getValue() instanceof String) {
                            config.put(rec.getKey(), (String)rec.getValue());
                            continue;
                        }
                        log.warn("config driver parameter '" + rec.getValue() + "' is not stringable, ignored");
                    }
                }
                device.init(config);
                log.info("server: driver status: " + device.getStatus());
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        device.shutdown();
                        log.info("server: server runtime shutdowned");
                    }
                });
                server = new ServerSocket(Integer.parseInt(serverPort));
                log.info("server: started: " + server);
                int connectnum = 0;
                while (true) {
                    Socket socket = server.accept();
                    log.debug("server: connection accepted #" + ++connectnum + ": " + socket);
                    new CmdTcpServer(socket, connectnum);
                }
            }
            catch (BindException e) {
                log.error("server: socket exception", (Throwable)e);
                return;
            }
            catch (SocketException e) {
                log.info("server: socket exception. closed?");
                try {
                    if (server != null) {
                        log.info("server: socket close...");
                        server.close();
                    }
                }
                catch (IOException e2) {
                    log.error((Object)e2);
                }
                return;
            }
            catch (Exception e) {
                log.error("server: server error", (Throwable)e);
                System.exit(1);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (server != null) {
                        log.info("server: socket close...");
                        server.close();
                    }
                }
                catch (IOException e3) {
                    log.error((Object)e3);
                }
                return;
            }
        }
        finally {
            try {
                if (server != null) {
                    log.info("server: socket close...");
                    server.close();
                }
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private static void doStop() {
        log.info("server: stoping server, sending killserver command...");
        try {
            BGCfg cfg = CmdTcpServer.getConfig();
            String serverPort = cfg.getString("port");
            InetAddress addr = InetAddress.getByName("127.0.0.1");
            Socket socket = new Socket(addr, Integer.parseInt(serverPort));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            out.write(KILLSERVER_COMMAND);
            out.newLine();
            out.flush();
            socket.close();
        }
        catch (Exception e) {
            log.error("server: error stoping server", (Throwable)e);
            System.exit(1);
            return;
        }
    }

    private static void doStatus() {
        try {
            BGCfg cfg = CmdTcpServer.getConfig();
            String serverPort = cfg.getString("port");
            InetAddress addr = InetAddress.getByName("127.0.0.1");
            Socket socket = new Socket(addr, Integer.parseInt(serverPort));
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.write(STATUSSERVER_COMMAND);
            out.newLine();
            out.flush();
            String reply = in.readLine();
            if (reply != null) {
                System.out.println(reply.replaceAll("; ", "\n"));
            }
            socket.close();
        }
        catch (Exception e) {
            log.error("server: error get status server", (Throwable)e);
            System.exit(1);
            return;
        }
    }

    private static void doHelp() {
        CmdTcpServer.showHelp();
        System.exit(1);
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append(CmdTcpServer.getVersion());
        sb.append("\nUsage: <cashserver>[.bat|.sh] [start|stop|status]");
        sb.append("\nParameters:");
        sb.append("\n\tstart - starting");
        sb.append("\n\tstop - stopping");
        sb.append("\n\tstatus - show status");
        sb.append("\nExample:\n\t./cashserver.sh start");
        System.out.println(sb.toString());
    }

    private String readLine() throws IOException {
        String line = this.in.readLine();
        log.trace("thread#" + this.num + ": <- " + (line != null ? line : "<EOF>"));
        return line;
    }

    private void writeLine(String line) throws IOException {
        this.out.write(line);
        this.out.newLine();
        log.trace("thread#" + this.num + ": -> " + line);
    }

    private void flush() throws IOException {
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            String echo;
            while ((echo = this.readLine()) != null) {
                Method deviceMethod;
                String param;
                if (KILLSERVER_COMMAND.equals(echo)) {
                    log.info("thread#" + this.num + ": killserver command...");
                    server.close();
                    break;
                }
                if (STATUSSERVER_COMMAND.equals(echo)) {
                    log.debug("thread#" + this.num + ": statusserver command...");
                    this.writeLine(this.getStatus());
                    this.flush();
                    break;
                }
                if (!"COMMAND".equals(echo)) {
                    log.error("thread#" + this.num + ": ERROR PROTOCOL: unknown command header: " + echo);
                    break;
                }
                String code = this.readLine();
                String command = this.readLine();
                log.debug("thread#" + this.num + ": \"" + command + "\" command...");
                ArrayList<String> parameters = new ArrayList<String>();
                while (!(param = this.readLine()).equals("ENDCOMMAND")) {
                    parameters.add(param);
                }
                this.writeLine("ECHO");
                this.writeLine(code);
                this.flush();
                Class[] parametersClass = new Class[parameters.size()];
                String[] parametersObject = new String[parameters.size()];
                for (int i = 0; i < parameters.size(); ++i) {
                    parametersClass[i] = ((String)parameters.get(i)).getClass();
                    parametersObject[i] = (String)parameters.get(i);
                }
                Class<?> deviceClass = device.getClass();
                Object[] parametersObjectArray = null;
                try {
                    deviceMethod = deviceClass.getMethod(command, parametersClass);
                }
                catch (NoSuchMethodException e1) {
                    try {
                        deviceMethod = deviceClass.getMethod(command, parametersObject.getClass());
                        parametersObjectArray = new Object[]{parametersObject};
                    }
                    catch (NoSuchMethodException e2) {
                        this.writeLine("ERROR");
                        this.writeLine("not found method/command \"" + command + "\"");
                        this.writeLine("ENDECHO");
                        this.flush();
                        throw new NoSuchMethodException("not found method/command \"" + command + "\"");
                    }
                }
                String messageLines = null;
                try {
                    Object ret = parametersObjectArray != null ? deviceMethod.invoke((Object)device, parametersObjectArray) : deviceMethod.invoke((Object)device, (Object[])parametersObject);
                    this.writeLine("OK");
                    Type returnType = deviceMethod.getGenericReturnType();
                    if (!returnType.equals(Void.TYPE)) {
                        messageLines = ret == null ? "NULL" : ret.toString();
                    }
                }
                catch (InvocationTargetException e) {
                    Throwable targetException = e.getTargetException();
                    this.writeLine("ERROR");
                    if (targetException instanceof FrkException) {
                        messageLines = FrkUtils.getExceptionMessage(targetException, new Class[]{FrkException.class});
                        log.debug("thread#" + this.num + ": command \"" + command + "\" frk error", targetException);
                    } else {
                        messageLines = FrkUtils.getExceptionMessage(targetException, null);
                        log.error("thread#" + this.num + ": command \"" + command + "\" unexpected error", targetException);
                    }
                    log.warn("thread#" + this.num + ": command \"" + command + "\" send error driver: " + messageLines);
                }
                if (messageLines != null) {
                    this.writeLine(messageLines);
                }
                this.writeLine("ENDECHO");
                this.flush();
                log.debug("thread#" + this.num + ": command \"" + command + "\" processing sucessfull");
            }
            log.debug("thread#" + this.num + ": end all commands");
        }
        catch (Exception e) {
            log.error("thread#" + this.num + ": error processing commands", (Throwable)e);
        }
        finally {
            try {
                log.debug("thread#" + this.num + ": close socket");
                this.socket.close();
            }
            catch (IOException e) {
                log.error("thread#" + this.num + ": error close socket", (Throwable)e);
            }
        }
    }

    private String getStatus() {
        String status = CmdTcpServer.getVersion() + "; on: " + server.getLocalSocketAddress() + "; device driver: " + device + "; device status: " + device.getStatus() + "; thread counter: " + this.num + "; " + FrkUtils.getUpTime(_startTime) + "; " + FrkUtils.getMemoryStatus();
        return status.replace('\r', ' ').replace('\n', ' ');
    }

    public static void exit() {
        log.info("server: invoke exit() method...");
        CmdTcpServer.main(new String[]{"stop"});
    }

    public static String getVersion() {
        VersionInfo vi = VersionInfo.getVersionInfo((String)"ru.bitel.bgbilling.plugins.cashcheck");
        return "CmdTcpServer v " + vi.getVersionString();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            log.info("server: run \"" + CmdTcpServer.getVersion() + "\" with command \"" + args[0] + "\"");
            log.info("server: logging level " + log.getLevel());
            switch (args[0].trim()) {
                case "start": {
                    CmdTcpServer.doStart();
                    break;
                }
                case "stop": {
                    CmdTcpServer.doStop();
                    break;
                }
                case "status": {
                    CmdTcpServer.doStatus();
                    break;
                }
                default: {
                    CmdTcpServer.doHelp();
                    break;
                }
            }
        } else {
            CmdTcpServer.doHelp();
        }
    }

    static {
        System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
        System.setProperty("cashserver.start.timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
        System.setProperty("log4j.configurationFile", System.getProperty("log4j.configurationFile", "conf/log4j2.xml"));
        log = LogManager.getLogger();
        _startTime = System.currentTimeMillis();
    }
}

