/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.botmanager.server.bots;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.modules.botmanager.common.bean.Bot;
import ru.bitel.bgbilling.modules.botmanager.common.bean.BotDialog;
import ru.bitel.bgbilling.modules.botmanager.common.service.BotManagerService;
import ru.bitel.bgbilling.modules.botmanager.server.bean.UserBotData;
import ru.bitel.bgbilling.modules.botmanager.server.dao.BotSessionsDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;

public abstract class RuntimeBot {
    protected int moduleId;
    protected int botId;
    protected String title;
    protected String token;
    protected int botState;
    private boolean statisticEnable;
    protected ServerContext serverContext;
    protected Map<Long, Integer> botSessions = new HashMap<Long, Integer>();
    protected final Map<Long, Integer> dialogOfChat = new HashMap<Long, Integer>();
    private UserBotData userBotData;
    protected ParameterMap botConfig;
    protected BotDialog firstDialog = null;

    public RuntimeBot(Bot bot) {
        this.botId = bot.getId();
        this.title = bot.getTitle();
        this.token = bot.getToken();
        this.botState = bot.getState();
    }

    public void initBot(ServerContext serverContext, int moduleId) throws BGException {
        this.moduleId = moduleId;
        this.serverContext = serverContext;
        this.botConfig = this.getBotConfig();
        this.firstDialog = this.getFirstDialog();
        this.initBot();
    }

    public abstract void initBot();

    public abstract void startBot();

    public abstract void stopBot();

    public void setBotData(UserBotData userBotData) {
        this.userBotData = userBotData;
    }

    public Map<Long, Integer> getDialogOfChat() {
        return this.dialogOfChat;
    }

    public BotDialog getDialogByChatId(long chatId) throws BGException {
        BotDialog result = null;
        Integer dialogId = this.getDialogOfChat().get(chatId);
        if (dialogId != null) {
            result = this.getBotManagerService().getDialogById(dialogId.intValue());
        }
        return result;
    }

    public Map<Long, Integer> getBotSessions() {
        return this.botSessions;
    }

    public void setModuleId(int moduleId) {
        this.moduleId = moduleId;
    }

    public void setBotId(int botId) {
        this.botId = botId;
    }

    public int getBotId() {
        return this.botId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getToken() {
        return this.token;
    }

    public void setBotState(int botState) {
        this.botState = botState;
    }

    public int getBotState() {
        return this.botState;
    }

    public ServerContext getServerContext() {
        return this.serverContext;
    }

    public ParameterMap getBotConfig() {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        this.botConfig = moduleSetup.sub("bot." + this.botId + ".");
        this.setStatisticEnable(this.botConfig.get("statistic.enable", "").equals("true"));
        return this.botConfig;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public UserBotData getUserBotData() {
        return this.userBotData;
    }

    public void clearTemporaryChatData(JSONObject chatData) {
        if (chatData.has("nextDialogId")) {
            chatData.remove("nextDialogId");
        }
        if (chatData.has("responseErrorMessage")) {
            chatData.remove("responseErrorMessage");
        }
        if (chatData.has("macros")) {
            chatData.remove("macros");
        }
    }

    public synchronized void updateChatDataToBotSessions(long chatId, JSONObject chatData) throws BGException {
        int removeCid;
        BotSessionsDao sessionsDao = new BotSessionsDao(this.serverContext.getConnection(), this.moduleId);
        int cid = chatData.optInt("contractId", -1);
        if (cid > 0) {
            sessionsDao.updateSession(this.botId, cid, chatId);
        }
        if ((removeCid = chatData.optInt("idContractRemove", -1)) > 0) {
            sessionsDao.removeSession(this.botId, chatId);
        }
        if (cid > 0 || removeCid > 0) {
            this.botSessions = sessionsDao.getSessions(this.botId);
        }
    }

    public BotManagerService getBotManagerService() throws BGException {
        return (BotManagerService)this.getServerContext().getService(BotManagerService.class, this.moduleId);
    }

    public BotDialog getFirstDialog() throws BGException {
        int firstDialogId = this.botConfig.getInt("start.dialog.id", -1);
        if (firstDialogId > 0) {
            this.firstDialog = this.getBotManagerService().getDialogById(firstDialogId);
        }
        return this.firstDialog;
    }

    public void setFirstDialog(BotDialog firstDialog) {
        this.firstDialog = firstDialog;
    }

    public boolean isStatisticEnable() {
        return this.statisticEnable;
    }

    public void setStatisticEnable(boolean statisticEnable) {
        this.statisticEnable = statisticEnable;
    }
}

