/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.bonus.client.contract;

import bitel.billing.module.common.BGControlPanelPluginControls;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JCheckBox;
import ru.bitel.bgbilling.client.common.BGPanel;
import ru.bitel.bgbilling.client.util.ClientUtils;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.service.ChargeService;
import ru.bitel.bgbilling.kernel.tariff.option.client.ContractTariffOptionEditor;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.plugins.bonus.common.bean.BonusCharge;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.Utils;

public class ContractTariffOptionPaymentBonus
extends BGPanel
implements BGControlPanelPluginControls.IPluginControls {
    JCheckBox payWhithBonusCheckBox = new JCheckBox("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u0430\u043c\u0438");
    ContractTariffOptionEditor tariffOptionEditor = null;
    TariffOptionActivateMode mode;
    private BonusService service = (BonusService)this.getContext().getPort(BonusService.class);

    public ContractTariffOptionPaymentBonus() {
        this.setLayout(new GridBagLayout());
        this.add(this.payWhithBonusCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(Box.createHorizontalGlue(), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.payWhithBonusCheckBox.setEnabled(false);
    }

    public boolean beforeAdd(Component owner, Object ... data) {
        if (data[0] instanceof ContractTariffOptionEditor) {
            ContractTariffOptionEditor contractTariffOptionEditor = (ContractTariffOptionEditor)data[0];
            int contractId = contractTariffOptionEditor.getContractId();
            try {
                if (contractId > 0 && this.service.pluginInclude(contractId)) {
                    this.tariffOptionEditor = contractTariffOptionEditor;
                    this.setContractId(contractId);
                    return true;
                }
            }
            catch (Exception e) {
                this.getContext().processException((Throwable)e);
            }
        }
        return false;
    }

    public void doSetData(Component owner, Object ... data) {
        if (this.tariffOptionEditor != null) {
            this.setVisible(true);
            this.update();
            return;
        }
        this.setVisible(false);
    }

    public boolean beforeAction(Component owner, Object ... data) {
        try {
            if (!(this.payWhithBonusCheckBox.isSelected() && this.payWhithBonusCheckBox.isEnabled() && this.isVisible() && this.service.pluginInclude(this.getContractId()))) {
                return true;
            }
            BigDecimal maxBonusRealSumMayBePay = this.service.bonusSummaMax(this.getContractId(), this.mode.getChargeTypeId(), this.mode.getChargeSumma(), false);
            int chargeContrId = 0;
            chargeContrId = ((TariffOptionService)this.getContext().getPort(TariffOptionService.class)).contractTariffOptionActivateWhithSum(this.getContractId(), this.mode.getOptionId(), this.mode.getId(), this.mode.getChargeSumma().subtract(maxBonusRealSumMayBePay), false);
            if (chargeContrId > 0 && this.service.chargeUpdate(this.getContractId(), new BonusCharge(0, new Date(), this.service.bonusSummaMax(this.getContractId(), this.mode.getChargeTypeId(), this.mode.getChargeSumma(), true), chargeContrId))) {
                this.tariffOptionEditor.setStandarteActivation(false);
                return true;
            }
            if (chargeContrId != 0) {
                ((ChargeService)this.getContext().getPort(ChargeService.class)).chargeDelete(this.getContractId(), chargeContrId);
            }
            ClientUtils.showErrorMessageDialog((String)"\u0411\u043e\u043d\u0443\u0441\u044b \u043d\u0435 \u0431\u044b\u043b\u0438 \u0441\u043f\u0438\u0441\u0430\u043d\u044b!");
        }
        catch (BGException e) {
            this.getContext().processException((Throwable)e);
        }
        return false;
    }

    public void doAction(Component owner, Object ... data) {
    }

    private void update() {
        try {
            this.payWhithBonusCheckBox.setEnabled(false);
            this.mode = (TariffOptionActivateMode)this.tariffOptionEditor.getTariffOptionModeComboBox().getSelectedItem();
            if (this.mode == null) {
                this.payWhithBonusCheckBox.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u0430\u043c\u0438( \u0432\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0440\u0435\u0436\u0438\u043c! )");
            } else if (this.mode.getChargeSumma().compareTo(BigDecimal.ZERO) != 1) {
                this.payWhithBonusCheckBox.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u0430\u043c\u0438( \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u044b\u0439 \u0440\u0435\u0436\u0438\u043c! )");
            } else {
                BigDecimal maxBonusRealSumMayBePay = this.service.bonusSummaMax(this.getContractId(), this.mode.getChargeTypeId(), this.mode.getChargeSumma(), false);
                if (maxBonusRealSumMayBePay.compareTo(BigDecimal.ZERO) == 1) {
                    this.payWhithBonusCheckBox.setEnabled(true);
                    this.payWhithBonusCheckBox.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u0430\u043c\u0438( " + Utils.formatCost((BigDecimal)maxBonusRealSumMayBePay) + " \u0440\u0443\u0431. \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438 \u0438\u0437 " + this.mode.getChargeSumma().stripTrailingZeros().setScale(0) + " \u0440. )");
                } else {
                    this.payWhithBonusCheckBox.setText("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0411\u043e\u043d\u0443\u0441\u0430\u043c\u0438( \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e \u0431\u043e\u043d\u0443\u0441\u043e\u0432! )");
                }
            }
        }
        catch (Exception e) {
            this.getContext().processException((Throwable)e);
        }
    }
}

