<?xml version="1.0" encoding="UTF-8"?>
<!DOCTYPE xsl:stylesheet  [
	<!ENTITY nbsp   "&#160;">
	<!ENTITY copy   "&#169;">
	<!ENTITY reg    "&#174;">
	<!ENTITY trade  "&#8482;">
	<!ENTITY mdash  "&#8212;">
	<!ENTITY ldquo  "&#8220;">
	<!ENTITY rdquo  "&#8221;"> 
	<!ENTITY pound  "&#163;">
	<!ENTITY yen    "&#165;">
	<!ENTITY euro   "&#8364;">
]>

<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fo="http://www.w3.org/1999/XSL/Format"
	xmlns:svg="http://www.w3.org/2000/svg" 
	xmlns:xalan="http://xml.apache.org/xalan"
	xmlns:st="bitel.billing.common.SummaToString"
	xmlns:counter="bitel.billing.server.util.exslt.Counter">
	
	<xalan:component prefix="st" functions="summaToString">
		<xalan:script lang="javaclass" src="xalan://bitel.billing.common.SummaToString"/>
  	</xalan:component>
	<xalan:component prefix="counter" functions="add set get">
		<xalan:script lang="javaclass" src="xalan://bitel.billing.server.util.exslt.Counter"/>
  	</xalan:component>

	<xsl:output encoding="UTF-8" method='xml' indent='yes' />

	<!-- Список атрибутов:
		
	<bill
		contract			Договор
		bill_number			Номер счета
		date				Дата выписки
		payer				Плательщик
		
		
		total_sum			Итого: Сумма
		total_NDS			Итого: НДС
		total_sum_withNDS	Итого: Всего с НДС
		total_to_pay			Итого к оплате
		
		purpose				Назаначение
	>
			<pay
			//\//\//\//\//\//\//\//\//\//
				pos		Товар
				unit		Ед.
				amount		Кол-во
				price		Цена
				sum			Сумма
				NDS			НДС
				sumWithNDS	Всего с НДС
			//\//\//\//\//\//\//\//\//\//
			/>
			
	</bill>
	-->

	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->	
	<xsl:variable name="postal_address" select="'450001, Российская Федерация, Республика Башкортостан, г.XXX, проспект Октября, д.X, адм. здание'" />
	<xsl:variable name="INN" select="'ИНН 0000000000'" />
	<xsl:variable name="KPP" select="'КПП 000000000'" />
	<xsl:variable name="title" select="'ОАО &quot;XXXXXXX&quot;'" />
	<xsl:variable name="OKVED" select="'ОКВЭД 82000'" />
	<xsl:variable name="OKPO" select="'ОКПО 45219144'" />
	<!-- РЕКВИЗИТЫ ПРЕДПРИЯТИЯ -->

	<xsl:variable name="currency" select="'рубль'" />

	<xsl:attribute-set name="text">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_ban">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">6pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="text_bold">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text_left">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>

		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text_right">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>

		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.2cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_title">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">14pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.3cm</xsl:attribute>
		<xsl:attribute name="space-after">0.2cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="text_italic">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">8pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	
	<xsl:attribute-set name="table_text6_left">
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>

		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
	
	<xsl:attribute-set name="table_text6_right">
		<xsl:attribute name="text-align">right</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>

		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="table_text6_center">
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">7pt</xsl:attribute>
		<xsl:attribute name="start-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="end-indent">0.1cm</xsl:attribute>
		<xsl:attribute name="space-before">0.1cm</xsl:attribute>
	</xsl:attribute-set>
		
	<xsl:attribute-set name="cell_border">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_border_top">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-top-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:attribute-set name="cell_border_bottom">
		<xsl:attribute name="border-width">0.7pt</xsl:attribute>
		<xsl:attribute name="border-bottom-style">solid</xsl:attribute>
		<xsl:attribute name="border-left-style">solid</xsl:attribute>
		<xsl:attribute name="border-right-style">solid</xsl:attribute>
	</xsl:attribute-set>

	<xsl:template match="data">
		<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
			<xsl:apply-templates select="bill" />
		</fo:root>
	</xsl:template>
	
	<xsl:template match="bill">
		<xsl:variable name="nds_rate" select="number(params/@nds)"/>		
		<xsl:value-of select="counter:set('total_nds', '0.0')"/>

		<fo:layout-master-set>
			<fo:simple-page-master master-name="first"
				margin-right="1cm" margin-left="2cm"
				margin-bottom="2cm" margin-top="0.5cm"
				page-width="21cm" page-height="29.7cm">
				<fo:region-body margin-top="1cm" margin-bottom="1.5cm" />
				<fo:region-before extent="1cm" />
				<fo:region-after extent="1.5cm" />
			</fo:simple-page-master>
		</fo:layout-master-set>

		<xsl:call-template name="calcNDS">
			<xsl:with-param name="nds_rate" select="$nds_rate"/>
		</xsl:call-template>
	
		<fo:page-sequence master-reference="first">	
			<fo:flow flow-name="xsl-region-body">
			
				<!-- заголовок -->
				<fo:block xsl:use-attribute-sets="text">
			 		<xsl:value-of select="$postal_address"/> 
				</fo:block>
				<fo:block xsl:use-attribute-sets="text" space-after="0.3cm">
					<xsl:value-of select="$INN"/>, код по <xsl:value-of select="$OKVED"/>, код по <xsl:value-of select="$OKPO"/>, <xsl:value-of select="$KPP"/>
				</fo:block>
				<!-- заголовок -->
		
		
				<!-- начало таблицы номеров счета, БИК etc. -->
				<fo:table table-layout="fixed">
					<fo:table-column
						column-width="7.8cm"
						 />
					<fo:table-column
						column-width="2.2cm"
						 />
					<fo:table-column
						column-width="7cm"
						 />
		
		
					<fo:table-body>
						<!-- первая строка -->
						<fo:table-row>
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_top">
								<fo:block
									xsl:use-attribute-sets="table_text_left">
									Получатель
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell xsl:use-attribute-sets="cell_border_top" display-align="center">
								<fo:block/>
							</fo:table-cell>
		
							<fo:table-cell xsl:use-attribute-sets="cell_border_top">
								<fo:block/>
							</fo:table-cell>
						</fo:table-row>
		
						<fo:table-row>
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_bottom">
								<fo:block
									xsl:use-attribute-sets="table_text_left">
									<xsl:value-of select="$INN" />&nbsp;
									<xsl:value-of select="$KPP" />&nbsp;
									<xsl:value-of select="$title" />
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_bottom"
								display-align="center">
								<fo:block
									xsl:use-attribute-sets="table_text_center">
									Сч. №
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_bottom">
								<fo:block
									xsl:use-attribute-sets="table_text_left">
									<xsl:value-of select="@account"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
	
	
					<!-- вторая строка -->
						<fo:table-row>
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_top">
								<fo:block
									xsl:use-attribute-sets="table_text_left">
									Банк получателя
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell
								xsl:use-attribute-sets="cell_border" display-align="center">
								<fo:block
									xsl:use-attribute-sets="table_text_center">
									БИК
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell xsl:use-attribute-sets="cell_border_top">
								<fo:block xsl:use-attribute-sets="table_text_left"><xsl:value-of select="@bik"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
		
						<fo:table-row>
							<fo:table-cell xsl:use-attribute-sets="cell_border_bottom">
								<fo:block xsl:use-attribute-sets="table_text_left"><xsl:value-of select="@bank_title"/></fo:block>
							</fo:table-cell>
		
							<fo:table-cell xsl:use-attribute-sets="cell_border" display-align="center">
								<fo:block xsl:use-attribute-sets="table_text_center">Сч. №</fo:block>
							</fo:table-cell>
		
							<fo:table-cell xsl:use-attribute-sets="cell_border_bottom">
								<fo:block xsl:use-attribute-sets="table_text_left"><xsl:value-of select="@corr_account"/></fo:block>
							</fo:table-cell>
						</fo:table-row>
		
		
						<!-- третья строка -->
						<fo:table-row>
							<fo:table-cell
								xsl:use-attribute-sets="cell_border_bottom">
								<fo:block
									xsl:use-attribute-sets="table_text_left">
									Назначение платежа
								</fo:block>
							</fo:table-cell>
		
							<fo:table-cell
								xsl:use-attribute-sets="cell_border"
								number-columns-spanned="2">
								<fo:block
									xsl:use-attribute-sets="table_text_left">Оплата по дог. <xsl:value-of select="@contract"/> и счету <xsl:value-of select="@bill_number" />  от <xsl:value-of select="@date" />. НДС в том числе <xsl:value-of select="format-number(counter:get( 'total_nds' ), '0.00')" /> руб.
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
				</fo:table>
				<!-- конец таблицы номеров счета, БИК etc. -->
		
		
				<fo:block xsl:use-attribute-sets="text" space-before="0.2cm">
					счет действителен в течении 30 дней
				</fo:block>
		
				<fo:block xsl:use-attribute-sets="text_title">
					Счет № <xsl:value-of select="@bill_number" /> от <xsl:value-of select="@date" />
				</fo:block>
		
				<fo:block xsl:use-attribute-sets="text_bold">
					Плательщик: <xsl:value-of select="/data/bill/attributes/@org_name" />
				</fo:block>
				
				<fo:block xsl:use-attribute-sets="text">
					Телефон:  <xsl:value-of select="/data/bill/contract_data/contract_params/parameter[@pid='6']/@value"/>
				</fo:block>
				
				<fo:table table-layout="fixed">				
					<fo:table-column column-width="7cm"/>
					<fo:table-column column-width="10.1cm"/>
					
					<fo:table-body>
						<fo:table-row>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text">
									Договор: <xsl:value-of select="@contract"/>
								</fo:block>
							</fo:table-cell>
							<fo:table-cell>
								<fo:block xsl:use-attribute-sets="text" text-align="right">
									валюта: <xsl:value-of select="$currency"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>
					</fo:table-body>
			</fo:table>
	
			<xsl:call-template name="payList">
				<xsl:with-param name="nds_rate" select="$nds_rate"/>
			</xsl:call-template>
	
			<fo:block xsl:use-attribute-sets="text" space-before="0.1cm">
				* Цена не включает НДС
			</fo:block>
	
			<xsl:if test="@with_stamp">
				<fo:table start-indent="1cm" table-layout="fixed" width="100%">
					
					<fo:table-column column-width="2.7cm"/>
					<fo:table-column column-width="4.0cm"/>
					<fo:table-column column-width="proportional-column-width(1)"/>
					
					<fo:table-body>							
						<fo:table-row>
							<fo:table-cell>
								<fo:block/>
							</fo:table-cell>
							<fo:table-cell number-columns-spanned="2">
								<fo:block>
								<fo:external-graphic src="webroot/stamp.gif" width="4.1cm" height="3.85cm" content-height="3.85cm" content-width="4.1cm" space-before="0.2cm"/>
								</fo:block>
							</fo:table-cell>
						</fo:table-row>								
					</fo:table-body>
				</fo:table>	
			</xsl:if>
	
			<fo:table start-indent="1cm" table-layout="fixed" width="100%" >
				<xsl:choose>
					<xsl:when test="@with_stamp"><xsl:attribute name="space-before">-3.5cm</xsl:attribute></xsl:when>
					<xsl:otherwise><xsl:attribute name="space-before">0.5cm</xsl:attribute></xsl:otherwise>
				</xsl:choose>				
				
				<fo:table-column column-width="2.7cm"/>
				<fo:table-column column-width="4.0cm"/>
				<fo:table-column column-width="proportional-column-width(1)"/>
				
				<fo:table-body>
					<fo:table-row>
						<fo:table-cell number-columns-spanned="3">
							<fo:block xsl:use-attribute-sets="text_bold" start-indent="1cm">Итого к оплате: <xsl:value-of select="st:summaToString(@total_sum)" /></fo:block>
						</fo:table-cell>
					</fo:table-row>
				
					<fo:table-row>
						<fo:table-cell>
							<fo:block xsl:use-attribute-sets="text" start-indent="1cm" space-before="0.8cm">Счет выдал</fo:block>
						</fo:table-cell>
						<fo:table-cell border-bottom-style="solid" border-bottom-width="0.7pt">
							<fo:block/>
						</fo:table-cell>
						<fo:table-cell>
							<fo:block/>
						</fo:table-cell>
					</fo:table-row>
					
					<fo:table-row>
						<fo:table-cell number-columns-spanned="3">
							<fo:block xsl:use-attribute-sets="text_bold" start-indent="1cm" space-before="0.7cm">Для своевременного поступления суммы оплаты на Ваш Лицевой счет в платежном поручении просим указывать НОМЕР КОНТРАКТА!</fo:block>
						</fo:table-cell>
					</fo:table-row>					
				</fo:table-body>
			</fo:table>
		</fo:flow>	
		</fo:page-sequence>		
	</xsl:template>	
		
	<xsl:template name="calcNDS">
		<xsl:param name="nds_rate"/>
	
		<xsl:for-each select="pos">				
				<xsl:variable name="nds" select="number((@summ * ($nds_rate div 100))div($nds_rate div 100 + 1))" />
				<xsl:value-of select="counter:add( 'total_nds', format-number($nds, '0.00') )"/> 
		</xsl:for-each>
	</xsl:template>	
		
	<xsl:template name="payList">		
		<xsl:param name="nds_rate"/>
			
		<!-- начало таблицы счета -->	
		<fo:table space-before="0.3cm" table-layout="fixed">
		
		    <fo:table-column column-width="0.6cm"/>
		    <fo:table-column column-width="4.9cm"/>
		    <fo:table-column column-width="1.2cm"/>
		    <fo:table-column column-width="1.1cm"/>
		    <fo:table-column column-width="2.2cm"/>    	
		    <fo:table-column column-width="2.2cm"/>
		    <fo:table-column column-width="1.9cm"/>
		    <fo:table-column column-width="2.9cm"/>
		    	    	        	
			<fo:table-header>
			
				<fo:table-row>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">№</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Товар</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Ед.</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Кол-во</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Цена *</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Сумма</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">НДС</fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_center">Всего с НДС</fo:block>
				    </fo:table-cell>		    		    		    		    		    
			    </fo:table-row>
			
			</fo:table-header>
			
			
			<fo:table-body>
			
				<!-- начало цикл pay -->
				<xsl:for-each select="pos">
				
					<xsl:variable name="nds" select="number((@summ * ($nds_rate div 100))div($nds_rate div 100 + 1))" />
					<!-- <xsl:value-of select="counter:add( 'total_nds', format-number($nds, '0.00') )"/>   -->
					
					<fo:table-row>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_center"><xsl:value-of select="position()"/></fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_left"><xsl:value-of select="@name"/></fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_center">
					      		<xsl:if test="@unit">
					      			<xsl:value-of select="@unit"/>
					      		</xsl:if>	
					      		<xsl:if test="not(@unit)">
					      			месяц
					      		</xsl:if>						      
					      </fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_center">
					      		<xsl:if test="@quantity">
					      			<xsl:value-of select="@quantity"/>
					      		</xsl:if>	
					      		<xsl:if test="not(@quantity)">
					      			1
					      		</xsl:if>					      
					      </fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number(@summ - $nds, '0.00')"/></fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number(@summ - $nds, '0.00')"/></fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number($nds, '0.00')"/></fo:block>
					    </fo:table-cell>
					  	<fo:table-cell xsl:use-attribute-sets="cell_border">
					      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number(@summ, '0.00')"/></fo:block>
					    </fo:table-cell>
					</fo:table-row>
		
				</xsl:for-each>
				<!-- конец цикл pos -->
				
				
				<!-- итого -->
				<fo:table-row>
				  	<fo:table-cell><fo:block/></fo:table-cell>
				  	<fo:table-cell><fo:block/></fo:table-cell>
				  	<fo:table-cell>
				  		<fo:block xsl:use-attribute-sets="table_text_center">Итого:</fo:block>
				  	</fo:table-cell>
				  	<fo:table-cell><fo:block/></fo:table-cell>
				  	<fo:table-cell><fo:block/></fo:table-cell>
	
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number(@total_sum - counter:get( 'total_nds'), '0.00')"/></fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number( counter:get( 'total_nds'), '0.00')"/></fo:block>
				    </fo:table-cell>
				  	<fo:table-cell xsl:use-attribute-sets="cell_border">
				      <fo:block xsl:use-attribute-sets="table_text_right"><xsl:value-of select="format-number(@total_sum, '0.00')"/></fo:block>
				    </fo:table-cell>
				</fo:table-row>
				<!-- итого -->
				
			</fo:table-body>
	
		</fo:table>	
		
		<!-- конец таблицы счета -->
	</xsl:template>
			
	<xsl:template match="pay" mode="pay">
		<xsl:param name="curr_nds"/>

		<xsl:variable name="nds_param" select="params/@nds"/>
		<xsl:variable name="nds_rate_temp" select="number(/data/bill/attributes/@*[name()=$nds_param])"/>

		<xsl:variable name="nds_rate">
			<xsl:choose>
				<xsl:when test="contains($nds_rate_temp,'NaN')">
					<xsl:value-of select="number(/data/bill/params/@default_nds)"/>								
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="$nds_rate_temp"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="nds" select="round((@sum * ($nds_rate div 100))div($nds_rate div 100 + 1))" />

		<xsl:choose>
		<xsl:when test="not(following-sibling::*)">
			<xsl:value-of select="$curr_nds + $nds"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:apply-templates select="following-sibling::*[position()=1]" mode="pay"><xsl:with-param name="curr_nds" select="$curr_nds + $nds"/></xsl:apply-templates>
		</xsl:otherwise>
		</xsl:choose>
	</xsl:template> 
</xsl:stylesheet>
