/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.service;

import bitel.billing.server.util.MailMsg;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.jws.WebService;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.fop.apps.FOPException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.container.web.action.XSLManager;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountContractReport;
import ru.bitel.bgbilling.modules.bill.common.bean.AccountReport;
import ru.bitel.bgbilling.modules.bill.common.bean.Organization;
import ru.bitel.bgbilling.modules.bill.common.service.BillAccountReportService;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountContractReportDao;
import ru.bitel.bgbilling.modules.bill.server.bean.AccountReportDao;
import ru.bitel.bgbilling.modules.bill.server.bean.AttributeDao;
import ru.bitel.bgbilling.modules.bill.server.bean.OrganizationDao;
import ru.bitel.bgbilling.server.util.ModuleSetup;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.FOUtils;
import ru.bitel.common.Preferences;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrText;

@WebService(endpointInterface="ru.bitel.bgbilling.modules.bill.common.service.BillAccountReportService")
public class BillAccountReportServiceImpl
extends AbstractService
implements BillAccountReportService {
    public SearchResult<AccountReport> searchAccountReport(Period period, List<Integer> contractIds) throws BGException {
        SearchResult searchResult = new SearchResult(period, null);
        try (AccountReportDao accountReportDao = new AccountReportDao(this.getConnection(), this.moduleId);){
            accountReportDao.searchAccountReport((SearchResult<AccountReport>)searchResult, contractIds, Utils.toIntegerList((String)this.getModuleSetup().get("bill.reconciliation.report.invoice.type.ids", null)), Utils.toIntegerList((String)this.getModuleSetup().get("bill.reconciliation.report.payment.type.ids", null)));
        }
        return searchResult;
    }

    public SearchResult<AccountContractReport> searchAccountContractReport(Period period, List<Integer> contractIds) throws BGException {
        SearchResult searchResult = new SearchResult(period, null);
        try (AccountContractReportDao accountContractReportDao = new AccountContractReportDao(this.getConnection(), this.moduleId);){
            accountContractReportDao.searchAccountContractReport((SearchResult<AccountContractReport>)searchResult, contractIds);
        }
        return searchResult;
    }

    public byte[] getDocument(Period period, List<Integer> contractIds, int organizationId, String contractTitle) throws BGException {
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        Document outDoc = XMLUtils.newDocument();
        Element rootNode = XMLUtils.createElement((Document)outDoc, (String)"data");
        XSLManager.getInstance().transform((Source)new DOMSource(this.getDoc(period, contractIds, organizationId, contractTitle)), moduleSetup.get("act.sverki.xsl", "bill_pdf_act_sverki.xsl"), (Node)rootNode);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLUtils.serialize((Node)outDoc, (OutputStream)byteArrayOutputStream, (String)"utf-8");
        return byteArrayOutputStream.toByteArray();
    }

    public void sendDocumentToEmail(Period period, List<Integer> contractIds, int organizationId, String contractTitle, String email) throws BGException {
        Setup setup = Setup.getSetup();
        ModuleSetup moduleSetup = setup.getModuleSetup(Integer.valueOf(this.moduleId));
        MimeMultipart multipart = new MimeMultipart();
        try {
            MimeBodyPart mimeBodyPart = new MimeBodyPart();
            mimeBodyPart.setText(moduleSetup.get("mail.text", "").replace("\\n", "\n"), "utf-8");
            mimeBodyPart.setHeader("Content-Type", "text/" + moduleSetup.get("mail.text.type", "plain") + "; charset=utf-8;");
            multipart.addBodyPart((BodyPart)mimeBodyPart, 0);
            Document doc = this.getDoc(period, contractIds, organizationId, contractTitle);
            Element act = (Element)doc.getDocumentElement().getElementsByTagName("act").item(0);
            act.setAttribute("with_stamp", "1");
            final ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
            XSLManager.getInstance().transform((Source)new DOMSource(doc), moduleSetup.get("act.sverki.xsl", "bill_pdf_act_sverki.xsl"), (Result)FOUtils.renderSAXResult((OutputStream)baos, (String)"application/pdf"));
            String fileName = "\u0430\u043a\u0442-\u0441\u0432\u0435\u0440\u043a\u0438.pdf";
            DataSource dataSource = new DataSource(){

                public String getContentType() {
                    return "application/pdf";
                }

                public String getName() {
                    return "\u0430\u043a\u0442-\u0441\u0432\u0435\u0440\u043a\u0438.pdf";
                }

                public OutputStream getOutputStream() throws IOException {
                    return null;
                }

                public InputStream getInputStream() throws IOException {
                    return new ByteArrayInputStream(baos.toByteArray());
                }
            };
            MimeBodyPart attach = new MimeBodyPart();
            attach.setHeader("Content-Length", String.valueOf(baos.size()));
            attach.setDataHandler(new DataHandler(dataSource));
            attach.setFileName(MimeUtility.encodeText((String)"\u0430\u043a\u0442-\u0441\u0432\u0435\u0440\u043a\u0438.pdf", (String)"utf-8", (String)"B"));
            multipart.addBodyPart((BodyPart)attach);
            String subject = moduleSetup.get("mail.subject", "\u0410\u043a\u0442-\u0441\u0432\u0435\u0440\u043a\u0438");
            new MailMsg((Preferences)setup).sendMessage(email, subject, (Multipart)multipart);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Document getDoc(Period period, List<Integer> contractIds, int organizationId, String contractTitle) throws BGException {
        Document dataDoc = null;
        if (period != null) {
            if (period.getDateTo() != null) {
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(period.getDateTo());
                calendar.set(5, ((Calendar)calendar).getActualMaximum(5));
                GregorianCalendar now = new GregorianCalendar();
                if (now.before(calendar)) {
                    calendar.setTime(now.getTime());
                }
                period.setDateTo(calendar.getTime());
            } else {
                long time = System.currentTimeMillis();
                period.setDateTo(new Date(time - time % 1000L));
            }
        }
        try {
            dataDoc = XMLUtils.newDocument();
            Element dataNode = XMLUtils.createElement((Document)dataDoc, (String)"data");
            Element actElement = XMLUtils.createElement((Element)dataNode, (String)"act");
            actElement.setAttribute("date", TimeUtils.format((Date)new Date(), (String)"dd.MM.yyyy"));
            actElement.setAttribute("periodFrom", TimeUtils.format((Date)period.getDateFrom(), (String)"dd.MM.yyyy"));
            actElement.setAttribute("periodTo", TimeUtils.format((Date)period.getDateTo(), (String)"dd.MM.yyyy"));
            actElement.setAttribute("contractOrgName", contractTitle);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AccountReport.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            try (ContractDao contractDao = new ContractDao(this.getConnection(), 0);){
                Element contractsElement = XMLUtils.createElement((Element)actElement, (String)"contracts");
                for (int contractId : contractIds) {
                    Contract contract = (Contract)contractDao.get(contractId);
                    if (contract == null) continue;
                    Element contractElement = XMLUtils.createElement((Element)contractsElement, (String)"contract");
                    contractElement.setAttribute("id", String.valueOf(contractId));
                    contractElement.setAttribute("title", contract.getTitle());
                    contractElement.setAttribute("comment", contract.getComment());
                    contractElement.setAttribute("dateFrom", TimeUtils.format((Date)contract.getDateFrom(), (String)"dd.MM.yyyy"));
                    contractElement.setAttribute("dateTo", TimeUtils.format((Date)contract.getDateTo(), (String)"dd.MM.yyyy"));
                }
            }
            BigDecimal inSaldoCredit = BigDecimal.ZERO;
            BigDecimal inSaldoDebet = BigDecimal.ZERO;
            SearchResult<AccountContractReport> contractSearchResult = this.searchAccountContractReport(period, contractIds);
            for (AccountContractReport accountContractReport : contractSearchResult.getList()) {
                inSaldoCredit = inSaldoCredit.add(accountContractReport.getSaldoCreditIn());
                inSaldoDebet = inSaldoDebet.add(accountContractReport.getSaldoDebetIn());
            }
            AccountReport inAccountReport = new AccountReport();
            inAccountReport.setCreateDate(period.getDateFrom());
            inAccountReport.setDocument("\u0421\u0430\u043b\u044c\u0434\u043e \u043d\u0430\u0447\u0430\u043b\u044c\u043d\u043e\u0435");
            inAccountReport.setCreditSum(inSaldoCredit);
            inAccountReport.setDebetSum(inSaldoDebet);
            inAccountReport.setType(-1);
            marshaller.marshal((Object)inAccountReport, (Node)actElement);
            BigDecimal oborotCredit = BigDecimal.ZERO;
            BigDecimal oborotDebet = BigDecimal.ZERO;
            SearchResult<AccountReport> searchResult = this.searchAccountReport(period, contractIds);
            for (AccountReport accountReport : searchResult.getList()) {
                oborotCredit = oborotCredit.add(accountReport.getCreditSum());
                oborotDebet = oborotDebet.add(accountReport.getDebetSum());
                marshaller.marshal((Object)accountReport, (Node)actElement);
            }
            AccountReport oborotAccountReport = new AccountReport();
            oborotAccountReport.setCreateDate(period.getDateTo());
            oborotAccountReport.setDocument("\u041e\u0431\u043e\u0440\u043e\u0442\u044b \u0437\u0430 \u043f\u0435\u0440\u0438\u043e\u0434");
            oborotAccountReport.setCreditSum(oborotCredit);
            oborotAccountReport.setDebetSum(oborotDebet);
            oborotAccountReport.setType(-2);
            marshaller.marshal((Object)oborotAccountReport, (Node)actElement);
            oborotCredit = oborotCredit.add(inSaldoCredit);
            oborotDebet = oborotDebet.add(inSaldoDebet);
            BigDecimal outSaldoCredit = oborotCredit.subtract(oborotDebet);
            BigDecimal outSaldoDebet = oborotDebet.subtract(oborotCredit);
            AccountReport outAccountReport = new AccountReport();
            outAccountReport.setCreateDate(period.getDateTo());
            outAccountReport.setDocument("\u0421\u0430\u043b\u044c\u0434\u043e \u043a\u043e\u043d\u0435\u0447\u043d\u043e\u0435");
            outAccountReport.setCreditSum(outSaldoCredit.compareTo(BigDecimal.ZERO) > 0 ? outSaldoCredit : BigDecimal.ZERO);
            outAccountReport.setDebetSum(outSaldoDebet.compareTo(BigDecimal.ZERO) > 0 ? outSaldoDebet : BigDecimal.ZERO);
            outAccountReport.setType(-2);
            marshaller.marshal((Object)outAccountReport, (Node)actElement);
            Organization organization = null;
            try (OrganizationDao organizationDao = new OrganizationDao(this.getConnection(), this.moduleId);){
                organization = organizationDao.getOrganization(organizationId);
            }
            Element organizationElement = XMLUtils.createElement((Element)actElement, (String)"organization");
            if (organization != null) {
                Element paramElement = XMLUtils.createElement((Element)organizationElement, (String)"param");
                paramElement.setAttribute("name", "title");
                paramElement.setAttribute("value", organization.getTitle());
                JSONObject jsonObject = new JSONObject(organization.getData());
                for (String name : jsonObject.keySet()) {
                    paramElement = XMLUtils.createElement((Element)organizationElement, (String)"param");
                    paramElement.setAttribute("name", name);
                    paramElement.setAttribute("value", jsonObject.optString(name));
                }
            }
        }
        catch (Exception ex) {
            throw new BGException((Throwable)ex);
        }
        return dataDoc;
    }

    public String getXmlDocument(Period period, List<Integer> contractIds, int organizationId, String contractTitle) throws BGException {
        StringWriter sw = new StringWriter();
        XMLUtils.serialize((Node)this.getDoc(period, contractIds, organizationId, contractTitle), (Result)new StreamResult(sw), (String)"utf-8", (boolean)true);
        return sw.toString();
    }

    public byte[] getPdfDocument(Period period, List<Integer> contractIds, int organizationId, String contractTitle) throws BGException {
        Document doc = this.getDoc(period, contractIds, organizationId, contractTitle);
        Element act = (Element)doc.getDocumentElement().getElementsByTagName("act").item(0);
        act.setAttribute("with_stamp", "1");
        ModuleSetup moduleSetup = Setup.getSetup().getModuleSetup(Integer.valueOf(this.moduleId));
        ByteArrayOutputStream baos = new ByteArrayOutputStream(50000);
        try {
            XSLManager.getInstance().transform((Source)new DOMSource(doc), moduleSetup.get("act.sverki.xsl", "bill_pdf_act_sverki.xsl"), (Result)FOUtils.renderSAXResult((OutputStream)baos, (String)"application/pdf"));
        }
        catch (FOPException e) {
            e.printStackTrace();
        }
        return baos.toByteArray();
    }

    public static void main(String[] args) {
        Document dataDoc = XMLUtils.newDocument();
        Element dataNode = XMLUtils.createElement((Document)dataDoc, (String)"data");
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{AccountReport.class, ArrayList.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            ArrayList<AccountReport> list = new ArrayList<AccountReport>();
            AccountReport accountReport = new AccountReport();
            accountReport.setId(2);
            accountReport.setContractId(1);
            accountReport.setCreateDate(new Date());
            accountReport.setCreditSum(BigDecimal.ZERO);
            accountReport.setDebetSum(new BigDecimal("3241230.3452"));
            list.add(accountReport);
            accountReport = new AccountReport();
            accountReport.setId(1);
            accountReport.setContractId(1);
            accountReport.setCreateDate(new Date());
            list.add(accountReport);
            for (AccountReport accountReport1 : list) {
                marshaller.marshal((Object)accountReport1, (Node)dataNode);
            }
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        StringWriter sw = new StringWriter();
        XMLUtils.serialize((Node)dataDoc, (Result)new StreamResult(sw), (String)"utf-8", (boolean)true);
        System.out.println(sw.toString());
    }

    public List<String> getContractTitles(Set<Integer> contractIds) throws BGException {
        try (AttributeDao attributeDao = new AttributeDao(this.getConnection(), this.moduleId);){
            List<String> list;
            try (ContractDao contractDao = new ContractDao(this.getConnection(), 0);){
                HashSet titles = new HashSet();
                attributeDao.getActiveAttributeList(contractIds).forEach(e -> {
                    if ("org_name".equals(e.getName())) {
                        String value = e.getValue();
                        if (e.getContractParamPrefId() > 0) {
                            try {
                                Contract contract;
                                EntityAttrText entityAttrText = (EntityAttrText)contractDao.getContractParameter(e.getContractId(), e.getContractParamPrefId());
                                String string = value = entityAttrText != null ? entityAttrText.getValue() : null;
                                if (value == null && e.isUseSuperContract() && (contract = (Contract)contractDao.get(e.getContractId())).isSub()) {
                                    entityAttrText = (EntityAttrText)contractDao.getContractParameter(contract.getSuperCid(), e.getContractParamPrefId());
                                    value = entityAttrText != null ? entityAttrText.getValue() : null;
                                }
                            }
                            catch (BGException e1) {
                                e1.printStackTrace();
                            }
                        }
                        titles.add(value);
                    }
                });
                list = titles.stream().collect(Collectors.toList());
            }
            return list;
        }
    }
}

