/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.bill.server.action;

import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.modules.bill.server.action.base.ActionBase;
import ru.bitel.bgbilling.modules.bill.server.bean.BillDoc;
import ru.bitel.bgbilling.modules.bill.server.bean.BillManager;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.Utils;

public class ActionDeleteBill
extends ActionBase {
    public void doAction() throws SQLException, BGException {
        final int id = this.getIntParameter("id", -1);
        String ids = this.getParameter("ids", "");
        if (this.mid <= 0) {
            throw new BGIllegalArgumentException();
        }
        List<Integer> idsdoc = null;
        if (!Utils.isEmptyString((String)ids)) {
            ids = ids.substring(0, ids.length() - 1).replaceAll(";", ",");
            idsdoc = Utils.toIntegerList((String)ids);
        } else {
            idsdoc = new ArrayList<Integer>(){
                {
                    this.add(id);
                }
            };
        }
        try (BillManager pbm = new BillManager(this.con, this.mid);){
            Calendar closedDate = null;
            closedDate = ClosedDateChecker.getClosePeriodDateIfChecking((String)"ActionDeleteBill", (int)this.mid, (int)this.userId);
            if (closedDate != null) {
                for (Integer iddoc : idsdoc) {
                    BillDoc doc = pbm.getBillDocInfo(iddoc);
                    if (doc == null) continue;
                    LocalDate month = LocalDate.of(doc.getYy(), doc.getMm() + 1, 1);
                    ClosedDateChecker.checkDatesForDelete((Calendar)closedDate, (LocalDate)month);
                }
            }
            pbm.delete(idsdoc);
        }
    }
}

