/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.plugins.assistant.server.servlet;

import bitel.billing.server.admin.bgsecure.bean.UserLoginModule;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.security.auth.Subject;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.bitel.bgbilling.common.model.KeyValue;
import ru.bitel.bgbilling.kernel.base.server.CommonExecutor;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractTariff;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractTariffDao;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.ChargeTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.util.BalanceUtils;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.tariff.server.bean.TariffPlanDao;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantAction;
import ru.bitel.bgbilling.plugins.assistant.common.bean.AssistantButton;
import ru.bitel.bgbilling.plugins.assistant.common.service.AssistantService;
import ru.bitel.bgbilling.server.util.ServletUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;
import ru.bitel.common.model.SearchResult;
import ru.bitel.common.worker.ThreadContext;

@WebServlet(name="assistantExecutor", urlPatterns={"/assistant/*"})
public class AssistantExecutor
extends CommonExecutor {
    private static Logger logger = LogManager.getLogger();
    private static final String[] operations = new String[]{"assistantActionsForUser", "getAssistantActionByActionId", "doShow", "doButton"};
    private static String pluginId = "";

    public void init() throws ServletException {
        super.init();
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setAttribute("contextPath", (Object)this.setup.get("context.path", "/bgbilling"));
        HttpSession session = request.getSession(true);
        if (session.getAttribute("userId") == null) {
            this.getLoginAndPassword(request);
            String userName = (String)request.getAttribute("userName");
            String userPswd = (String)request.getAttribute("userPswd");
            if (userName != null && userPswd != null) {
                String userNameIp = String.format("%s [%s]", userName, ServletUtils.getIpFromHeader((HttpServletRequest)request, (Setup)this.setup));
                String msg = "";
                try {
                    Subject subject = UserLoginModule.auth((String)"executer", (String)userName, (String)userPswd);
                    User user = UserLoginModule.getUser((Subject)subject);
                    request.setAttribute("userId", (Object)user.getId());
                    session.setAttribute("userId", (Object)user.getId());
                }
                catch (FailedLoginException e) {
                    if (e.getCause() instanceof AuthenticationException) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?";
                        logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP. \u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u043f\u0430\u0440\u043e\u043b\u044c?", (Throwable)e);
                    } else if (e.getCause() instanceof CommunicationException) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                        logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                    } else if ("Cannot find user's LDAP entry".equals(e.getMessage())) {
                        msg = "\u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP.";
                        logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438 \u0432 LDAP", (Throwable)e);
                    } else {
                        msg = e.getLocalizedMessage();
                        logger.warn(userNameIp + " \u041e\u0448\u0438\u0431\u043a\u0430 \u0430\u0443\u0442\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u0438", (Throwable)e);
                    }
                }
                catch (LoginException e) {
                    msg = e.getLocalizedMessage();
                    logger.warn(userNameIp + " " + e.getMessage(), (Throwable)e);
                }
            }
        }
        if (session.getAttribute("userId") == null) {
            response.setHeader("WWW-Authenticate", "Basic realm=\"BGAssistant\"");
            response.sendError(401, "\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u044f");
            return;
        }
        String path = request.getPathInfo();
        if (path == null || path.isEmpty()) {
            this.requestDispatcher("body", request, response);
        } else {
            if (path.startsWith("/exit")) {
                session.invalidate();
                response.sendRedirect("assistant/menu");
                return;
            }
            if (path.startsWith("/action/")) {
                this.action(path.substring(8), request, response);
            } else if (path.startsWith("/doButton/")) {
                this.doButton(path.substring(10), request, response);
            } else if (path.startsWith("/contract/")) {
                this.getContracts(path.substring(10), request, response);
            } else if (path.startsWith("/menu")) {
                this.menu(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void menu(HttpServletRequest request, HttpServletResponse response) {
        ServerContext serverContext = this.getServerContext(request);
        try {
            Integer userId = (Integer)request.getSession().getAttribute("userId");
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            request.setAttribute("assistantActionItems", (Object)assistantService.assistantActionsForUser(userId != null ? userId : -1));
            this.requestDispatcher("menu", request, response);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            serverContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void action(String actionId, HttpServletRequest request, HttpServletResponse response) {
        ServerContext serverContext = this.getServerContext(request);
        try {
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            AssistantAction assistantAction = assistantService.getAssistantActionByActionId(actionId);
            request.setAttribute("assistantAction", (Object)assistantAction);
            JSONObject configJsonObject = new JSONObject(assistantAction.getConfig());
            JSONObject options = configJsonObject.optJSONObject("options");
            if (options == null) {
                options = new JSONObject();
            }
            List<Map<String, Object>> fields = this.getFields(configJsonObject.optJSONArray("params"), options);
            String dataParam = request.getParameter("data");
            JSONObject dataJson = new JSONObject(dataParam == null ? "{}" : dataParam);
            List contractIds = (List)request.getSession().getAttribute("contractIds");
            if (contractIds != null && !contractIds.isEmpty()) {
                dataJson.put("contractId", Utils.parseInt((String)((String)contractIds.get(0))));
            }
            JSONObject fieldsJSON = new JSONObject();
            dataJson.put("fields", (Object)fieldsJSON);
            String data = assistantService.doShow(actionId, dataJson.toString());
            JSONObject showJSON = new JSONObject(data);
            JSONObject fieldValuesJSON = showJSON.optJSONObject("fieldValues");
            if (fieldValuesJSON != null) {
                for (Map<String, Object> map : fields) {
                    String key = (String)map.get("key");
                    Object value = fieldValuesJSON.opt(key);
                    if (value == null) continue;
                    String type = String.valueOf(map.get("type"));
                    if ("List".equals(type) || "Combox".equals(type)) {
                        if (!(value instanceof JSONArray)) continue;
                        ArrayList<KeyValue> values = new ArrayList<KeyValue>();
                        JSONArray array = (JSONArray)value;
                        for (int index = 0; index < array.length(); ++index) {
                            JSONObject valuesItem = array.getJSONObject(index);
                            values.add(new KeyValue(valuesItem.optString("key"), valuesItem.optString("value")));
                        }
                        map.put("values", values);
                        continue;
                    }
                    if ("Date".equals(type) || "Textarea".equals(type) || "String".equals(type)) {
                        map.put("value", value);
                        continue;
                    }
                    if (!"Period".equals(type) || !(value instanceof JSONObject)) continue;
                    JSONObject periodJSON = (JSONObject)value;
                    map.put("valueFrom", periodJSON.optString("dateFrom"));
                    map.put("valueTo", periodJSON.optString("dateTo"));
                }
            }
            request.setAttribute("message", (Object)configJsonObject.optString("comment", null));
            request.setAttribute("fields", fields);
            request.setAttribute("buttons", this.getButtons(options));
            this.requestDispatcher("action", request, response);
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        finally {
            serverContext.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doButton(String buttonInfo, HttpServletRequest request, HttpServletResponse response) {
        String buttonCode = buttonInfo.substring(0, buttonInfo.indexOf(47));
        String actionId = buttonInfo.substring(buttonInfo.indexOf(47) + 1);
        JSONObject dataJson = new JSONObject();
        dataJson.put("fields", (Object)new JSONObject(request.getParameter("data")));
        ServerContext serverContext = this.getServerContext(request);
        try {
            String openContractId;
            AssistantService assistantService = (AssistantService)serverContext.getService(AssistantService.class, -1);
            String resultOfPressButton = assistantService.doButton(actionId, dataJson.toString(), buttonCode);
            response.setContentType("text/json");
            response.getOutputStream().write(resultOfPressButton.getBytes("UTF-8"));
            JSONObject resultJsonObject = new JSONObject(resultOfPressButton);
            JSONObject fieldsOfResponse = resultJsonObject.optJSONObject("fields");
            if (fieldsOfResponse != null && (openContractId = fieldsOfResponse.optString("openContract")) != null) {
                List<String> contractIds = (ArrayList<String>)request.getSession().getAttribute("contractIds");
                if (contractIds == null) {
                    contractIds = new ArrayList<String>();
                }
                if (!contractIds.contains(openContractId)) {
                    contractIds.add(0, openContractId);
                } else {
                    contractIds = this.resortContractIds(openContractId, contractIds);
                }
                request.getSession().setAttribute("contractIds", contractIds);
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
            JSONObject result = new JSONObject();
            result.put("status", (Object)"error");
            result.put("error", (Object)ex.getCause().getMessage());
            response.setContentType("text/json");
            try {
                response.getOutputStream().write(result.toString().getBytes("UTF-8"));
            }
            catch (Exception ex1) {
                logger.error((Object)ex1);
            }
            return;
        }
        finally {
            serverContext.destroy();
        }
    }

    private List<String> resortContractIds(String openContractId, List<String> contractIds) {
        if (contractIds.contains(openContractId)) {
            ArrayList<String> newContractIds = new ArrayList<String>();
            newContractIds.add(openContractId);
            for (String contractId : contractIds) {
                if (contractId.equals(openContractId)) continue;
                newContractIds.add(contractId);
            }
            return newContractIds;
        }
        return contractIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getContracts(String contractId, HttpServletRequest request, HttpServletResponse response) {
        block51: {
            List<String> contracts = (ArrayList<String>)request.getSession().getAttribute("contractIds");
            if (contracts == null) {
                contracts = new ArrayList<String>();
            }
            contracts = this.resortContractIds(contractId, contracts);
            request.getSession().setAttribute("contractIds", contracts);
            if (!contracts.isEmpty()) {
                ServerContext serverContext = this.getServerContext(request);
                Connection con = serverContext.getConnection();
                try (BalanceUtils balanceUtils = new BalanceUtils(con);
                     ContractDao contractDao = new ContractDao(con, 0);
                     TariffPlanDao tariffPlanDao = new TariffPlanDao(con);
                     ContractTariffDao contractTariffDao = new ContractTariffDao(con);){
                    Contract contract = (Contract)contractDao.get(Utils.parseInt((String)contracts.get(0)));
                    if (contract == null) break block51;
                    request.setAttribute("contract", (Object)contract);
                    request.setAttribute("contractStatus", (Object)StatusCache.getInstance().getStatusTitle((int)contract.getStatus()));
                    ArrayList contractTariffs = new ArrayList();
                    for (ContractTariff contractTariff : contractTariffDao.list(contract.getId(), new Date())) {
                        HashMap<String, Object> contractTariffMap = new HashMap<String, Object>();
                        contractTariffMap.put("period", contractTariff.getPeriod());
                        contractTariffMap.put("tariffPlan", tariffPlanDao.get(contractTariff.getTariffPlanId()));
                        contractTariffs.add(contractTariffMap);
                    }
                    request.setAttribute("contractTariffs", contractTariffs);
                    request.setAttribute("contractBalance", (Object)balanceUtils.getBalanceOut(new Date(), contract.getId()));
                    ArrayList<Integer> contractIds = new ArrayList<Integer>();
                    contractIds.add(contract.getId());
                    try (PaymentDao paymentDao = new PaymentDao(con);
                         PaymentTypeDao paymentTypeDao = new PaymentTypeDao(con);){
                        SearchResult searchResult = new SearchResult();
                        paymentDao.searchLastPaymentList(searchResult, contractIds, 2);
                        List payments = searchResult.getList();
                        ArrayList<Integer> typeIds = new ArrayList<Integer>();
                        for (Payment payment : payments) {
                            int typeId = payment.getTypeId();
                            if (typeIds.contains(typeId)) continue;
                            typeIds.add(typeId);
                        }
                        request.setAttribute("contractPayments", (Object)payments);
                        request.setAttribute("contractPaymentTypes", (Object)paymentTypeDao.getTypeMapByIds(typeIds));
                    }
                    LocalDate now = LocalDate.now();
                    try (ChargeDao chargeDao = new ChargeDao(con);
                         ChargeTypeDao chargeTypeDao = new ChargeTypeDao(con);){
                        Period period = new Period(now.withDayOfMonth(1).minusMonths(1L), now);
                        SearchResult searchResult = new SearchResult(period, null, new String[]{"date:1"});
                        chargeDao.searchChargeList(searchResult, contractIds);
                        List charges = searchResult.getList();
                        if (charges.isEmpty()) {
                            chargeDao.searchLastChargeList(searchResult, contractIds, 2);
                        }
                        ArrayList<Integer> typeIds = new ArrayList<Integer>();
                        for (Charge charge : charges) {
                            int typeId = charge.getTypeId();
                            if (typeIds.contains(typeId)) continue;
                            typeIds.add(typeId);
                        }
                        request.setAttribute("contractCharges", (Object)charges);
                        request.setAttribute("contractChargeTypes", (Object)chargeTypeDao.getTypeMapByIds(typeIds));
                    }
                    ArrayList<Map<String, Object>> accounts = new ArrayList<Map<String, Object>>();
                    this.addAccountData(now, contractIds, accounts, con);
                    this.addAccountData(now.minusMonths(1L), contractIds, accounts, con);
                    request.setAttribute("contractAccounts", accounts);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    serverContext.destroy();
                }
            }
        }
        this.requestDispatcher("contracts", request, response);
    }

    private List<Map<String, Object>> getButtons(JSONObject options) {
        ArrayList<Map<String, Object>> buttons = new ArrayList<Map<String, Object>>();
        for (String key : new String[]{"1", "2", "3", "4", "Cancel"}) {
            if (!options.optBoolean("windowShowButton" + key, false)) continue;
            AssistantButton assistantButton = AssistantButton.getAssistantButtonByCode((String)("button" + key));
            HashMap<String, String> buttonMap = new HashMap<String, String>();
            buttonMap.put("code", assistantButton.getCode());
            buttonMap.put("title", options.optString("windowTextButton" + key, assistantButton.getTitle()));
            buttons.add(buttonMap);
        }
        return buttons;
    }

    private List<Map<String, Object>> getFields(JSONArray params, JSONObject options) {
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        if (params != null) {
            for (int index = 0; index < params.length(); ++index) {
                JSONObject paramObject = params.getJSONObject(index);
                Object type = paramObject.optString("type");
                type = ((String)type).substring(0, 1).toUpperCase() + ((String)type).substring(1);
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                paramMap.put("key", paramObject.optString("key"));
                paramMap.put("type", type);
                paramMap.put("title", paramObject.optString("title"));
                paramMap.put("value", paramObject.optString("value"));
                paramMap.put("comment", paramObject.optString("comment", null));
                fields.add(paramMap);
            }
        }
        return fields;
    }

    private ServerContext getServerContext(HttpServletRequest request) {
        Integer userId = (Integer)request.getSession().getAttribute("userId");
        if (userId == null) {
            userId = 0;
        }
        ServerContext serverContext = new ServerContext(Setup.getSetup(), -1, userId.intValue());
        ServerContext.set((ThreadContext)serverContext);
        return serverContext;
    }

    private void requestDispatcher(String jsp, HttpServletRequest request, HttpServletResponse response) {
        try {
            response.setContentType("text/html; charset=utf-8");
            request.getRequestDispatcher("/WEB-INF/jspf/assistant/" + jsp + ".jsp").include((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addAccountData(LocalDate localDate, List<Integer> contractIds, List<Map<String, Object>> accounts, Connection con) {
        String query = "SELECT t2.title, t1.summa FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(contractIds) + " ) AND mm=? AND yy=?";
        try (PreparedStatement ps = con.prepareStatement(query);){
            ps.setInt(1, localDate.getMonthValue());
            ps.setInt(2, localDate.getYear());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                String title = rs.getString(1);
                map.put("date", TimeUtils.convertLocalDateToDate((LocalDate)localDate));
                map.put("title", title == null ? "?" : title);
                map.put("sum", rs.getBigDecimal(2));
                accounts.add(map);
            }
            rs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

