/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.stack;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.event.TrapListener;
import uk.co.westhawk.snmp.pdu.DiscoveryPdu;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.SnmpContextBasisFace;
import uk.co.westhawk.snmp.stack.SnmpContextPoolItem;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.SnmpContextv3Face;
import uk.co.westhawk.snmp.stack.UsmAgent;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class SnmpContextv3Pool
implements SnmpContextv3Face {
    private static final String version_id = "@(#)$Id: SnmpContextv3Pool.java,v 3.25 2006/11/30 17:37:06 birgit Exp $ Copyright Westhawk Ltd";
    protected static Hashtable contextPool;
    protected String hostname;
    protected String socketType;
    protected String bindAddr;
    protected int hostPort;
    protected SnmpContextv3 context = null;
    protected String userName = "";
    protected boolean useAuthentication = false;
    protected String userAuthenticationPassword = "";
    protected boolean usePrivacy = false;
    protected String userPrivacyPassword = "";
    protected int authenticationProtocol = 0;
    protected byte[] contextEngineId = new byte[0];
    protected String contextName = "";
    protected UsmAgent usmAgent = null;
    protected boolean hasChanged = false;

    public SnmpContextv3Pool(String host, int port) throws IOException {
        this(host, port, null, "Standard");
    }

    public SnmpContextv3Pool(String host, int port, String typeSocket) throws IOException {
        this(host, port, null, typeSocket);
    }

    public SnmpContextv3Pool(String host, int port, String bindAddress, String typeSocket) throws IOException {
        SnmpContextv3Pool.initPools();
        this.hostname = host;
        this.hostPort = port;
        this.bindAddr = bindAddress;
        this.socketType = typeSocket;
    }

    private static synchronized void initPools() {
        if (contextPool == null) {
            contextPool = new Hashtable(5);
        }
    }

    public int getVersion() {
        return 3;
    }

    public String getHost() {
        return this.hostname;
    }

    public int getPort() {
        return this.hostPort;
    }

    public String getBindAddress() {
        return this.bindAddr;
    }

    public String getTypeSocket() {
        return this.socketType;
    }

    public String getSendToHostAddress() {
        String res = null;
        if (this.context != null) {
            res = this.context.getSendToHostAddress();
        }
        return res;
    }

    public String getReceivedFromHostAddress() {
        String res = null;
        if (this.context != null) {
            res = this.context.getReceivedFromHostAddress();
        }
        return res;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String newUserName) {
        if (newUserName != null && !newUserName.equals(this.userName)) {
            this.userName = newUserName;
            this.hasChanged = true;
        }
    }

    public boolean isUseAuthentication() {
        return this.useAuthentication;
    }

    public void setUseAuthentication(boolean newUseAuthentication) {
        if (newUseAuthentication != this.useAuthentication) {
            this.useAuthentication = newUseAuthentication;
            this.hasChanged = true;
        }
    }

    public String getUserAuthenticationPassword() {
        return this.userAuthenticationPassword;
    }

    public void setUserAuthenticationPassword(String newUserAuthenticationPd) {
        if (newUserAuthenticationPd != null && !newUserAuthenticationPd.equals(this.userAuthenticationPassword)) {
            this.userAuthenticationPassword = newUserAuthenticationPd;
            this.hasChanged = true;
        }
    }

    public void setAuthenticationProtocol(int protocol) throws IllegalArgumentException {
        if (protocol == 0 || protocol == 1) {
            if (protocol != this.authenticationProtocol) {
                this.authenticationProtocol = protocol;
                this.hasChanged = true;
            }
        } else {
            this.hasChanged = false;
            throw new IllegalArgumentException("Authentication Protocol should be MD5 or SHA1");
        }
    }

    public int getAuthenticationProtocol() {
        return this.authenticationProtocol;
    }

    public boolean isUsePrivacy() {
        return this.usePrivacy;
    }

    public void setUsePrivacy(boolean newUsePrivacy) {
        if (newUsePrivacy != this.usePrivacy) {
            this.usePrivacy = newUsePrivacy;
            this.hasChanged = true;
        }
    }

    public String getUserPrivacyPassword() {
        return this.userPrivacyPassword;
    }

    public void setUserPrivacyPassword(String newUserPrivacyPd) {
        if (newUserPrivacyPd != null && !newUserPrivacyPd.equals(this.userPrivacyPassword)) {
            this.userPrivacyPassword = newUserPrivacyPd;
            this.hasChanged = true;
        }
    }

    public void setContextEngineId(byte[] newContextEngineId) throws IllegalArgumentException {
        if (newContextEngineId != null) {
            if (!newContextEngineId.equals(this.contextEngineId)) {
                this.contextEngineId = newContextEngineId;
                this.hasChanged = true;
            }
        } else {
            this.hasChanged = false;
            throw new IllegalArgumentException("contextEngineId is null");
        }
    }

    public byte[] getContextEngineId() {
        return this.contextEngineId;
    }

    public void setContextName(String newContextName) {
        if (newContextName != null && !newContextName.equals(this.contextName)) {
            this.contextName = newContextName;
            this.hasChanged = true;
        }
    }

    public String getContextName() {
        return this.contextName;
    }

    public void setUsmAgent(UsmAgent newAgent) {
        if (newAgent != null && newAgent != this.usmAgent) {
            this.usmAgent = newAgent;
            this.hasChanged = true;
        }
    }

    public UsmAgent getUsmAgent() {
        return this.usmAgent;
    }

    public boolean addDiscoveryPdu(DiscoveryPdu pdu) throws IOException, PduException, IllegalArgumentException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        return this.context.addDiscoveryPdu(pdu);
    }

    public boolean addPdu(Pdu pdu) throws IOException, PduException, IllegalArgumentException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        return this.context.addPdu(pdu);
    }

    public boolean removePdu(int requestId) {
        boolean res = false;
        if (this.context != null) {
            res = this.context.removePdu(requestId);
        }
        return res;
    }

    public byte[] encodeDiscoveryPacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodeDiscoveryPacket(msg_type, rId, errstat, errind, ve, obj);
        }
        return res;
    }

    public byte[] encodePacket(byte msg_type, int rId, int errstat, int errind, Enumeration ve, Object obj) throws IOException, EncodingException {
        byte[] res = null;
        if (this.context != null) {
            res = this.context.encodePacket(msg_type, rId, errstat, errind, ve, obj);
        }
        return res;
    }

    public void sendPacket(byte[] packet) {
        if (this.context != null) {
            this.context.sendPacket(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        block9: {
            try {
                if (this.hasChanged) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block9;
                System.out.println(this.getClass().getName() + ".destroy(): " + exc.getMessage());
            }
        }
        if (this.context != null) {
            String hashKey = this.getHashKey();
            Hashtable hashtable = contextPool;
            synchronized (hashtable) {
                int count = 0;
                SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(hashKey);
                if (item != null) {
                    count = item.getCounter();
                    item.setCounter(--count);
                }
                if (count <= 0) {
                    contextPool.remove(hashKey);
                    this.context.destroy();
                    this.context = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyPool() {
        Hashtable copyOfPool = null;
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            Hashtable hashtable2 = contextPool;
            synchronized (hashtable2) {
                copyOfPool = (Hashtable)contextPool.clone();
            }
            contextPool.clear();
        }
        this.context = null;
        this.hasChanged = true;
        Enumeration keys = copyOfPool.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)copyOfPool.get(key);
            if (item == null) continue;
            SnmpContextBasisFace cntxt = item.getContext();
            cntxt.destroy();
        }
        copyOfPool.clear();
    }

    public boolean isDestroyed() {
        boolean isDestroyed = true;
        if (this.context != null) {
            isDestroyed = this.context.isDestroyed();
        }
        return isDestroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SnmpContextv3 getMatchingContext() throws IOException, IllegalArgumentException {
        SnmpContextPoolItem item = null;
        SnmpContextv3 newContext = null;
        String hashKey = this.getHashKey();
        Hashtable hashtable = contextPool;
        synchronized (hashtable) {
            int count = 0;
            if (contextPool.containsKey(hashKey)) {
                item = (SnmpContextPoolItem)contextPool.get(hashKey);
                newContext = (SnmpContextv3)item.getContext();
                count = item.getCounter();
            } else {
                newContext = new SnmpContextv3(this.hostname, this.hostPort, this.bindAddr, this.socketType);
                newContext.setContextEngineId(this.contextEngineId);
                newContext.setContextName(this.contextName);
                newContext.setUserName(this.userName);
                newContext.setUseAuthentication(this.useAuthentication);
                newContext.setUserAuthenticationPassword(this.userAuthenticationPassword);
                newContext.setAuthenticationProtocol(this.authenticationProtocol);
                newContext.setUsePrivacy(this.usePrivacy);
                newContext.setUserPrivacyPassword(this.userPrivacyPassword);
                newContext.setUsmAgent(this.usmAgent);
                item = new SnmpContextPoolItem(newContext);
                contextPool.put(hashKey, item);
            }
            this.hasChanged = false;
            item.setCounter(++count);
        }
        return newContext;
    }

    public void dumpContexts(String title) {
        block5: {
            try {
                if (this.hasChanged) {
                    this.context = this.getMatchingContext();
                }
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block5;
                System.out.println(this.getClass().getName() + ".dumpContexts(): " + exc.getMessage());
            }
        }
        System.out.println(title + " " + contextPool.size() + " context(s)");
        Enumeration keys = contextPool.keys();
        int i = 0;
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            SnmpContextPoolItem item = (SnmpContextPoolItem)contextPool.get(key);
            if (item == null) continue;
            int count = item.getCounter();
            SnmpContextv3 cntxt = (SnmpContextv3)item.getContext();
            if (cntxt == this.context) {
                System.out.println("\tcurrent context: ");
            }
            System.out.println("\tcontext " + i + ": " + key + ", count: " + count + ", " + cntxt.toString() + "\n" + ", " + cntxt.getDebugString());
            ++i;
        }
        System.out.println("\thasChanged: " + this.hasChanged);
    }

    public String getHashKey() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.hostname);
        buffer.append("_").append(this.hostPort);
        buffer.append("_").append(this.bindAddr);
        buffer.append("_").append(this.socketType);
        buffer.append("_").append(this.useAuthentication);
        buffer.append("_").append(this.authenticationProtocol);
        buffer.append("_").append(this.userAuthenticationPassword);
        buffer.append("_").append(this.userName);
        buffer.append("_").append(this.usePrivacy);
        buffer.append("_").append(this.userPrivacyPassword);
        buffer.append("_").append(SnmpUtilities.toHexString(this.contextEngineId));
        buffer.append("_").append(this.contextName);
        buffer.append("_v").append(this.getVersion());
        return buffer.toString();
    }

    public void addTrapListener(TrapListener l) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addTrapListener(l);
    }

    public void removeTrapListener(TrapListener l) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeTrapListener(l);
    }

    public void addTrapListener(TrapListener l, int port) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addTrapListener(l, port);
    }

    public void removeTrapListener(TrapListener l, int port) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeTrapListener(l, port);
    }

    public void addTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addTrapListener(l, lcontext);
    }

    public void removeTrapListener(TrapListener l, ListeningContextPool lcontext) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeTrapListener(l, lcontext);
    }

    public void addRequestPduListener(RequestPduListener l) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addRequestPduListener(l);
    }

    public void removeRequestPduListener(RequestPduListener l) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeRequestPduListener(l);
    }

    public void addRequestPduListener(RequestPduListener l, int port) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addRequestPduListener(l, port);
    }

    public void removeRequestPduListener(RequestPduListener l, int port) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeRequestPduListener(l, port);
    }

    public void addRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.addRequestPduListener(l, lcontext);
    }

    public void removeRequestPduListener(RequestPduListener l, ListeningContextPool lcontext) throws IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        this.context.removeRequestPduListener(l, lcontext);
    }

    public Pdu processIncomingPdu(byte[] message) throws DecodingException, IOException {
        if (this.hasChanged || this.context == null) {
            this.context = this.getMatchingContext();
        }
        Pdu pdu = null;
        pdu = this.context.processIncomingPdu(message);
        return pdu;
    }

    public String toString() {
        String res;
        block3: {
            res = "";
            try {
                if (this.hasChanged || this.context == null) {
                    this.context = this.getMatchingContext();
                }
                res = this.context.toString();
            }
            catch (IOException exc) {
                if (AsnObject.debug <= 0) break block3;
                System.out.println(this.getClass().getName() + ".toString(): " + exc.getMessage());
            }
        }
        return res;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }
}

