/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.oss.systems.inventory.resource.common.bean.DeviceInterfaceIndex;

public class DeviceInterfaceIndexDao {
    private final Connection con;
    private final String tableName;

    public DeviceInterfaceIndexDao(Connection con, int moduleId) {
        this.con = con;
        this.tableName = moduleId > 0 ? "inv_device_interface_index_" + moduleId : "inv_device_interface_index";
    }

    protected DeviceInterfaceIndex getFromRS(ResultSet rs) throws SQLException, BGException {
        DeviceInterfaceIndex result = new DeviceInterfaceIndex();
        result.setId(rs.getInt("id"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setPort(rs.getInt("interfaceId"));
        result.setTimeFrom(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeFrom")));
        result.setTimeTo(TimeUtils.convertTimestampToDate(rs.getTimestamp("timeTo")));
        result.setIndex(rs.getInt("ifIndex"));
        return result;
    }

    public void update(int deviceId, int interfaceId, List<DeviceInterfaceIndex> interfaceIndexList) throws BGException {
        try {
            PreparedStatement insertPS = this.con.prepareStatement("INSERT INTO " + this.tableName + " (deviceId, interfaceId, timeFrom, timeTo, ifIndex) VALUES (?, ?, ?, ?, ?)", 1);
            PreparedStatement updatePS = this.con.prepareStatement("UPDATE " + this.tableName + " SET timeFrom=?, timeTo=?, ifIndex=? WHERE id=?");
            HashSet<Integer> ids = new HashSet<Integer>();
            if (interfaceIndexList != null) {
                for (DeviceInterfaceIndex index : interfaceIndexList) {
                    for (DeviceInterfaceIndex index2 : interfaceIndexList) {
                        if (index == index2 || !RangeUtils.intersects(index.getTimeFrom(), index.getTimeTo(), index2.getTimeFrom(), index2.getTimeTo())) continue;
                        throw new BGException("\u041f\u0435\u0440\u0438\u043e\u0434\u044b \u0438\u043d\u0434\u0435\u043a\u0441\u043e\u0432 \u043d\u0435 \u0434\u043e\u043b\u0436\u043d\u044b \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0442\u044c\u0441\u044f!");
                    }
                }
                for (DeviceInterfaceIndex index : interfaceIndexList) {
                    this.update(deviceId, interfaceId, index, insertPS, updatePS);
                    ids.add(index.getId());
                }
            }
            ids.add(-1);
            PreparedStatement deletePS = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE deviceId=? AND interfaceId=? AND id NOT IN (" + Utils.toString(ids) + ")");
            deletePS.setInt(1, deviceId);
            deletePS.setInt(2, interfaceId);
            deletePS.executeUpdate();
            insertPS.close();
            updatePS.close();
            deletePS.close();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private void update(int deviceId, int interfaceId, DeviceInterfaceIndex index, PreparedStatement insertPS, PreparedStatement updatePS) throws SQLException {
        if (index.getId() > 0) {
            updatePS.setTimestamp(1, TimeUtils.convertDateToTimestamp(index.getTimeFrom()));
            updatePS.setTimestamp(2, TimeUtils.convertDateToTimestamp(index.getTimeTo()));
            updatePS.setInt(3, index.getIndex());
            updatePS.setInt(4, index.getId());
            if (updatePS.executeUpdate() == 0) {
                index.setId(-1);
            }
        }
        if (index.getId() <= 0) {
            insertPS.setInt(1, deviceId);
            insertPS.setInt(2, interfaceId);
            insertPS.setTimestamp(3, TimeUtils.convertDateToTimestamp(index.getTimeFrom()));
            insertPS.setTimestamp(4, TimeUtils.convertDateToTimestamp(index.getTimeTo()));
            insertPS.setInt(5, index.getIndex());
            insertPS.executeUpdate();
            index.setId(ServerUtils.lastInsertId(insertPS));
        }
    }

    public List<DeviceInterfaceIndex> list(int deviceId, Integer interfaceId, Date time) throws BGException {
        try {
            ArrayList<DeviceInterfaceIndex> result = new ArrayList<DeviceInterfaceIndex>();
            String query = "SELECT * FROM " + this.tableName + " WHERE deviceId=? AND (? OR interfaceId=?)";
            if (time != null) {
                query = query + " AND (timeFrom IS NULL OR timeFrom<=?) AND (timeTo IS NULL OR ?<=timeTo)";
            }
            query = query + " ORDER BY id";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, deviceId);
            ps.setBoolean(2, interfaceId == null);
            ps.setInt(3, interfaceId != null ? interfaceId : 0);
            if (time != null) {
                Timestamp timestamp = TimeUtils.convertDateToTimestamp(time);
                ps.setTimestamp(4, timestamp);
                ps.setTimestamp(5, timestamp);
            }
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                result.add(this.getFromRS(rs));
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    public static Map<Integer, List<DeviceInterfaceIndexItem>> getIfaceIndexMap(DeviceInterfaceIndexDao interfaceIndexDao, Map<Integer, Map<Integer, List<DeviceInterfaceIndexItem>>> deviceInterfaceIndexMap, int deviceId) throws BGException {
        Map<Integer, List<DeviceInterfaceIndexItem>> result = deviceInterfaceIndexMap.get(deviceId);
        if (result != null) {
            return result;
        }
        result = new HashMap<Integer, List<DeviceInterfaceIndexItem>>();
        List<DeviceInterfaceIndex> interfaceList = interfaceIndexDao.list(deviceId, null, null);
        for (DeviceInterfaceIndex iface : interfaceList) {
            List<DeviceInterfaceIndexItem> list = result.get(iface.getPort());
            if (list == null) {
                list = new ArrayList<DeviceInterfaceIndexItem>(4);
                result.put(iface.getPort(), list);
            }
            DeviceInterfaceIndexItem index = new DeviceInterfaceIndexItem(iface.getIndex(), iface.getTimeFrom() != null ? iface.getTimeFrom().getTime() : 0L, iface.getTimeTo() != null ? iface.getTimeTo().getTime() : 0L);
            list.add(index);
        }
        return result;
    }

    public static class DeviceInterfaceIndexItem {
        public final int index;
        public final long millisFrom;
        public final long millisTo;

        public DeviceInterfaceIndexItem(int index, long millisFrom, long millisTo) {
            this.index = index;
            this.millisFrom = millisFrom;
            this.millisTo = millisTo;
        }
    }
}

