/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.jws.WebService;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalAccessException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.common.util.RangedIntegerSet;
import ru.bitel.oss.systems.inventory.resource.common.ResourceService;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceNet;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceRange;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceSubscriptionReal;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.VlanResourceSubscription;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscriptionEvent;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionRealDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.VlanResourceSubscriptionDao;

@WebService(endpointInterface="ru.bitel.oss.systems.inventory.resource.common.ResourceService")
public class ResourceServiceImpl
extends AbstractService
implements ResourceService {
    private static final Logger logger = Logger.getLogger(ResourceServiceImpl.class);
    private VlanResourceDao vlanResourceDao = null;
    private VlanResourceSubscriptionDao vlanResourceSubscriptionDao = null;
    private IpCategoryDao ipCategoryDao = null;
    private IpResourceDao ipResourceDao = null;
    private IpResourceSubscriptionDao ipResourceSubscriptionDao;
    private IpResourceSubscriptionRealDao ipResourceSubscriptionRealDao;
    private VlanCategoryDao vlanCategoryDao = null;

    @PostConstruct
    void init() {
        this.vlanResourceDao = new VlanResourceDao(this.getConnection(), this.moduleId);
        this.vlanResourceSubscriptionDao = new VlanResourceSubscriptionDao(this.getConnection(), this.moduleId);
        this.ipResourceDao = new IpResourceDao(this.getConnection(), this.moduleId);
        this.ipResourceSubscriptionDao = new IpResourceSubscriptionDao(this.getConnection(), this.moduleId);
        this.ipResourceSubscriptionRealDao = new IpResourceSubscriptionRealDao(this.getConnection(), this.moduleId);
        this.ipCategoryDao = new IpCategoryDao(this.getConnection(), this.moduleId);
        this.vlanCategoryDao = new VlanCategoryDao(this.getConnection(), this.moduleId);
    }

    @Override
    public List<VlanResource> vlanResourceList(int categoryId) throws BGException {
        if (categoryId > 0) {
            return this.vlanResourceDao.list(categoryId);
        }
        return this.vlanResourceDao.list();
    }

    @Override
    public VlanResource vlanResourceGet(int id) throws BGException {
        return (VlanResource)this.vlanResourceDao.get(id);
    }

    @Override
    public void vlanResourceDelete(int id) throws BGException {
        List<VlanResourceSubscription> list = this.vlanResourceSubscriptionDao.list(id, null, null);
        if (list.size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
        }
        this.vlanResourceDao.delete(id);
    }

    @Override
    public int vlanResourceUpdate(VlanResource resource) throws BGException {
        List<VlanResourceSubscription> subList;
        VlanResource oldRes;
        List<VlanResource> list = this.vlanResourceDao.list(resource.getCategoryId());
        for (VlanResource r : list) {
            if (r.getId() == resource.getId() || r.getVlanFrom() > resource.getVlanTo() || r.getVlanTo() < resource.getVlanFrom() || r.getDateFrom() != null && resource.getDateTo() != null && r.getDateFrom().compareTo(resource.getDateTo()) > 0 || r.getDateTo() != null && resource.getDateFrom() != null && r.getDateTo().compareTo(resource.getDateFrom()) < 0) continue;
            throw new BGMessageException("\u042d\u0442\u043e\u0442 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u0438\u043c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c \u0432 \u0434\u0430\u043d\u043d\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438!");
        }
        if (resource.getId() > 0 && ((oldRes = (VlanResource)this.vlanResourceDao.get(resource.getId())).getDateFrom() == null ^ resource.getDateFrom() == null || oldRes.getDateFrom() != null && oldRes.getDateFrom().compareTo(resource.getDateFrom()) != 0 || oldRes.getDateTo() == null ^ resource.getDateTo() == null || oldRes.getDateTo() != null && oldRes.getDateTo().compareTo(resource.getDateTo()) != 0 || oldRes.getVlanFrom() != resource.getVlanFrom() || oldRes.getVlanTo() != resource.getVlanTo()) && (subList = this.vlanResourceSubscriptionDao.list(resource.getId(), null, null)).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0418\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438 ");
        }
        this.vlanResourceDao.update(resource);
        return resource.getId();
    }

    @Override
    public Integer freeVlan(Set<Integer> vlanResourceCategoryIds, Date dateFrom, Date dateTo) throws BGException, BGMessageException {
        Integer vlan = null;
        boolean reverse = this.getModuleSetup().getInt("vlan.resource.reverse", 0) > 0;
        for (VlanResource resource : this.vlanResourceDao.list(vlanResourceCategoryIds, dateFrom, dateTo)) {
            Set<Integer> subscribed = this.vlanResourceSubscriptionDao.subscribedVlans(resource.getId(), dateFrom, dateTo);
            RangedIntegerSet intSet = new RangedIntegerSet(new int[]{resource.getVlanFrom(), resource.getVlanTo()});
            vlan = reverse ? intSet.nextReverse(intSet.size() - 1, subscribed) : intSet.next(0, subscribed);
            if (vlan == null) continue;
            break;
        }
        if (vlan == null) {
            throw new BGMessageException("\u041d\u0435\u0442 \u0441\u0432\u043e\u0431\u043e\u0434\u043d\u044b\u0445 VLAN \u0432 \u0440\u0435\u0441\u0443\u0440\u0441\u0435 \u043d\u0430 \u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434.");
        }
        return vlan;
    }

    @Override
    @Deprecated
    public Integer nextFreeVlan(int vlanResourceCategoryId, int deviceId, Date dateFrom, Date dateTo) throws BGException {
        return this.freeVlan(Collections.singleton(vlanResourceCategoryId), dateFrom, dateTo);
    }

    private List<Integer> freeVlanList(int vlanResourceId, Date dateFrom, Date dateTo) throws BGException {
        VlanResource resource = (VlanResource)this.vlanResourceDao.get(vlanResourceId);
        if (resource == null) {
            throw new BGIllegalArgumentException();
        }
        Set<Integer> subscribed = this.vlanResourceSubscriptionDao.subscribedVlans(vlanResourceId, dateFrom, dateTo);
        RangedIntegerSet intSet = new RangedIntegerSet(new int[]{resource.getVlanFrom(), resource.getVlanTo()});
        ArrayList<Integer> result = new ArrayList<Integer>(intSet);
        result.removeAll(subscribed);
        return result;
    }

    @Override
    @Deprecated
    public boolean vlanResourceSubscribe(int vlan, int subscriberId, String subscriberTitle, Date dateFrom, Date dateTo, Set<Integer> vlanResourceCategoryIds, boolean isVlanPersonal) throws BGException {
        return this.vlanResourceSubscribe(vlan, (short)1, subscriberId, subscriberTitle, dateFrom, dateTo, vlanResourceCategoryIds, isVlanPersonal);
    }

    @Override
    public boolean vlanResourceSubscribe(int vlan, short subscriberType, int subscriberId, String subscriberTitle, Date dateFrom, Date dateTo, Set<Integer> vlanResourceCategoryIds, boolean isVlanPersonal) throws BGException {
        VlanResourceSubscription subcripton = new VlanResourceSubscription();
        this.vlanResourceUnsubscribe(subscriberType, subscriberId);
        List<VlanResource> sources = this.vlanResourceDao.list(vlanResourceCategoryIds, dateFrom, dateTo);
        int resourceId = -1;
        for (VlanResource resource : sources) {
            if (resource.getVlanFrom() > vlan || vlan > resource.getVlanTo()) continue;
            if (isVlanPersonal) {
                List<VlanResourceSubscription> list = this.vlanResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
                for (VlanResourceSubscription sub : list) {
                    if (sub.getVlan() != vlan) continue;
                    throw new BGMessageException("\u042d\u0442\u043e\u0442 VLAN \u0443\u0436\u0435 \u0437\u0430\u043d\u044f\u0442.");
                }
            }
            if (resourceId != -1) continue;
            resourceId = resource.getId();
        }
        if (resourceId == -1) {
            throw new BGException("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 VLAN.");
        }
        subcripton.setSubscriberType(subscriberType);
        subcripton.setSubscriberId(subscriberId);
        subcripton.setSubscriberTitle(subscriberTitle);
        subcripton.setVlan(vlan);
        subcripton.setVlanResourseId(resourceId);
        subcripton.setDateFrom(dateFrom);
        subcripton.setDateTo(dateTo);
        this.vlanResourceSubscriptionDao.update(subcripton);
        return true;
    }

    @Override
    @Deprecated
    public void vlanResourceUnsubscribe(int subscriberId) throws BGException {
        this.vlanResourceUnsubscribe((short)1, subscriberId);
    }

    @Override
    public void vlanResourceUnsubscribe(short subscriberType, int subscriberId) throws BGException {
        this.vlanResourceSubscriptionDao.deleteBySubscriberId(subscriberType, subscriberId);
    }

    @Override
    public List<VlanResourceSubscription> vlanSubscriptionList1(int vlanResourceId, Date dateFrom, Date dateTo) throws BGException {
        return this.vlanResourceSubscriptionDao.list(vlanResourceId, dateFrom, dateTo);
    }

    @Override
    public Result<VlanResourceSubscription> vlanSubscriptionList(int vlanResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.vlanResourceSubscriptionDao.list(vlanResourceId, dateFrom, dateTo, page);
    }

    @Override
    public IpCategory ipCategoryRoot() throws BGException {
        return this.ipCategoryDao.root();
    }

    @Override
    public List<IpCategory> ipCategoryList() throws BGException {
        return this.ipCategoryDao.list();
    }

    @Override
    public int ipCategoryUpdate(IpCategory category) throws BGException {
        this.ipCategoryDao.update(category);
        return category.getId();
    }

    @Override
    public void ipCategoryDelete(int id) throws BGException {
        if (this.ipResourceDao.list(id).size() > 0) {
            throw new BGException("\u0412 \u0443\u0434\u0430\u043b\u044f\u0435\u043c\u043e\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 \u0435\u0441\u0442\u044c \u0440\u0435\u0441\u0443\u0440\u0441\u044b, \u0443\u0434\u0430\u043b\u0438\u0442\u0435 \u0432\u043d\u0430\u0447\u0430\u043b\u0435 \u0438\u0445");
        }
        this.ipCategoryDao.delete(id);
    }

    @Override
    public List<IpResource> ipResourceList(Collection<Integer> categoryIds) throws BGException {
        if (categoryIds != null && categoryIds.size() > 0) {
            ArrayList<IpResource> result = new ArrayList<IpResource>();
            for (Integer categoryId : categoryIds) {
                result.addAll(this.ipResourceDao.list(categoryId));
            }
            return result;
        }
        return this.ipResourceDao.list();
    }

    @Override
    public void ipResourceDelete(int id, boolean skipSubscriptionCheck) throws BGException {
        List<IpResourceSubscription> subList;
        if (!skipSubscriptionCheck && (subList = this.ipResourceSubscriptionDao.list(id, null, null, new Page(1, 1)).getList()).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u0441\u043f\u0438\u0441\u0447\u0438\u043a\u0438!");
        }
        IpResource oldIpResource = (IpResource)this.ipResourceDao.getAndDelete(id);
        this.context.publishAfterCommit(new IpResourceModifiedEvent(this.moduleId, this.userId, oldIpResource.getCategoryId(), oldIpResource.getId()));
    }

    @Override
    public int ipResourceUpdate(IpResource resource, boolean skipSubscriptionCheck) throws BGException {
        List<IpResourceSubscription> subList;
        IpResource oldRes;
        HashSet<Integer> categoryIds = new HashSet<Integer>();
        categoryIds.add(resource.getCategoryId());
        if (IpAddress.compare(resource.getAddressFrom(), resource.getAddressTo()) > 0) {
            throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d IP-\u0430\u0434\u0440\u0435\u0441\u043e\u0432");
        }
        if (TimeUtils.dateBefore(resource.getDateTo(), resource.getDateFrom())) {
            throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d \u0434\u0430\u0442");
        }
        List<IpResource> list = this.ipResourceDao.list(categoryIds, null, resource.getDateFrom(), resource.getDateTo(), null);
        for (IpResource res : list) {
            if (res.getId() == resource.getId() || IpAddress.compare(res.getAddressFrom(), resource.getAddressTo()) > 0 || IpAddress.compare(res.getAddressTo(), resource.getAddressFrom()) < 0) continue;
            throw new BGMessageException("\u0421\u043e\u0445\u0440\u0430\u043d\u044f\u0435\u043c\u044b\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043f\u0435\u0440\u0435\u0441\u0435\u043a\u0430\u0435\u0442\u0441\u044f \u0441 \u0434\u0440\u0443\u0433\u0438\u043c\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438 \u0432 \u0442\u0435\u043a\u0443\u0449\u0438\u0439 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438.");
        }
        if (resource.getId() > 0 && !skipSubscriptionCheck && ((oldRes = (IpResource)this.ipResourceDao.get(resource.getId())).getDateFrom() == null ^ resource.getDateFrom() == null || oldRes.getDateFrom() != null && oldRes.getDateFrom().compareTo(resource.getDateFrom()) != 0 || oldRes.getDateTo() == null ^ resource.getDateTo() == null || oldRes.getDateTo() != null && oldRes.getDateTo().compareTo(resource.getDateTo()) != 0 || IpAddress.compare(oldRes.getAddressFrom(), resource.getAddressFrom()) != 0 || IpAddress.compare(oldRes.getAddressTo(), resource.getAddressTo()) != 0) && (subList = this.ipResourceSubscriptionDao.list(resource.getId(), null, null)).size() > 0) {
            throw new BGMessageException("\u041d\u0435\u043b\u044c\u0437\u044f \u0438\u0437\u043c\u0435\u043d\u0438\u0442\u044c \u044d\u0442\u043e\u0442 \u0440\u0435\u0441\u0443\u0440\u0441, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0430 \u043d\u0435\u0433\u043e \u0435\u0441\u0442\u044c \u043f\u043e\u0434\u043f\u0438\u0441\u0447\u0438\u043a\u0438.");
        }
        if (Utils.notBlankString(resource.getDns())) {
            String[] addresses;
            for (String address : addresses = resource.getDns().trim().split("\\s*,\\s*")) {
                try {
                    InetAddress.getByName(address);
                }
                catch (UnknownHostException e) {
                    throw new BGMessageException("\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 IP-\u0430\u0434\u0440\u0435\u0441\u0430 DNS: " + address);
                }
            }
        }
        if (Utils.isBlankString(resource.getDns())) {
            resource.setDns("");
        }
        this.ipResourceDao.update(resource);
        this.context.publishAfterCommit(new IpResourceModifiedEvent(this.moduleId, this.userId, resource.getCategoryId(), resource.getId()));
        return resource.getId();
    }

    @Override
    public List<IpResourceNet> freeIpResourceNetList(Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int mask, int max) throws BGException {
        ArrayList<IpResourceNet> result = new ArrayList<IpResourceNet>();
        List<IpResource> resourceList = this.ipResourceDao.list(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, false);
        int size = resourceList.size();
        for (int i = 0; i < size; ++i) {
            IpResource resource = resourceList.get(i);
            List<IpResourceSubscription> subscriptionList = this.ipResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
            IpResourceNet.newIpResourceNetList(resource, subscriptionList, mask, max - result.size(), result);
            if (result.size() >= max) break;
        }
        return result;
    }

    @Override
    public List<IpResourceRange> freeIpResourceRangeList(Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int range, int max) throws BGException {
        ArrayList<IpResourceRange> result = new ArrayList<IpResourceRange>();
        List<IpResource> resourceList = this.ipResourceDao.list(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, false);
        int size = resourceList.size();
        for (int i = 0; i < size; ++i) {
            IpResource resource = resourceList.get(i);
            List<IpResourceSubscription> subscriptionList = this.ipResourceSubscriptionDao.list(resource.getId(), dateFrom, dateTo);
            IpResourceRange.newIpRangeList(resource, subscriptionList, range, max - result.size(), result);
            if (result.size() >= max) break;
        }
        return result;
    }

    private void ipResourceUnsubscribeReal(int subscriberId, byte[] addressFrom, byte[] addressTo) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
        Date today = calendar.getTime();
        ((Calendar)calendar).add(5, -1);
        Date yesterday = calendar.getTime();
        IpResourceSubscriptionReal oldSubscription = this.ipResourceSubscriptionRealDao.findFromDate(subscriberId, addressFrom, addressTo, today);
        if (oldSubscription == null) {
            logger.warn((Object)"Subcribe was not found for unsuscribing");
            return;
        }
        if (oldSubscription.getDateFrom() != null && TimeUtils.dateBefore(today, oldSubscription.getDateFrom())) {
            this.ipResourceSubscriptionRealDao.delete(oldSubscription.getId());
            return;
        }
        if (oldSubscription.getDateTo() == null || TimeUtils.dateBeforeOrEq(today, oldSubscription.getDateTo())) {
            oldSubscription.setDateTo(yesterday);
        }
        if (TimeUtils.dateBefore(oldSubscription.getDateTo(), oldSubscription.getDateFrom())) {
            this.ipResourceSubscriptionRealDao.delete(oldSubscription.getId());
        } else {
            this.ipResourceSubscriptionRealDao.update(oldSubscription);
        }
    }

    @Override
    public void ipResourceUnsubscribe(int subscriberId, int ipResourceSubscriptionId, byte[] addressFrom, byte[] addressTo) throws BGException {
        IpResourceSubscription oldSubscription = ipResourceSubscriptionId > 0 ? (IpResourceSubscription)this.ipResourceSubscriptionDao.get(ipResourceSubscriptionId) : this.ipResourceSubscriptionDao.findSubscribed(subscriberId);
        if (oldSubscription == null) {
            logger.warn((Object)"Subcribe was not found for unsuscribing");
            return;
        }
        this.ipResourceSubscriptionDao.deleteBySubsciberId(subscriberId);
        this.ipResourceUnsubscribeReal(subscriberId, addressFrom, addressTo);
        this.context.publishAfterCommit(new IpResourceSubscriptionEvent(2, this.moduleId, -1, subscriberId, null, oldSubscription.getIpResourseId(), oldSubscription.getId(), oldSubscription.getAddressFrom(), oldSubscription.getAddressTo(), null, oldSubscription.getDateTo(), false));
    }

    private IpResourceSubscriptionReal ipResourceSubscribeReal(int subscriberId, String subscriberTitle, byte[] addressFrom, byte[] addressTo, Date dateFrom, Date dateTo) throws BGException {
        GregorianCalendar calendar = new GregorianCalendar();
        TimeUtils.clear_HOUR_MIN_MIL_SEC(calendar);
        Date today = calendar.getTime();
        IpResourceSubscriptionReal subscription = new IpResourceSubscriptionReal();
        subscription.setSubscriberId(subscriberId);
        subscription.setSubscriberTitle(subscriberTitle);
        subscription.setDateTo(dateTo);
        subscription.setAddressFrom(addressFrom);
        subscription.setAddressTo(addressTo != null ? addressTo : addressFrom);
        if (TimeUtils.dateBefore(subscription.getDateTo(), today)) {
            return null;
        }
        if (TimeUtils.dateBefore(today, dateFrom)) {
            subscription.setDateFrom(dateFrom);
        } else {
            subscription.setDateFrom(today);
        }
        this.ipResourceSubscriptionRealDao.update(subscription);
        return subscription;
    }

    @Override
    public IpResourceSubscription ipResourceSubscribe(int subscriberId, String subscriberTitle, Collection<Integer> ipResourceCategoryIds, int ipResourceId, byte[] addressFrom, byte[] addressTo, Date dateFrom, Date dateTo) throws BGException {
        Object[] resourceRef;
        if (addressTo == null) {
            addressTo = addressFrom;
        }
        GregorianCalendar utilCalendar = new GregorianCalendar();
        if (dateFrom != null) {
            utilCalendar.setTime(dateFrom);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(utilCalendar);
            dateFrom = utilCalendar.getTime();
        }
        if (dateTo != null) {
            utilCalendar.setTime(dateTo);
            TimeUtils.clear_HOUR_MIN_MIL_SEC(utilCalendar);
            ((Calendar)utilCalendar).add(5, 1);
            ((Calendar)utilCalendar).add(14, -1);
            dateTo = utilCalendar.getTime();
        }
        IpResourceSubscription subscription = new IpResourceSubscription();
        subscription.setSubscriberId(subscriberId);
        subscription.setSubscriberTitle(subscriberTitle);
        subscription.setDateFrom(dateFrom);
        subscription.setDateTo(dateTo);
        subscription.setAddressFrom(addressFrom);
        subscription.setAddressTo(addressTo);
        try {
            resourceRef = this.ipResourceSubscriptionDao.findFree(ipResourceCategoryIds, ipResourceId, subscription.getAddressFrom(), subscription.getAddressTo(), subscription.getDateFrom(), subscription.getDateTo(), subscription.getSubscriberId());
        }
        catch (Exception e) {
            throw new BGMessageException(e.getMessage());
        }
        if (resourceRef == null) {
            throw new BGMessageException("\u041f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 ip \u0440\u0435\u0441\u0443\u0440\u0441 \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d");
        }
        IpResource resource = (IpResource)resourceRef[0];
        subscription.setIpResourseId(resource.getId());
        this.ipResourceSubscriptionDao.update(subscription);
        this.ipResourceSubscribeReal(subscriberId, subscriberTitle, addressFrom, addressTo, dateFrom, dateTo);
        this.context.publishAfterCommit(new IpResourceSubscriptionEvent(1, this.moduleId, -1, subscriberId, subscription.getSubscriberTitle(), subscription.getIpResourseId(), subscription.getId(), subscription.getAddressFrom(), subscription.getAddressTo(), subscription.getDateFrom(), subscription.getDateTo(), false));
        return subscription;
    }

    protected boolean dateEqual(Date date1, Date date2) {
        return date1 == null && date2 == null || date1 != null && date2 != null && TimeUtils.dateEqual(date1, date2);
    }

    @Override
    public VlanCategory vlanCategoryRoot() throws BGException {
        return this.vlanCategoryDao.root();
    }

    @Override
    public int vlanCategoryUpdate(VlanCategory category) throws BGException {
        this.vlanCategoryDao.update(category);
        return category.getId();
    }

    @Override
    public void vlanCategoryDelete(int id) throws BGException {
        if (this.vlanResourceDao.list(id).size() > 0) {
            throw new BGMessageException(" \u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u044d\u0442\u0443 \u043a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u044e, \u0442\u0430\u043a \u043a\u0430\u043a \u0432 \u043d\u0435\u0439 \u0435\u0441\u0442\u044c \u0434\u0438\u0430\u043f\u0430\u0437\u043e\u043d\u044b");
        }
        this.vlanCategoryDao.delete(id);
    }

    @Override
    public Result<IpResourceSubscription> ipSubscriptionList(int ipResourceId, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.ipResourceSubscriptionDao.list(ipResourceId, dateFrom, dateTo, page);
    }

    protected List<VlanResource> getVlanResources(Set<Integer> vlanResourceCategoryIds) throws BGException {
        return this.vlanResourceDao.list(vlanResourceCategoryIds);
    }

    @Override
    @Deprecated
    public Integer freeVlan(Set<Integer> vlanResourceCategoryIds, int deviceId, Date dateFrom, Date dateTo) throws BGException {
        return this.freeVlan(vlanResourceCategoryIds, dateFrom, dateTo);
    }

    @Override
    @Deprecated
    public boolean vlanResourceSubscribe(int vlan, int subscriberId, String subscriberTitle, int deviceId, Date dateFrom, Date dateTo, Set<Integer> vlanResourceCategoryIds, boolean isVlanPersonal) throws BGException {
        return this.vlanResourceSubscribe(vlan, subscriberId, subscriberTitle, dateFrom, dateTo, vlanResourceCategoryIds, isVlanPersonal);
    }

    @Override
    @Deprecated
    public List<IpResourceRange> freeIpResourceRangeList(int deviceId, int interfaceId, Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int range, int max) throws BGException {
        return this.freeIpResourceRangeList(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, range, max);
    }

    @Override
    @Deprecated
    public List<IpResourceNet> freeIpResourceNetList(int deviceId, int interfaceId, Collection<Integer> ipResourceCategoryIds, Collection<Integer> ipResourceIds, Date dateFrom, Date dateTo, int mask, int max) throws BGException {
        return this.freeIpResourceNetList(ipResourceCategoryIds, ipResourceIds, dateFrom, dateTo, mask, max);
    }

    @Override
    public IpResource ipResourceGet(int id) throws BGException, BGMessageException, BGIllegalAccessException {
        return (IpResource)this.ipResourceDao.get(id);
    }
}

