/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.oss.kernel.entity.common.bean.EntitySpecAttrListItem;

public class EntitySpecAttrListItemDao
extends AbstractIdDao<EntitySpecAttrListItem>
implements Directory<EntitySpecAttrListItem> {
    private final int entitySpecAttrId;

    public EntitySpecAttrListItemDao(Connection con, int entitySpecAttrId) {
        super(con, 0, "entity_spec_attr_list");
        this.entitySpecAttrId = entitySpecAttrId;
    }

    @Override
    protected EntitySpecAttrListItem getFromRS(ResultSet rs) throws SQLException, BGException {
        return new EntitySpecAttrListItem(rs.getInt("id"), rs.getString("title"));
    }

    @Override
    protected void updateImpl(EntitySpecAttrListItem b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (title, entitySpecAttrId) VALUES (?,?)", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET title=? WHERE entitySpecAttrId=? AND id=?");
            ps.setInt(3, b2.getId());
        }
        ps.setString(1, b2.getTitle());
        ps.setInt(2, this.entitySpecAttrId);
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public EntitySpecAttrListItem get(String title) throws BGException {
        return (EntitySpecAttrListItem)this.get("title=?", title);
    }

    @Override
    public List<EntitySpecAttrListItem> list() throws BGException {
        return this.list("entitySpecAttrId=?", null, this.entitySpecAttrId);
    }
}

