/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrBoolean;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrBooleanDao
extends EntityAttrDefaultDao<EntityAttrBoolean> {
    public EntityAttrBooleanDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    public EntityAttrBoolean get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrBoolean result = rs.next() ? new EntityAttrBoolean(entityId, attrSpecId, rs.getBoolean(1)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setBoolean(3, ((EntityAttrBoolean)a2).getValue());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrBoolean attr) throws SQLException {
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setBoolean(1, attr.getValue());
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setBoolean(3, attr.getValue());
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        boolean oldValue = rs.next() ? rs.getBoolean(1) : false;
        rs.close();
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrBoolean attr) throws SQLException {
        PreparedStatement ps = this.getInsertHistiryPS();
        ps.setInt(1, cid);
        ps.setInt(2, attr.getEntitySpecAttrId());
        ps.setBoolean(3, attr != null ? Boolean.valueOf(attr.getValue()) : null);
        ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        ps.setInt(5, this.entityAttrDao.userId);
        ps.executeUpdate();
    }
}

