/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.directories.address.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Page;
import ru.bitel.oss.kernel.directories.address.common.bean.House;

public class HouseDao
extends AbstractIdDao<House> {
    public HouseDao(Connection con) {
        super(con, 0, "address_house");
    }

    @Override
    protected House getFromRS(ResultSet rs) throws SQLException, BGException {
        House result = new House();
        result.setId(rs.getInt("id"));
        result.setAreaId(rs.getInt("areaid"));
        result.setQuarterId(rs.getInt("quarterid"));
        result.setStreetId(rs.getInt("streetid"));
        result.setHouse(rs.getInt("house"));
        result.setFrac(rs.getString("frac"));
        result.setPostIndex(rs.getString("box_index"));
        result.setAmount(rs.getInt("amount"));
        result.setComment(rs.getString("comment"));
        return result;
    }

    @Override
    protected void updateImpl(House b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getStreetId() < 0 || b2.getHouse() <= 0 || b2.getAmount() == -1) {
            throw new BGIllegalArgumentException();
        }
        int houseId = this.get(b2.getStreetId(), b2.getHouse(), b2.getFrac());
        if (houseId > 0 && b2.getId() != houseId) {
            throw new BGMessageException("\u0414\u043e\u043c \u0443\u0436\u0435 \u0438\u043c\u0435\u0435\u0442\u0441\u044f");
        }
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO address_house SET areaid=?, quarterid=?, streetid=?, house=?, frac=?, box_index=?, amount=?, comment=?", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE address_house SET areaid=?, quarterid=?, streetid=?, house=?, frac=?, box_index=?, amount=?, comment=? WHERE id=?");
            ps.setInt(11, b2.getId());
        }
        ps.setInt(1, b2.getAreaId());
        ps.setInt(2, b2.getQuarterId());
        ps.setInt(3, b2.getStreetId());
        ps.setInt(4, b2.getHouse());
        ps.setString(5, b2.getFrac());
        ps.setString(6, b2.getPostIndex());
        ps.setInt(7, b2.getAmount());
        ps.setString(8, b2.getComment());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    public House get(int id) throws BGException {
        try {
            House result;
            StringBuilder sb = new StringBuilder(500).append("SELECT SQL_CALC_FOUND_ROWS house.*, city.id, city.title, area.title, street.title, quarter.title FROM ").append(this.tableName).append(" as house");
            sb.append(" LEFT JOIN address_street as street ON street.id=house.streetid");
            sb.append(" LEFT JOIN address_city AS city ON city.id=street.cityid");
            sb.append(" LEFT JOIN address_area as area ON area.id=house.areaid");
            sb.append(" LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid");
            sb.append(" WHERE house.id=?");
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                result = this.getFromRS(rs);
                result.setCityId(rs.getInt("city.id"));
                result.setCityTitle(rs.getString("city.title"));
                result.setAreaTitle(rs.getString("area.title"));
                result.setStreetTitle(rs.getString("street.title"));
                result.setQuarterTitle(rs.getString("quarter.title"));
            } else {
                result = null;
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }

    private int get(int streetid, int house, String frac) throws SQLException {
        ResultSet rs;
        int index = 1;
        int houseId = 0;
        StringBuffer query = new StringBuffer();
        query.append("SELECT id FROM address_house WHERE streetid=? AND house=?");
        if (frac.startsWith("/")) {
            query.append(" AND ( frac=? OR frac=? )");
        } else {
            query.append(" AND frac=? ");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        ps.setInt(index++, streetid);
        ps.setInt(index++, house);
        ps.setString(index++, frac);
        if (frac.startsWith("/")) {
            ps.setString(index++, frac.substring(1));
        }
        if ((rs = ps.executeQuery()).next()) {
            houseId = rs.getInt(1);
        }
        rs.close();
        ps.close();
        return houseId;
    }

    public List<House> list(int cityId, int areaId, int streetId, int quarterId, int house, String frac, Page page) throws BGException {
        try {
            ArrayList<House> result = new ArrayList<House>();
            StringBuilder sb = new StringBuilder(500).append("SELECT SQL_CALC_FOUND_ROWS house.*, city.id, city.title, area.title, street.title, quarter.title FROM ").append(this.tableName).append(" as house");
            sb.append(" LEFT JOIN address_street as street ON street.id=house.streetid");
            sb.append(" LEFT JOIN address_city AS city ON city.id=street.cityid");
            sb.append(" LEFT JOIN address_area as area ON area.id=house.areaid");
            sb.append(" LEFT JOIN address_quarter as quarter ON quarter.id=house.quarterid");
            sb.append(" WHERE (? OR house.streetid=?) AND (? OR street.cityid=?) AND (? OR house.areaid=?)  AND (? OR house.quarterid=?)");
            sb.append(" AND (? OR house.house=?) AND (? OR house.frac=? OR house.frac=?)");
            sb.append(" ORDER BY city.title, area.title, quarter.title, street.title, house.house, house.frac");
            if (page != null) {
                sb.append(" LIMIT ?,?");
            }
            PreparedStatement ps = this.con.prepareStatement(sb.toString());
            ps.setBoolean(1, streetId <= 0);
            ps.setInt(2, streetId);
            ps.setBoolean(3, cityId <= 0);
            ps.setInt(4, cityId);
            ps.setBoolean(5, areaId <= 0);
            ps.setInt(6, areaId);
            ps.setBoolean(7, quarterId <= 0);
            ps.setInt(8, quarterId);
            ps.setBoolean(9, house <= 0);
            ps.setInt(10, house);
            ps.setBoolean(11, Utils.isBlankString(frac));
            ps.setString(12, frac);
            if (frac.matches("^/[0-9]+$")) {
                ps.setString(13, frac.substring(1));
            } else {
                ps.setString(13, frac);
            }
            if (page != null) {
                ps.setInt(14, page.getPageFirstRecordNumber());
                ps.setInt(15, page.getPageSize());
            }
            ResultSet rs = ps.executeQuery();
            if (page != null) {
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            while (rs.next()) {
                House b2 = this.getFromRS(rs);
                b2.setCityId(rs.getInt("city.id"));
                b2.setCityTitle(rs.getString("city.title"));
                b2.setAreaTitle(rs.getString("area.title"));
                b2.setStreetTitle(rs.getString("street.title"));
                b2.setQuarterTitle(rs.getString("quarter.title"));
                result.add(b2);
            }
            rs.close();
            ps.close();
            return result;
        }
        catch (SQLException ex) {
            throw new BGException(ex);
        }
    }
}

