/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.worker;

import java.util.AbstractQueue;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.common.worker.Commitable;
import ru.bitel.common.worker.Recyclable;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThread;
import ru.bitel.common.worker.WorkerThreadFactory;

public abstract class WorkerTask<C extends ThreadContext>
implements Runnable {
    private static final Logger logger = Logger.getLogger(WorkerTask.class);
    protected C context;

    public void setContext(C context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        if (this.context != null) {
            Object parentContext = ThreadContext.get();
            ThreadContext.set(this.context);
            try {
                this.runImpl();
                if (!(this.context instanceof Commitable)) return;
                ((Commitable)this.context).commit();
                return;
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
                return;
            }
            finally {
                ThreadContext.set(parentContext);
                if (this.context instanceof Recyclable) {
                    ((Recyclable)this.context).recycle();
                }
            }
        }
        Thread thread = Thread.currentThread();
        if (thread instanceof WorkerThread) {
            this.context = ((WorkerThread)thread).context;
            Object parentContext = ThreadContext.get();
            ThreadContext.set(this.context);
            try {
                this.runImpl();
                if (this.context instanceof Commitable) {
                    ((Commitable)this.context).commit();
                }
            }
            catch (Throwable t) {
                logger.error((Object)t.getMessage(), t);
            }
            finally {
                ThreadContext.set(parentContext);
                if (this.context instanceof Recyclable) {
                    ((Recyclable)this.context).recycle();
                }
            }
            this.context = null;
            return;
        }
        try {
            this.runImpl();
            return;
        }
        catch (Throwable t) {
            logger.error((Object)t.getMessage(), t);
        }
    }

    protected abstract void runImpl() throws Exception;

    public static <C extends ThreadContext> ExecutorService newFixedThreadPool(String name, String nestedContext, ThreadContextFactory<C> contextFactory, int nThreads) {
        WorkerThreadFactory<C> threadFactory = new WorkerThreadFactory<C>(name, nestedContext, contextFactory);
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
    }

    public static <C extends ThreadContext> ExecutorService newFixedThreadPool(String name, String nestedContext, ThreadContextFactory<C> contextFactory, int nThreads, int queueCapacity, RejectedExecutionHandler handler) {
        WorkerThreadFactory<C> threadFactory = new WorkerThreadFactory<C>(name, nestedContext, contextFactory);
        return new ThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(queueCapacity), threadFactory, handler);
    }

    public static <C extends ThreadContext> ExecutorService newBlockingFixedThreadPool(String name, String nestedContext, ThreadContextFactory<C> contextFactory, int nThreads, int queueCapacity) {
        return WorkerTask.newBlockingFixedThreadPool(name, nestedContext, contextFactory, nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, queueCapacity);
    }

    private static <C extends ThreadContext> ExecutorService newBlockingFixedThreadPool(String name, String nestedContext, ThreadContextFactory<C> contextFactory, int mThreads, int nThreads, long keepAliveTime, TimeUnit unit, int queueCapacity) {
        WorkerThreadFactory<C> threadFactory = new WorkerThreadFactory<C>(name, nestedContext, contextFactory);
        AbstractQueue queue = queueCapacity > 0 ? new ArrayBlockingQueue<Runnable>(queueCapacity){

            @Override
            public boolean offer(Runnable e) {
                try {
                    super.put(e);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return true;
            }
        } : new SynchronousQueue<Runnable>(){

            @Override
            public boolean offer(Runnable e) {
                try {
                    super.put(e);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
                return true;
            }
        };
        return new ThreadPoolExecutor(nThreads, mThreads, keepAliveTime, unit, (BlockingQueue<Runnable>)((Object)queue), threadFactory);
    }

    public static <C extends ThreadContext> ScheduledExecutorService newScheduledThreadPool(String name, String nestedContext, ThreadContextFactory<C> contextFactory, int nThreads) {
        WorkerThreadFactory<C> threadFactory = new WorkerThreadFactory<C>(name, nestedContext, contextFactory);
        return Executors.newScheduledThreadPool(nThreads, threadFactory);
    }

    public static <C extends ThreadContext> void runSync(ThreadContextFactory<C> contextFactory, List<WorkerTask<C>> workers) {
        WorkerTask.runSync(contextFactory, workers.toArray(new WorkerTask[workers.size()]));
    }

    public static <C extends ThreadContext> void runSync(final ThreadContextFactory<C> contextFactory, WorkerTask<C> ... workers) {
        final Semaphore semaphore = new Semaphore(1 - workers.length);
        for (final WorkerTask<C> w : workers) {
            Runnable task = new Runnable(){

                @Override
                public void run() {
                    w.setContext(contextFactory.newThreadContext());
                    w.run();
                    semaphore.release();
                }
            };
            new Thread(task).start();
        }
        semaphore.acquireUninterruptibly();
    }

    public static class BlockingExecutionHandler
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                if (!executor.isShutdown()) {
                    executor.getQueue().put(r);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Executor was interrupted while the task was waiting to put on work queue", e);
            }
        }
    }
}

