/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import ru.bitel.common.RangeUtils;
import ru.bitel.common.util.Matcher;
import ru.bitel.common.util.Ranger;

public final class CopyOnWriteRangeListMap<K, V, C extends Comparable<C>> {
    private final int initialListCapacity;
    private final ConcurrentMap<K, List<V>> map;
    private final Ranger<V, C> ranger;

    public CopyOnWriteRangeListMap(Ranger<V, C> ranger) {
        this.initialListCapacity = 4;
        this.map = new ConcurrentHashMap<K, List<V>>();
        this.ranger = ranger;
    }

    public CopyOnWriteRangeListMap(Ranger<V, C> ranger, int initialCapacity, int initialListCapacity) {
        this.initialListCapacity = initialListCapacity;
        this.map = new ConcurrentHashMap<K, List<V>>(initialCapacity);
        this.ranger = ranger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(K key, V value) {
        while (true) {
            ArrayList<V> newList;
            List oldList;
            if ((oldList = (List)this.map.get(key)) != null) {
                newList = new ArrayList(oldList.size() + 1);
                newList.addAll(oldList);
                newList.add(value);
                if (!this.map.replace(key, oldList, newList)) continue;
                return;
            }
            newList = new ArrayList<V>(this.initialListCapacity);
            newList.add(value);
            if (this.map.putIfAbsent(key, newList) == null) return;
        }
    }

    public boolean remove(K key, V value) {
        block2: {
            List oldList;
            ArrayList newList;
            do {
                if ((oldList = (List)this.map.get(key)) == null) {
                    return false;
                }
                newList = new ArrayList(oldList);
                if (!newList.remove(value)) break block2;
            } while (!(newList.size() == 0 ? this.map.remove(key, oldList) : this.map.replace(key, oldList, newList)));
            return true;
        }
        return false;
    }

    public List<V> get(K key) {
        return (List)this.map.get(key);
    }

    public V get(K key, C c) {
        List list;
        if (key != null && (list = (List)this.map.get(key)) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object value = list.get(i);
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return (V)value;
            }
        }
        return null;
    }

    public V get(K key, C c, Matcher<V> matcher) {
        List list;
        if (key != null && (list = (List)this.map.get(key)) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object value = list.get(i);
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value)) || !matcher.matched(value)) continue;
                return (V)value;
            }
        }
        return null;
    }

    public V get(K key, Matcher<V> matcher, C c) {
        List list;
        if (key != null && (list = (List)this.map.get(key)) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object value = list.get(i);
                if (!matcher.matched(value) || !RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                return (V)value;
            }
        }
        return null;
    }

    public List<V> list(K key, C c) {
        ArrayList result = new ArrayList();
        List list = (List)this.map.get(key);
        if (list != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Object value = list.get(i);
                if (!RangeUtils.inRange(c, c, (Comparable)this.ranger.getMinValue(value), (Comparable)this.ranger.getMaxValue(value))) continue;
                result.add(value);
            }
        }
        return result;
    }

    public void clear() {
        this.map.clear();
    }
}

