/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.reports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlElements;
import ru.bitel.common.reports.SeriesCollection;
import ru.bitel.common.reports.SeriesDataItem;
import ru.bitel.common.reports.SimpleSeriesDataItem;

public class Series<K, V> {
    private String title;
    private String description;
    private List<SeriesDataItem<K, V>> items;
    private final transient SeriesCollection<K, V> seriesCollection;

    protected Series() {
        this.seriesCollection = null;
    }

    protected Series(SeriesCollection<K, V> seriesCollection, String title, String description) {
        this.title = title;
        this.description = description;
        this.seriesCollection = seriesCollection;
        this.items = new ArrayList<SeriesDataItem<K, V>>();
        seriesCollection.addSeries(this);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlElementWrapper
    @XmlElements(value={@XmlElement(name="item")})
    public List<SeriesDataItem<K, V>> getItems() {
        return this.items;
    }

    public void setItems(List<SeriesDataItem<K, V>> items) {
        this.items = items;
    }

    protected SeriesDataItem<K, V> newItem(K key, V value) {
        return new SimpleSeriesDataItem<K, V>(key, value);
    }

    public void add(K key, V value) {
        int count = this.items.size();
        if (count == 0) {
            this.items.add(this.newItem(key, value));
        } else {
            Object last = this.items.get((int)(this.items.size() - 1)).key;
            if (this.seriesCollection.comparator.compare(key, last) > 0) {
                this.items.add(this.newItem(key, value));
            } else {
                SeriesDataItem<K, V> item = this.newItem(key, value);
                int index = Collections.binarySearch(this.items, item, (a2, b2) -> this.seriesCollection.comparator.compare(a2.key, b2.key));
                if (index < 0) {
                    this.items.add(-index - 1, item);
                } else {
                    SeriesDataItem<K, V> existing = this.items.get(index);
                    existing.value = this.seriesCollection.plus.apply(existing.value, value);
                }
            }
        }
    }
}

