/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Proxy;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Comparator;

public class SerialUtils {
    public static long generateSerialVersionUID(Class<?> cl) {
        if (!Serializable.class.isAssignableFrom(cl) || Proxy.isProxyClass(cl)) {
            return 0L;
        }
        try {
            int i;
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            DataOutputStream dout = new DataOutputStream(bout);
            dout.writeUTF(cl.getName());
            Field[] fields = cl.getDeclaredFields();
            MemberSignature[] fieldSigs = new MemberSignature[fields.length];
            for (i = 0; i < fields.length; ++i) {
                fieldSigs[i] = new MemberSignature(fields[i]);
            }
            Arrays.sort(fieldSigs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String name1 = ((MemberSignature)o1).name;
                    String name2 = ((MemberSignature)o2).name;
                    return name1.compareTo(name2);
                }
            });
            for (i = 0; i < fieldSigs.length; ++i) {
                MemberSignature sig = fieldSigs[i];
                int mods = sig.member.getModifiers() & 0xDF;
                if ((mods & 2) != 0 && (mods & 0x88) != 0) continue;
                dout.writeUTF(sig.name);
                dout.writeInt(mods);
                dout.writeUTF(sig.signature);
            }
            dout.flush();
            MessageDigest md = MessageDigest.getInstance("SHA");
            byte[] hashBytes = md.digest(bout.toByteArray());
            long hash = 0L;
            for (int i2 = Math.min(hashBytes.length, 8) - 1; i2 >= 0; --i2) {
                hash = hash << 8 | (long)(hashBytes[i2] & 0xFF);
            }
            return hash;
        }
        catch (IOException ex) {
            throw new InternalError();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new SecurityException(ex.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getClassSignature(Class cl) {
        StringBuilder sbuf = new StringBuilder();
        while (cl.isArray()) {
            sbuf.append('[');
            cl = cl.getComponentType();
        }
        if (cl.isPrimitive()) {
            if (cl == Integer.TYPE) {
                sbuf.append('I');
                return sbuf.toString();
            } else if (cl == Byte.TYPE) {
                sbuf.append('B');
                return sbuf.toString();
            } else if (cl == Long.TYPE) {
                sbuf.append('J');
                return sbuf.toString();
            } else if (cl == Float.TYPE) {
                sbuf.append('F');
                return sbuf.toString();
            } else if (cl == Double.TYPE) {
                sbuf.append('D');
                return sbuf.toString();
            } else if (cl == Short.TYPE) {
                sbuf.append('S');
                return sbuf.toString();
            } else if (cl == Character.TYPE) {
                sbuf.append('C');
                return sbuf.toString();
            } else if (cl == Boolean.TYPE) {
                sbuf.append('Z');
                return sbuf.toString();
            } else {
                if (cl != Void.TYPE) throw new InternalError();
                sbuf.append('V');
            }
            return sbuf.toString();
        } else {
            sbuf.append('L' + cl.getName().replace('.', '/') + ';');
        }
        return sbuf.toString();
    }

    private static class MemberSignature {
        public final Member member;
        public final String name;
        public final String signature;

        public MemberSignature(Field field) {
            this.member = field;
            this.name = field.getName();
            this.signature = SerialUtils.getClassSignature(field.getType());
        }
    }
}

