/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Preferences
extends ParameterMap {
    private static final Logger log = Logger.getLogger(Preferences.class);
    protected String bundleName;
    protected final Map<String, String> data;
    private final Map<String, Object> objectMap;
    private static final Pattern variablePattern = Pattern.compile("\\{@([\\w\\.]+)\\}");
    private static final Comparator<Map.Entry<String, String>> entryComparator = new Comparator<Map.Entry<String, String>>(){

        @Override
        public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    @Override
    public String get(String key, String def) {
        String result = this.data.get(key);
        return result != null ? result : def;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.data.entrySet();
    }

    @Override
    protected void extract(Map<String, String> data) {
        data.putAll(this.data);
    }

    public void set(String key, String value) {
        this.data.put(key, value);
    }

    public void loadData(String conf, String delim) {
        StringTokenizer st = new StringTokenizer(Utils.maskNull(conf), delim);
        while (st.hasMoreTokens()) {
            this.loadDataEntry(this.data, st.nextToken().trim());
        }
    }

    public Preferences() {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
    }

    public Preferences(boolean concurrent, boolean objectMap) {
        Map<Object, Object> map = this.data = concurrent ? new ConcurrentHashMap() : new HashMap();
        this.objectMap = objectMap ? (concurrent ? new ConcurrentHashMap() : new HashMap()) : null;
    }

    public Preferences(String bundleName) {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
        this.bundleName = bundleName;
        this.loadBundle(this.data);
    }

    public Preferences(URL url) {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
        try {
            if (url != null) {
                this.bundleName = url.getFile();
                this.loadFromInputStream(url.openStream(), this.data);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Preferences(String data, String delim) {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
        this.loadData(data, delim, this.data);
    }

    public Preferences(ParameterMap setup, String data, String delim) {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
        for (Map.Entry<String, String> e : setup.entrySet()) {
            this.data.put(e.getKey(), e.getValue());
        }
        this.loadData(data, delim, this.data);
    }

    public Preferences(ParameterMap setup, String data, String delim, boolean concurrent, boolean objectMap) {
        Map<Object, Object> map = this.data = concurrent ? new ConcurrentHashMap() : new HashMap();
        this.objectMap = objectMap ? (concurrent ? new ConcurrentHashMap() : new HashMap()) : null;
        for (Map.Entry<String, String> e : setup.entrySet()) {
            this.data.put(e.getKey(), e.getValue());
        }
        this.loadData(data, delim, this.data);
    }

    public Preferences(Map<String, String> data) {
        this.data = new ConcurrentHashMap<String, String>();
        this.objectMap = new ConcurrentHashMap<String, Object>();
        this.data.putAll(data);
    }

    public Preferences(Map<String, String> data, boolean concurrent, boolean objectMap) {
        Map<Object, Object> map = this.data = concurrent ? new ConcurrentHashMap() : new HashMap();
        this.objectMap = objectMap ? (concurrent ? new ConcurrentHashMap() : new HashMap()) : null;
        this.data.putAll(data);
    }

    public final void putObject(String key, Object val) {
        this.objectMap.put(key, val);
    }

    public final Object getObject(String key, Object def) {
        Object result = this.objectMap.get(key);
        return result != null ? result : def;
    }

    public final Object getObject(String key) {
        return this.objectMap.get(key);
    }

    public final Object removeObject(String key) {
        return this.objectMap.remove(key);
    }

    protected void loadBundle(Map<String, String> data) {
        try {
            File file = new File(this.bundleName.replace('.', '/') + ".xml");
            if (file.exists()) {
                Document doc = XMLUtils.parseDocument(new InputSource(new FileInputStream(file)));
                NodeList nodes = doc.getDocumentElement().getChildNodes();
                int length = nodes.getLength();
                for (int i = 0; i < length; ++i) {
                    Node node = nodes.item(i);
                    if (node.getNodeType() != 1 || !"param".equals(node.getNodeName())) continue;
                    data.put(((Element)node).getAttribute("name"), ((Element)node).getAttribute("value"));
                }
            } else {
                file = new File(this.bundleName.replace('.', '/') + ".properties");
                if (file.exists()) {
                    this.loadFromInputStream(new FileInputStream(file), data);
                }
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    protected void loadFromInputStream(InputStream inputStream, Map<String, String> data) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        String line = null;
        while ((line = reader.readLine()) != null) {
            this.loadDataEntry(data, line.trim());
        }
        inputStream.close();
    }

    protected void loadData(String conf, String delim, Map<String, String> data) {
        StringTokenizer st = new StringTokenizer(Utils.maskNull(conf), delim);
        while (st.hasMoreTokens()) {
            this.loadDataEntry(data, st.nextToken().trim());
        }
    }

    protected void loadDataEntry(Map<String, String> data, String line) {
        if (line.startsWith("#")) {
            return;
        }
        int pos = line.indexOf(61);
        if (pos > -1) {
            String key = line.substring(0, pos);
            String value = line.substring(pos + 1);
            if (key.startsWith("@")) {
                key = key.substring(1);
            }
            data.put(key, System.getProperty(key, this.insertVariablesValues(value, data)));
        }
    }

    private String insertVariablesValues(String value, Map<String, String> data) {
        Matcher m = variablePattern.matcher(value);
        if (m.find()) {
            StringBuffer newValue = new StringBuffer(value.length() + 16);
            String varName = m.group(1);
            String var = data.get(varName);
            if (var != null) {
                var = Matcher.quoteReplacement(var);
                m.appendReplacement(newValue, var);
            }
            while (m.find()) {
                var = data.get(m.group(1));
                if (var == null) continue;
                var = Matcher.quoteReplacement(var);
                m.appendReplacement(newValue, var);
            }
            m.appendTail(newValue);
            return newValue.toString();
        }
        return value;
    }

    @Deprecated
    public List<Object> getOrderedValues(String prefix) {
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>(this.entrySet());
        Collections.sort(entries, entryComparator);
        ArrayList<Object> result = new ArrayList<Object>(entries.size());
        for (Map.Entry entry : entries) {
            if (!((String)entry.getKey()).startsWith(prefix)) continue;
            result.add(entry.getValue());
        }
        return result;
    }

    @Deprecated
    public List<Map<String, String>> parseObjects(String prefix) {
        HashMap<Integer, HashMap<String, String>> tmpMap = new HashMap<Integer, HashMap<String, String>>();
        for (Map.Entry<String, String> value : this.sub(prefix).entrySet()) {
            Integer id = null;
            String key = null;
            int pos = value.getKey().indexOf(46);
            if (pos <= 0) continue;
            id = Utils.parseInt(value.getKey().substring(0, pos));
            key = value.getKey().substring(pos + 1);
            HashMap<String, String> data = (HashMap<String, String>)tmpMap.get(id);
            if (data == null) {
                data = new HashMap<String, String>();
                data.put("id", String.valueOf(id));
                tmpMap.put(id, data);
            }
            data.put(key, value.getValue());
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        res.addAll(tmpMap.values());
        Collections.sort(res, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> o1, Map<String, String> o2) {
                Integer id1 = Utils.parseInt(o1.get("id"));
                Integer id2 = Utils.parseInt(o2.get("id"));
                return id1 - id2;
            }
        });
        return res;
    }

    @Deprecated
    public Map<String, Map<String, String>> parseObjectsNoOrder(String prefix) {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> value : this.sub(prefix).entrySet()) {
            String id = null;
            String key = null;
            int pos = value.getKey().indexOf(46);
            if (pos <= 0) continue;
            id = value.getKey().substring(0, pos);
            key = value.getKey().substring(pos + 1);
            HashMap<String, String> data = (HashMap<String, String>)result.get(id);
            if (data == null) {
                data = new HashMap<String, String>();
                data.put("id", String.valueOf(id));
                result.put(id, data);
            }
            data.put(key, value.getValue());
        }
        return result;
    }

    protected void loadModuleSetup(Connection con, int mid, Map<String, String> data) {
        try {
            String query = "SELECT config FROM module_config WHERE mid=? AND active=1 LIMIT 1";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setInt(1, mid);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                String config = rs.getString(1);
                this.loadData(config, "\n", data);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected void updateData(Map<String, String> data) {
        this.data.putAll(data);
        this.data.keySet().retainAll(data.keySet());
    }
}

