/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.utils.apps.update;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AppsUpdate {
    private static final String LIB_DIR = "lib";
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String serverUrl = null;
    private String serverConfigFileName = null;
    private String serverAppsType = System.getProperty("apps.type");
    private boolean serverCheckSSL = false;
    private List<LibInfo> deleteLibs = null;

    public static void main(String[] args) {
        AppsUpdate appsUpdate = new AppsUpdate();
        appsUpdate.getUpdateServerInfo();
        if (appsUpdate.serverUrl == null) {
            System.err.println("\u0412 \u0444\u0430\u0439\u043b\u0435 " + appsUpdate.serverConfigFileName + " \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0435\u0440 <param name=\"server.update.url\" value=\"http[s]://host[:port]/bgbilling\"/>");
            System.exit(1);
        }
        File libDir = new File(System.getProperty("lib.dir", LIB_DIR));
        try {
            List<LibInfo> localLibInfos = appsUpdate.getLocalLibInfos(libDir);
            List<LibInfo> serverLibInfos = appsUpdate.getServerLibInfos();
            appsUpdate.deleteLibs = new ArrayList<LibInfo>();
            if (!serverLibInfos.isEmpty()) {
                for (LibInfo libInfo : localLibInfos) {
                    if (serverLibInfos.stream().anyMatch(e -> e.equals(libInfo))) continue;
                    appsUpdate.deleteLibs.add(libInfo);
                }
            }
            ArrayList<LibInfo> downloadLibs = new ArrayList<LibInfo>();
            for (LibInfo libInfo : serverLibInfos) {
                if (localLibInfos.stream().anyMatch(e -> e.equals(libInfo))) continue;
                downloadLibs.add(libInfo);
            }
            System.out.println("\n\u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a\u0418 \u0414\u041b\u042f \u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0418:");
            if (downloadLibs.isEmpty()) {
                System.out.println("\t\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
            } else {
                downloadLibs.forEach(e -> System.out.println("\t" + e));
                appsUpdate.doDownloadLibs(downloadLibs, libDir);
            }
            System.out.println("\n\u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a\u0418 \u0414\u041b\u042f \u0423\u0414\u0410\u041b\u0415\u041d\u0418\u042f:");
            if (appsUpdate.deleteLibs.isEmpty()) {
                System.out.println("\t\u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d\u044b");
            } else {
                appsUpdate.doDeleteLibs(appsUpdate.deleteLibs, libDir);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LibInfo> getLocalLibInfos(File libDir) throws Exception {
        ArrayList<LibInfo> result = new ArrayList<LibInfo>();
        for (File subDir : libDir.listFiles()) {
            if (!subDir.isDirectory()) continue;
            String type = subDir.getName();
            for (File file : subDir.listFiles()) {
                if (!file.getName().endsWith(".jar")) continue;
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                try (FileInputStream inputStream = new FileInputStream(file);){
                    this.readInputStream(new DigestInputStream(inputStream, messageDigest));
                }
                result.add(new LibInfo(type, file.getName().substring(0, file.getName().length() - 4), this.bytesToHex(messageDigest.digest())));
            }
        }
        return result;
    }

    private List<LibInfo> getServerLibInfos() throws Exception {
        ArrayList<LibInfo> result = new ArrayList<LibInfo>();
        StringBuilder outputText = new StringBuilder("appsType=" + this.serverAppsType + "&action=getAppsLibInfos");
        HttpURLConnection urlConnection = this.getHttpURLConnection(this.serverUrl, outputText.toString(), this.serverCheckSSL);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
        if (bufferedReader.ready()) {
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                result.add(new LibInfo(line));
            }
        }
        System.out.println("\u0417\u0410\u041f\u0420\u041e\u0421 \u0421\u041f\u0418\u0421\u041a\u0410 \u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a:\n\t" + this.serverUrl + "?" + outputText.toString());
        System.out.println("\u041e\u0422\u0412\u0415\u0422:");
        result.forEach(e -> System.out.println("\t" + e));
        return result;
    }

    private void doDownloadLibs(List<LibInfo> downloadLibs, File libDir) throws Exception {
        int len;
        if (downloadLibs == null || downloadLibs.isEmpty()) {
            return;
        }
        StringBuilder outputText = new StringBuilder("appsType=" + this.serverAppsType + "&action=getAppsLibs");
        downloadLibs.forEach(e -> outputText.append("&libName=").append(e.type).append("*").append(e.name));
        System.out.println("\n\u0417\u0410\u041f\u0420\u041e\u0421 \u041d\u0410 \u0417\u0410\u0413\u0420\u0423\u0417\u041a\u0423 \u0411\u0418\u0411\u041b\u0418\u041e\u0422\u0415\u041a:\n\t" + this.serverUrl + "?" + outputText.toString());
        System.out.println("\u041e\u0422\u0412\u0415\u0422:");
        HttpURLConnection urlConnection = this.getHttpURLConnection(this.serverUrl, outputText.toString(), this.serverCheckSSL);
        InputStream inputStream = urlConnection.getInputStream();
        while ((len = inputStream.read()) != -1) {
            String libType = new String(this.getBytes(inputStream, len), "UTF-8");
            len = inputStream.read();
            if (len == -1) break;
            String libName = new String(this.getBytes(inputStream, len), "UTF-8");
            this.loadLib(inputStream, libDir, libType, libName);
        }
        urlConnection.disconnect();
    }

    private void doDeleteLibs(List<LibInfo> deleteLibs, File libDir) {
        for (LibInfo libInfo : deleteLibs) {
            File libNameFile = new File(libDir, libInfo.type + File.separator + libInfo.name + ".jar");
            if (libNameFile.exists() && libNameFile.isFile() && libNameFile.canWrite()) {
                libNameFile.delete();
                System.out.println("\t" + libNameFile.getPath() + " -> \u0443\u0434\u0430\u043b\u0435\u043d\u0430");
                continue;
            }
            System.out.println("\t" + libNameFile.getPath() + " -> \u043d\u0435 \u0443\u0434\u0430\u043b\u0435\u043d\u0430");
        }
    }

    private File getConfigFile(File configFile, String fileName) {
        if (configFile == null) {
            configFile = new File(fileName);
            if (configFile.exists()) {
                this.serverConfigFileName = fileName;
            } else {
                configFile = null;
            }
        }
        return configFile;
    }

    private void getUpdateServerInfo() {
        File configFile = this.getConfigFile(null, System.getProperty("setup.name", "application") + ".xml");
        configFile = this.getConfigFile(configFile, "voice-application.xml");
        configFile = this.getConfigFile(configFile, "inet-access.xml");
        configFile = this.getConfigFile(configFile, "inet-accounting.xml");
        configFile = this.getConfigFile(configFile, "tv-access.xml");
        if ((configFile = this.getConfigFile(configFile, "tv-accounting.xml")) != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(configFile);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                String configData = new String(this.readInputStream(bufferedInputStream), "UTF-8");
                Pattern pattern = Pattern.compile("<\\s*param\\s+name=\"server\\.update\\.url\"\\s+value=\"([^\"]+)\"/>", 8);
                Matcher matcher = pattern.matcher(configData);
                if (matcher.find()) {
                    this.serverUrl = matcher.group(1);
                }
                if (this.serverUrl != null && !this.serverUrl.endsWith("/clientUpdate")) {
                    this.serverUrl = this.serverUrl + (this.serverUrl.endsWith("/") ? "" : "/") + "clientUpdate";
                }
                if ((matcher = (pattern = Pattern.compile("<\\s*param\\s+name=\"server\\.update\\.check\\.ssl\"\\s+value=\"([^\"]+)\"/>", 8)).matcher(configData)).find()) {
                    this.serverCheckSSL = new Boolean(matcher.group(1));
                }
                if ((matcher = (pattern = Pattern.compile("<\\s*param\\s+name=\"server\\.apps\\.type\"\\s+value=\"([^\"]+)\"/>", 8)).matcher(configData)).find()) {
                    this.serverAppsType = matcher.group(1);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.print("\u041d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u0444\u0430\u0439\u043b - application.xml");
            System.exit(1);
        }
    }

    private void loadLib(InputStream inputStream, File dir, String libType, String libName) throws Exception {
        int b2;
        long lengthTotal;
        File tmpFile = new File(dir, libType + File.separator + "temp.jar");
        File libNameFile = new File(dir, libType + File.separator + libName + ".jar");
        int len = 8;
        System.out.printf("\ttype=%s   name=%s   size=%d  -> %s\n", libType, libName, lengthTotal, libNameFile.getPath());
        File newLibNameFile = new File(tmpFile.getPath());
        newLibNameFile.getParentFile().mkdirs();
        newLibNameFile.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(newLibNameFile);
        for (long length = lengthTotal = this.bytesToLong(this.getBytes(inputStream, len)); length > 0L; length -= (long)b2) {
            byte[] bytes = new byte[(int)(length > 8192L ? 8192L : length)];
            b2 = inputStream.read(bytes);
            fileOutputStream.write(bytes, 0, b2);
        }
        fileOutputStream.flush();
        fileOutputStream.close();
        if (libNameFile.exists() && libNameFile.isFile()) {
            libNameFile.delete();
            LibInfo libInfo = null;
            for (LibInfo libInfo2 : this.deleteLibs) {
                if (!libInfo2.name.equals(libName) || !libInfo2.type.equals(libType)) continue;
                libInfo = libInfo2;
                break;
            }
            if (libInfo != null) {
                this.deleteLibs.remove(libInfo);
            }
        }
        newLibNameFile.renameTo(libNameFile);
    }

    private long bytesToLong(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.put(bytes);
        buffer.flip();
        return buffer.getLong();
    }

    private byte[] getBytes(InputStream inputStream, int len) throws Exception {
        byte[] bytes = new byte[len];
        while (len > 0) {
            int b2 = inputStream.read(bytes, bytes.length - len, len);
            len -= b2;
        }
        return bytes;
    }

    private byte[] readInputStream(InputStream inputStream) throws Exception {
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        int BLOCK_LENGTH = 4096;
        int b2 = 0;
        int totalCount = 0;
        byte[] block = new byte[4096];
        do {
            if ((b2 = inputStream.read(block)) <= 0) continue;
            totalCount += b2;
            byte[] d = new byte[b2];
            System.arraycopy(block, 0, d, 0, b2);
            list.add(d);
        } while (b2 != -1);
        b2 = 0;
        byte[] bytes = new byte[totalCount];
        for (byte[] e : list) {
            System.arraycopy(e, 0, bytes, b2, e.length);
            b2 += e.length;
        }
        return bytes;
    }

    public HttpURLConnection getHttpURLConnection(String serverURL, String outputText, boolean anySSL) throws Exception {
        URL url = new URL(serverURL);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        this.ssl(urlConnection, url, anySSL);
        urlConnection.setConnectTimeout(3000);
        urlConnection.setRequestMethod(outputText == null ? "GET" : "POST");
        urlConnection.setDoOutput(outputText != null);
        urlConnection.setDoInput(true);
        if (outputText != null) {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(urlConnection.getOutputStream()));
            bw.write(outputText.toCharArray());
            bw.close();
        }
        urlConnection.connect();
        return urlConnection;
    }

    private void ssl(HttpURLConnection urlConnection, URL url, boolean anySSL) throws Exception {
        if (anySSL && "https".equalsIgnoreCase(url.getProtocol())) {
            SSLContext sslContext = SSLContext.getInstance(System.getProperty("version.tls", "TLSv1.2"));
            sslContext.init(new KeyManager[0], new TrustManager[]{new BGTrustManager()}, new SecureRandom());
            ((HttpsURLConnection)urlConnection).setSSLSocketFactory(sslContext.getSocketFactory());
            ((HttpsURLConnection)urlConnection).setHostnameVerifier(new BGHostnameVerifier());
        }
    }

    private String bytesToHex(byte[] bytes) {
        char[] chars = new char[bytes.length * 2];
        int j = 0;
        for (int i = 0; i < bytes.length; ++i) {
            int v = bytes[i] & 0xFF;
            chars[j++] = HEX[v >>> 4];
            chars[j++] = HEX[v & 0xF];
        }
        return new String(chars);
    }

    public class BGHostnameVerifier
    implements HostnameVerifier {
        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }

    public class BGTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }

    class LibInfo {
        String type;
        String name;
        String hash;

        LibInfo(String type, String name, String hash) {
            this.type = type;
            this.name = name;
            this.hash = hash;
        }

        LibInfo(String info) {
            String[] data = info.split("\t");
            this.type = data[0];
            this.name = data[1];
            this.hash = data[2];
        }

        public boolean equals(Object obj) {
            if (obj instanceof LibInfo) {
                LibInfo libInfo = (LibInfo)obj;
                return this.name.equals(libInfo.name) && this.type.equals(libInfo.type) && this.hash.equals(libInfo.hash);
            }
            return super.equals(obj);
        }

        public String toString() {
            return String.format("%s\t%-35s\t%s", this.type, this.name, this.hash);
        }
    }
}

