/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.math.BigDecimal;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.tariff.tree.server.AbstractTariffRequest;
import ru.bitel.bgbilling.kernel.tariff.tree.server.DefaultTariffTreeNode;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffContext;
import ru.bitel.common.ParameterMap;

public class MultCostTariffTreeNode
extends DefaultTariffTreeNode<AbstractTariffRequest<?>, TariffContext> {
    private static final Logger logger = Logger.getLogger(MultCostTariffTreeNode.class);
    private final BigDecimal multiplicand;

    public MultCostTariffTreeNode(int id, ParameterMap parameterMap) {
        super(id, parameterMap);
        this.multiplicand = parameterMap.getBigDecimal("value", BigDecimal.ONE);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("multiplicand = " + this.multiplicand));
        }
    }

    @Override
    public int executeImpl(Long treeNodeId, AbstractTariffRequest<?> tariffRequest, TariffContext tariffContext) {
        if (((AbstractTariffRequest.ServiceCost)tariffRequest.serviceCost).cost != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("tariffRequest.serviceCost.cost(before) = " + ((AbstractTariffRequest.ServiceCost)tariffRequest.serviceCost).cost));
            }
            ((AbstractTariffRequest.ServiceCost)tariffRequest.serviceCost).cost = ((AbstractTariffRequest.ServiceCost)tariffRequest.serviceCost).cost.multiply(this.multiplicand, tariffContext.mc);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("tariffRequest.serviceCost.cost(after) = " + ((AbstractTariffRequest.ServiceCost)tariffRequest.serviceCost).cost));
            }
            return 1;
        }
        return 0;
    }
}

