/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.tree.server;

import java.math.BigDecimal;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import ru.bitel.bgbilling.kernel.contract.status.server.ContractStatusList;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionList;
import ru.bitel.bgbilling.kernel.tariff.tree.server.TariffModuleTreeSet;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.systems.inventory.product.server.ProductPeriodRuntimeList;

public abstract class AbstractTariffRequest<S extends ServiceCost> {
    protected ConnectionSet connectionSet;
    public final int moduleId;
    public final int contractId;
    public final long sessionId;
    protected Map<Integer, List<S>> serviceCostMap = new HashMap<Integer, List<S>>(8);
    public S serviceCost = null;
    private int accountingMonthDays;
    private Calendar time;
    private int timeRangeId;
    private boolean accepted;
    private boolean infoEnable = true;
    private StringBuilder errors = null;
    private StringBuilder info = null;
    private BigDecimal clientCdrCost = null;
    public final long contractGroups;
    private final int domainId;
    protected ProductPeriodRuntimeList contractProductPeriodRuntimeList;
    protected ProductPeriodRuntimeList productPeriodRuntimeList;
    public final int accountingPeriodId;
    public final long accountingPeriodMillisFrom;
    public final long accountingPeriodMillisTo;
    public final ContractStatusList suspendedPeriodList;
    private ContractTariffOptionList contractTariffOptions;
    private Map<Integer, ContractTariffOptionList.OptionItem> currentTariffOptionMap = null;
    private long currentTariffOptionMapMillis;
    @Deprecated
    public Map<Integer, ContractTariffOptionList.OptionItem> tariffOptionMap = null;
    private TariffModuleTreeSet.Entry tariffTreeSetEntry;
    private long activeProductIdsMillis;
    private Set<Integer> activeProductIds;
    private Map<Class<?>, Set<Long>> acceptedSetMap;

    public AbstractTariffRequest(int moduleId, int contractId, long sessionId) {
        this(0, moduleId, contractId, 0L, sessionId, null, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, long contractGroups) {
        this(domainId, moduleId, contractId, contractGroups, 0L, null, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, long contractGroups, long sessionId, ProductPeriodRuntimeList productPeriodRuntimeList) {
        this(domainId, moduleId, contractId, contractGroups, sessionId, productPeriodRuntimeList, 0, 0L, 0L, null);
    }

    public AbstractTariffRequest(int domainId, int moduleId, int contractId, long contractGroups, long sessionId, ProductPeriodRuntimeList productPeriodRuntimeList, int accountingPeriodId, long accountingPeriodMillisFrom, long accountingPeriodMillisTo, ContractStatusList suspendedPeriodList) {
        this.domainId = domainId;
        this.moduleId = moduleId;
        this.contractId = contractId;
        this.contractGroups = contractGroups;
        this.sessionId = sessionId;
        this.productPeriodRuntimeList = productPeriodRuntimeList;
        this.suspendedPeriodList = suspendedPeriodList;
        this.accountingPeriodId = accountingPeriodId;
        this.accountingPeriodMillisFrom = accountingPeriodMillisFrom;
        this.accountingPeriodMillisTo = accountingPeriodMillisTo;
    }

    public void setServiceCost(Integer serviceId, List<S> serviceCostList) {
        this.serviceCostMap.put(serviceId, serviceCostList);
    }

    public void addServiceCost(S serviceCost) {
        List<S> serviceCostList = this.getServiceCost().get(((ServiceCost)serviceCost).serviceId);
        if (serviceCostList == null) {
            serviceCostList = new ArrayList<S>();
            this.setServiceCost(((ServiceCost)serviceCost).serviceId, serviceCostList);
        }
        serviceCostList.add(serviceCost);
    }

    public Map<Integer, List<S>> getServiceCost() {
        return this.serviceCostMap;
    }

    public Collection<S> getServiceCostList() {
        ArrayList<S> result = new ArrayList<S>();
        for (List<S> me : this.serviceCostMap.values()) {
            result.addAll(me);
        }
        return result;
    }

    public Connection getConnection() {
        return this.connectionSet.getConnection();
    }

    public ConnectionSet getConnectionSet() {
        return this.connectionSet;
    }

    public void setConnectionSet(ConnectionSet connectionSet) {
        this.connectionSet = connectionSet;
    }

    public int getAccountingMonthDays() {
        return this.accountingMonthDays;
    }

    public void setAccountingMonthDays(int accountingMonthDays) {
        this.accountingMonthDays = accountingMonthDays;
    }

    public Calendar getTime() {
        return this.time;
    }

    public void setTime(Calendar time) {
        this.time = time;
    }

    public int getTimeRangeId() {
        return this.timeRangeId;
    }

    public void setTimeRangeId(int timeRangeId) {
        this.timeRangeId = timeRangeId;
    }

    private Set<Integer> getActiveProductSpecIds() {
        long time = this.getTime().getTimeInMillis();
        if (this.activeProductIdsMillis != time) {
            HashSet<Integer> result = new HashSet<Integer>();
            if (this.contractProductPeriodRuntimeList != null) {
                this.contractProductPeriodRuntimeList.activeProductSpecIds(time, result, null);
            }
            if (this.productPeriodRuntimeList != null) {
                this.productPeriodRuntimeList.activeProductSpecIds(time, result, null);
            }
            this.activeProductIds = result.size() > 0 ? result : Collections.emptySet();
            this.activeProductIdsMillis = time;
        }
        return this.activeProductIds;
    }

    public Set<Integer> getActiveProductSpecIds(long millis, Predicate<ProductPeriodRuntimeList.ProductPeriodItem> predicate) {
        if (predicate == null) {
            return this.getActiveProductSpecIds();
        }
        HashSet<Integer> result = new HashSet<Integer>();
        if (this.contractProductPeriodRuntimeList != null) {
            this.contractProductPeriodRuntimeList.activeProductSpecIds(millis, result, predicate);
        }
        if (this.productPeriodRuntimeList != null) {
            this.productPeriodRuntimeList.activeProductSpecIds(millis, result, predicate);
        }
        return result;
    }

    public void addError(String error) {
        if (this.errors == null) {
            this.errors = new StringBuilder();
        }
        this.errors.append(error).append("; ");
    }

    public void setInfoEnable(boolean value) {
        this.infoEnable = value;
    }

    public boolean isInfoEnabled() {
        return this.infoEnable;
    }

    public void addInfo(String info) {
        if (this.info == null) {
            this.info = new StringBuilder();
        }
        this.info.append(info).append("\n");
    }

    public String getErrors() {
        if (this.errors != null && this.errors.length() > 0) {
            return this.errors.substring(0, this.errors.length() - 2);
        }
        return "";
    }

    private CharSequence getInfo() {
        if (this.info != null && this.info.length() > 0) {
            return this.info.subSequence(0, this.info.length() - 1);
        }
        return "";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PARAMS: ");
        sb.append(this.toStringRequestParams());
        sb.append("HIST: ");
        sb.append(this.getInfo());
        return sb.toString();
    }

    protected CharSequence toStringRequestParams() {
        StringBuilder result = new StringBuilder(200);
        result.append("mid: ");
        result.append(this.moduleId);
        result.append("; cid: ");
        result.append(this.contractId);
        result.append("\n");
        for (List<S> me : this.serviceCostMap.values()) {
            for (ServiceCost serviceCost : me) {
                result.append(serviceCost.toString());
                result.append("\n");
            }
        }
        return result.toString();
    }

    public boolean isAccepted() {
        return this.accepted;
    }

    public void setAccepted(boolean accepted) {
        this.accepted = accepted;
    }

    public final Set<Long> getAcceptedSet(Class<?> clazz) {
        Map<Class<?>, Set<Long>> acceptedSetMap;
        Set<Long> acceptedSet;
        if (this.acceptedSetMap == null) {
            this.acceptedSetMap = new HashMap(8);
        }
        if ((acceptedSet = (acceptedSetMap = this.acceptedSetMap).get(clazz)) == null) {
            acceptedSet = new HashSet<Long>(8);
            acceptedSetMap.put(clazz, acceptedSet);
        }
        return acceptedSet;
    }

    public final Map<Class<?>, Set<Long>> acceptedSetPush() {
        Map<Class<?>, Set<Long>> result = this.acceptedSetMap;
        this.acceptedSetMap = null;
        return result;
    }

    public final void acceptedSetClear() {
        if (this.acceptedSetMap != null) {
            for (Set<Long> set : this.acceptedSetMap.values()) {
                set.clear();
            }
        }
    }

    public final void acceptedSetPop(Map<Class<?>, Set<Long>> pushed) {
        this.acceptedSetMap = pushed;
    }

    public TariffModuleTreeSet.Entry getTariffTreeSetEntry() {
        return this.tariffTreeSetEntry;
    }

    public void setTariffTreeSetEntry(TariffModuleTreeSet.Entry tariffTreeSetEntry) {
        this.tariffTreeSetEntry = tariffTreeSetEntry;
    }

    public BigDecimal getClientCdrCost() {
        return this.clientCdrCost;
    }

    public void setClientCdrCost(BigDecimal clientCdrCost) {
        this.clientCdrCost = clientCdrCost;
    }

    public int getDomainId() {
        return this.domainId;
    }

    public void setContractTariffOptions(ContractTariffOptionList contractTariffOptions) {
        this.contractTariffOptions = contractTariffOptions;
    }

    public Map<Integer, ContractTariffOptionList.OptionItem> getTariffOptionMap() {
        return this.getTariffOptionMap(this.time.getTimeInMillis());
    }

    public Map<Integer, ContractTariffOptionList.OptionItem> getTariffOptionMap(long millis) {
        if (this.currentTariffOptionMapMillis != millis) {
            Map result;
            this.currentTariffOptionMap = this.contractTariffOptions != null ? ((result = this.contractTariffOptions.map(millis, millis)) != null && result.size() > 0 ? result : Collections.emptyMap()) : Collections.emptyMap();
            this.currentTariffOptionMapMillis = millis;
        }
        return this.currentTariffOptionMap;
    }

    public ContractTariffOptionList getContractTariffOptions() {
        return this.contractTariffOptions;
    }

    public static abstract class ServiceCost {
        public int serviceId;
        public Calendar date1;
        public Calendar date2;
        public final Calendar serviceStart;
        public final Calendar serviceEnd;
        public int accountingPeriodDays;
        public long amount;
        public BigDecimal cost;
        public boolean amountNull = false;

        public ServiceCost(int serviceId, Calendar serviceStart, Calendar serviceEnd, Calendar date1, Calendar date2, long amount) {
            this.serviceId = serviceId;
            this.serviceStart = serviceStart;
            this.serviceEnd = serviceEnd;
            this.date1 = date1;
            this.date2 = date2;
            this.amount = amount;
            if (date1 != null && date2 != null) {
                this.accountingPeriodDays = date2.get(5) - date1.get(5) + 1;
            }
        }

        protected String paramsToString() {
            StringBuilder result = new StringBuilder();
            result.append("serviceId: ");
            result.append(this.serviceId);
            result.append("; date1: ");
            result.append(TimeUtils.formatDate(this.date1));
            result.append("; date2: ");
            result.append(TimeUtils.formatDate(this.date2));
            result.append("; serviceStart: ");
            result.append(TimeUtils.formatDate(this.serviceStart));
            result.append("; serviceEnd: ");
            result.append(TimeUtils.formatDate(this.serviceEnd));
            result.append("; accountingPeriodDays: ");
            result.append(this.accountingPeriodDays);
            result.append("; amount: ");
            result.append(this.amount);
            result.append("; cost: ");
            result.append(this.cost);
            return result.toString();
        }

        public ServiceCost newCost() {
            ServiceCost result = this.newCostInternal();
            result.amountNull = this.amountNull;
            return result;
        }

        protected ServiceCost newCostInternal() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuilder result = new StringBuilder(100);
            result.append("ServiceCost [");
            result.append(this.paramsToString());
            result.append("]");
            return result.toString();
        }
    }
}

