/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.option.server.action.web;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.web.action.AbstractAction;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntime;
import ru.bitel.bgbilling.kernel.contract.runtime.ContractRuntimeMap;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.ContractTariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOption;
import ru.bitel.bgbilling.kernel.tariff.option.common.bean.TariffOptionActivateMode;
import ru.bitel.bgbilling.kernel.tariff.option.common.service.TariffOptionService;
import ru.bitel.bgbilling.kernel.tariff.option.server.bean.ContractTariffOptionDao;
import ru.bitel.bgbilling.plugins.bonus.common.service.BonusService;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Result;

public class ActionTariffOption
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ActionTariffOption.class);
    @Resource
    private TariffOptionService tariffOptionService;

    public Result<ContractTariffOption> execute() throws BGException {
        return this.execute(this.req.getInt("option_id", -1));
    }

    protected Result<ContractTariffOption> execute(int optionId) throws BGException {
        int modeId = this.req.getInt("mode_id", -1);
        Result<ContractTariffOption> result = new Result<ContractTariffOption>();
        result.setAttribute("option_id", optionId);
        result.setAttribute("mode_id", modeId);
        this.setResultParam("option_id", optionId);
        this.setResultParam("mode_id", modeId);
        Date now = new Date();
        ContractTariffOptionDao ctom = new ContractTariffOptionDao(this.con);
        List<ContractTariffOption> currentContractOptionList = ctom.list(this.cid, now);
        List<TariffOption> availableOptions = this.availableOptions(result, now, currentContractOptionList);
        ctom.close();
        if (availableOptions.size() == 0) {
            optionId = 0;
            modeId = 0;
        } else if (optionId <= 0) {
            optionId = availableOptions.get(0).getId();
        }
        if (optionId > 0) {
            for (TariffOption option : availableOptions) {
                if (option.getId() != optionId) continue;
                result.setAttribute("available_modes", option.getActivateModeList());
                this.setResultParam("available_modes", option.getActivateModeList());
            }
        }
        result.setList(currentContractOptionList);
        ArrayList<ContractTariffOption> futureList = new ArrayList<ContractTariffOption>();
        for (ContractTariffOption option : currentContractOptionList) {
            if (!now.before(option.getTimeFrom())) continue;
            futureList.add(option);
        }
        this.setResultParam("future_options", futureList);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() throws BGException {
        int optionId = this.req.getInt("option_id", -1);
        int modeId = this.req.getInt("mode_id", -1);
        if (optionId <= 0 || modeId <= 0) {
            Date today = new Date();
            ContractTariffOptionDao ctom = new ContractTariffOptionDao(this.con);
            List<ContractTariffOption> currentContractOptionList = ctom.list(this.cid, today);
            List<TariffOption> availableOptions = this.availableOptions(null, today, currentContractOptionList);
            ctom.close();
            if (optionId > 0) {
                if (availableOptions.size() == 0) {
                    optionId = 0;
                    modeId = 0;
                } else if (optionId <= 0) {
                    optionId = availableOptions.get(0).getId();
                }
                if (optionId > 0) {
                    for (TariffOption option : availableOptions) {
                        if (option.getId() != optionId) continue;
                        this.setResultParam("available_modes", option.getActivateModeList());
                    }
                }
            }
            this.setResultParam("option_id", optionId);
            this.setResultParam("mode_id", modeId);
            return;
        }
        if (BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus") != null) {
            BonusService bonusService = this.context.newService(BonusService.class, 0);
            if (this.isPayOnlyBonus(modeId, optionId)) {
                if (this.req.get("redirect") != null) {
                    throw new BGMessageException("\u041e\u043f\u043b\u0430\u0442\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u0443\u044e \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u0431\u044b\u043b\u043e \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438.");
                }
                TariffOptionActivateMode mode = this.tariffOptionService.tariffOptionActivateModeGet(optionId, modeId);
                BigDecimal sum = bonusService.bonusSummaMax(this.cid, 0, mode.getChargeSumma(), false);
                if (this.isPayBonus(modeId, optionId) && sum.compareTo(mode.getChargeSumma()) >= 0) {
                    this.redirectToBonus(modeId, optionId);
                    return;
                }
                throw new BGMessageException("\u0414\u0430\u043d\u043d\u0443\u044e \u0442\u0430\u0440\u0438\u0444\u043d\u0443\u044e \u043e\u043f\u0446\u0438\u044e \u043c\u043e\u0436\u043d\u043e \u0430\u043a\u0442\u0438\u0432\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0431\u043e\u043d\u0443\u0441\u0430\u043c\u0438, \u043d\u043e \u0443 \u0432\u0430\u0441 \u0438\u0445 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043e\u0447\u043d\u043e. \u0423 \u0432\u0430\u0441 - " + Utils.formatCost(sum) + ", \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e - " + Utils.formatCost(mode.getChargeSumma()) + ".");
            }
            if (this.isPayBonus(modeId, optionId) && this.req.get("redirect") == null) {
                this.redirectToBonus(modeId, optionId);
                return;
            }
        }
        ContractRuntime contractRuntime = ContractRuntimeMap.getInstance().getContractRuntime(this.context.getConnectionSet(), (Integer)this.cid);
        contractRuntime.lock();
        try {
            this.tariffOptionService.contractTariffOptionActivate(this.cid, optionId, modeId, true);
            try {
                this.context.commit();
                String url = this.context.getRequest().getRequestURI();
                this.context.getResponse().sendRedirect(url + "?module=contract&mid=0&action=TariffOption");
            }
            catch (IOException ex) {
                logger.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        finally {
            contractRuntime.unlock();
            this.execute(-1);
        }
    }

    private List<TariffOption> availableOptions(Result<?> result, Date today, List<ContractTariffOption> currentContractOptionList) throws BGException {
        if (this.setup.getBoolean("tariffOption.dontCheckOnActivateAlreadyActivated", this.setup.getBoolean("allow.parallel.option.activate", false))) {
            currentContractOptionList = new ArrayList<ContractTariffOption>();
        }
        List<TariffOption> options = this.tariffOptionService.tariffOptionListAvailable(this.cid, today, currentContractOptionList, false, true);
        ArrayList<TariffOption> availableOptions = new ArrayList<TariffOption>();
        for (TariffOption option : options) {
            if (!option.isEnable()) continue;
            availableOptions.add(option);
        }
        if (result != null) {
            result.setAttribute("options", options);
            result.setAttribute("available_options", availableOptions);
        }
        this.setResultParam("options", options);
        this.setResultParam("available_options", availableOptions);
        return availableOptions;
    }

    public void deactivate() throws BGException {
        int id = this.req.getInt("id", -1);
        try {
            this.tariffOptionService.contractTariffOptionDeactivate(this.cid, id);
        }
        finally {
            this.setResult(this.execute(0));
        }
    }

    public void delete() throws BGException {
        int id = this.req.getInt("id", -1);
        try {
            this.tariffOptionService.contractTariffOptionDelete(this.cid, id, true);
        }
        finally {
            this.setResult(this.execute(0));
        }
    }

    public void reactivate() throws BGException {
        int id = this.req.getInt("id", -1);
        try {
            this.tariffOptionService.contractTariffOptionReactivate(this.cid, id);
        }
        finally {
            this.setResult(this.execute(0));
        }
    }

    public List<ContractTariffOption> history() throws BGException {
        Date date = this.req.getDateTime("date", new Date());
        return this.tariffOptionService.contractTariffOptionHistory(this.cid, date, true);
    }

    private boolean isPayBonus(int modeId, int optionId) throws BGException {
        BonusService bonusService = this.context.newService(BonusService.class, 0);
        if (bonusService.pluginInclude(this.cid) && bonusService.balance(this.cid, new Date()).compareTo(BigDecimal.ZERO) == 1) {
            List<TariffOptionActivateMode> listMode = this.tariffOptionService.tariffOptionActivateModeList(optionId, new Date());
            TariffOptionActivateMode mode = null;
            for (TariffOptionActivateMode element : listMode) {
                if (element.getId() != modeId) continue;
                mode = element;
                break;
            }
            return mode != null && mode.getChargeSumma().compareTo(BigDecimal.ZERO) == 1 && bonusService.percentOfBonus(mode.getChargeTypeId()) > 0;
        }
        return false;
    }

    private boolean isPayOnlyBonus(int modeId, int optionId) throws BGException {
        Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus").getSetup();
        List<String> list = Utils.toList(setup.get("tariffOptionsPaymentOnlyWithBonuses"));
        for (String str : list) {
            if (Utils.parseInt(str, -1) != optionId) continue;
            return true;
        }
        return false;
    }

    private void redirectToBonus(int modeId, int optionId) {
        try {
            Preferences setup = BGPluginManagerServer.getManager().getPlugin("ru.bitel.bgbilling.plugins.bonus").getSetup();
            String uri = setup.get("redirectUrl");
            if (uri == null) {
                uri = this.context.getRequest().getRequestURI();
            }
            String url = uri + "?action=Bonus&module=ru.bitel.bgbilling.plugins.bonus&mid=0&command=tariffOption&optionId=" + optionId + "&modeId=" + modeId;
            this.context.getResponse().sendRedirect(url);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

