/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.script.server;

import bitel.billing.server.contract.bean.ContractScriptManager;
import bitel.billing.server.script.bean.FunctionManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.glassfish.ha.store.spi.ObjectInputStreamWithLoader;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.container.service.server.ServiceFactory;
import ru.bitel.bgbilling.kernel.dynamic.server.DatabaseClassLoader;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.bgbilling.kernel.script.common.EventScriptService;
import ru.bitel.bgbilling.kernel.script.common.bean.ContractScript;
import ru.bitel.bgbilling.kernel.script.common.bean.EventScriptLink;
import ru.bitel.bgbilling.kernel.script.server.ScriptEventListener;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScript;
import ru.bitel.bgbilling.kernel.script.server.dev.EventScriptBase;
import ru.bitel.bgbilling.kernel.script.server.event.EventScriptLinkDeletedEvent;
import ru.bitel.bgbilling.kernel.script.server.event.EventScriptLinkModifiedEvent;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.NestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerThreadFactory;

public class DynamicScriptEventListener
implements EventListener<Event> {
    private static final Logger logger = Logger.getLogger(DynamicScriptEventListener.class);
    private final EventScriptLink link;
    private final boolean logProcess;
    private static volatile boolean STARTED = false;
    private static boolean AUTO_COMMIT = false;

    public DynamicScriptEventListener(EventScriptLink link, boolean logProcess) throws BGException {
        this.logProcess = logProcess;
        this.link = link;
    }

    public int hashCode() {
        return this.link.getId();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DynamicScriptEventListener) {
            return this.link.getId() == ((DynamicScriptEventListener)obj).link.getId();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(Event e, EventListenerContext ctx) {
        NestedContext.push("script");
        ConnectionSet connectionSet = ctx.getConnectionSet();
        boolean autoCommit = connectionSet.getAutoCommit();
        try {
            if (AUTO_COMMIT && !(e instanceof LocalEvent)) {
                connectionSet.setAutoCommit(true);
            }
            if (e.getContractId() == -1 || this.link.getScriptId() == -1) {
                this.runScript(ctx, connectionSet, e);
            } else {
                for (ContractScript contractScript : new ContractScriptManager(connectionSet.getConnection()).getContractScriptList(e.getContractId(), new GregorianCalendar())) {
                    if (contractScript.getScriptId() != this.link.getScriptId()) continue;
                    this.runScript(ctx, connectionSet, e);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            connectionSet.setAutoCommit(autoCommit);
            NestedContext.pop();
        }
    }

    private final void runScript(EventListenerContext ctx, ConnectionSet set, Event e) {
        long time = System.currentTimeMillis();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream outPrintStream = new PrintStream(out);
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        PrintStream errPrintStream = new PrintStream(err);
        ByteArrayOutputStream exept = new ByteArrayOutputStream();
        PrintStream exPrintStream = new PrintStream(exept);
        try {
            logger.info((Object)("Caught event: " + e.getClass().getName()));
            this.runScriptImpl(ctx, set, e, outPrintStream, errPrintStream);
        }
        catch (Throwable ex) {
            logger.error((Object)("Eval error: " + ex.getMessage()), ex);
            ex.printStackTrace(exPrintStream);
        }
        long processTime = System.currentTimeMillis() - time;
        logger.info((Object)("Process time => " + processTime));
        outPrintStream.flush();
        if (out.size() > 0) {
            logger.info((Object)out.toString());
        }
        if (err.size() > 0) {
            logger.info((Object)err.toString());
        }
        if (exept.size() > 0) {
            logger.error((Object)exept.toString());
        }
        if (this.logProcess && e.isLogFunctionProcess()) {
            FunctionManager.logFunctionProcess(Setup.getSetup(), set, e.getTime(), e.getContractId(), this.link.getTitle(), out.toString(), err.toString(), exept.toString(), "", processTime, logger);
        }
    }

    protected void runScriptImpl(EventListenerContext ctx, ConnectionSet set, Event event, PrintStream outPrintStream, PrintStream errPrintStream) throws Exception {
        try {
            EventScript scriptInstance;
            Event newEvent = event;
            if (event.getClass().getClassLoader() instanceof DatabaseClassLoader) {
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream os = new ObjectOutputStream(baos);){
                    os.writeObject(event);
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                         ObjectInputStreamWithLoader ois = new ObjectInputStreamWithLoader((InputStream)bais, (ClassLoader)new DatabaseClassLoader(Thread.currentThread().getContextClassLoader()));){
                        newEvent = (Event)ois.readObject();
                    }
                }
                scriptInstance = (EventScript)newEvent.getClass().getClassLoader().loadClass(this.link.getClassName()).newInstance();
            } else {
                scriptInstance = DynamicClassManager.getInstance().newInstance(EventScript.class, this.link.getClassName());
            }
            if (scriptInstance instanceof EventScriptBase) {
                ((EventScriptBase)scriptInstance).setErrorStream(errPrintStream);
                ((EventScriptBase)scriptInstance).setOutputStream(outPrintStream);
            }
            scriptInstance.onEvent(newEvent, Setup.getSetup(), set);
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void start(final boolean local) throws BGException {
        if (STARTED) {
            logger.error((Object)"Already started");
            return;
        }
        STARTED = true;
        final int timeout = Setup.getSetup().getInt("script.timeout", 600);
        final boolean logging = Setup.getSetup().getInt("log.function.process", 0) > 0;
        AUTO_COMMIT = !local && Setup.getSetup().getInt("script.autoCommit", 0) > 0;
        EventProcessor.getInstance().addListener(new EventListener<EventScriptLinkModifiedEvent>(){

            @Override
            public void notify(final EventScriptLinkModifiedEvent e, EventListenerContext ctx) {
                new Thread("event-script-link-modified"){

                    @Override
                    public void run() {
                        NestedContext.push("script");
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"Script event link was modified. (Re)linking script...");
                        }
                        Connection con = Setup.getSetup().getDBConnectionFromPool();
                        try {
                            DynamicScriptEventListener.addOne(e.getEventScriptLink(), logging, timeout, con, local, true);
                        }
                        catch (Exception ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                        finally {
                            NestedContext.pop();
                            ServerUtils.closeConnection(con);
                        }
                    }
                }.start();
            }
        }, EventScriptLinkModifiedEvent.class);
        EventProcessor.getInstance().addListener(new EventListener<EventScriptLinkDeletedEvent>(){

            @Override
            public void notify(final EventScriptLinkDeletedEvent e, EventListenerContext ctx) throws BGException {
                new Thread("event-script-link-deleted"){

                    @Override
                    public void run() {
                        NestedContext.push("script");
                        if (logger.isInfoEnabled()) {
                            logger.info((Object)"Script event function  was deleted.");
                        }
                        Connection con = Setup.getSetup().getDBConnectionFromPool();
                        try {
                            DynamicScriptEventListener.removeOne(e.getEventScriptLinkId(), con, local);
                        }
                        catch (BGException ex) {
                            logger.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                        finally {
                            NestedContext.pop();
                            ServerUtils.closeConnection(con);
                        }
                    }
                }.start();
            }
        }, EventScriptLinkDeletedEvent.class);
        NestedContext.push("script");
        logger.info((Object)"Starting DynamicScriptEventListener...");
        ConnectionSet set = null;
        try {
            set = ConnectionSet.newInstance(Setup.getSetup(), true);
            ServerContext ctx = new ServerContext(Setup.getSetup(), set, 0, 0);
            EventScriptService scriptWs = ServiceFactory.newService(ctx, EventScriptService.class, 0);
            List<EventScriptLink> links = scriptWs.getEventLinks();
            for (EventScriptLink link : links) {
                try {
                    DynamicScriptEventListener.addOne(link, logging, timeout, set.getConnection(), local, false);
                }
                catch (ClassNotFoundException ex) {
                    logger.error((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            ScriptEventListener.updateEmptyListener(EventProcessor.getInstance(), set.getConnection(), local);
        }
        catch (BGException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            set.recycle();
            NestedContext.pop();
        }
    }

    private static final void addOne(EventScriptLink link, boolean logging, int timeout, Connection con, boolean local, boolean updateEmpty) throws BGException, ClassNotFoundException, URISyntaxException {
        String[] split = link.getEventKey().split("_");
        URI eventURI = new URI(split[1]);
        String event = eventURI.getPath();
        String query = eventURI.getQuery();
        Class<?> eventClazz = DynamicScriptEventListener.getEventClassByName(event);
        if (eventClazz != null) {
            Class<Event> clazz = eventClazz.asSubclass(Event.class);
            if (local && !LocalEvent.class.isAssignableFrom(clazz)) {
                return;
            }
            DynamicScriptEventListener listener = null;
            listener = timeout >= 0 ? new ThreadedScriptEventListener(link, logging, timeout) : new DynamicScriptEventListener(link, logging);
            int moduleId = split[0].startsWith("p") ? -1 : Utils.parseInt(split[0]);
            int pluginId = split[0].startsWith("p") ? Utils.parseInt(split[0].substring(1)) : -1;
            EventProcessor ep = EventProcessor.getInstance();
            ep.removeListener(listener);
            ep.updateListener(listener, clazz, moduleId, pluginId, query);
            if (updateEmpty) {
                ScriptEventListener.updateEmptyListener(ep, con, local);
            }
        }
    }

    private static Class<?> getEventClassByName(String event) {
        Class<?> eventClazz = null;
        try {
            eventClazz = Class.forName(event);
        }
        catch (ClassNotFoundException e) {
            try {
                eventClazz = DynamicClassManager.getInstance().loadClass(event);
            }
            catch (BGException ex) {
                logger.warn((Object)(event + " not found."));
            }
        }
        return eventClazz;
    }

    private static final void removeOne(int linkId, Connection con, boolean local) throws BGException {
        DummyDynamicScriptEventListener listener = new DummyDynamicScriptEventListener(linkId);
        EventProcessor ep = EventProcessor.getInstance();
        ep.removeListener(listener);
        ScriptEventListener.updateEmptyListener(ep, con, local);
    }

    private static class DummyDynamicScriptEventListener
    extends DynamicScriptEventListener {
        public DummyDynamicScriptEventListener(int id) throws BGException {
            super(DummyDynamicScriptEventListener.getLink(id), false);
        }

        static EventScriptLink getLink(int id) {
            EventScriptLink link = new EventScriptLink();
            link.setId(id);
            return link;
        }
    }

    public static final class ThreadedScriptEventListener
    extends DynamicScriptEventListener {
        private static final ExecutorService executorService = Executors.newCachedThreadPool(new WorkerThreadFactory("dyn-clss-evnt-lstnr", null, null));
        private final long seconds;

        public ThreadedScriptEventListener(EventScriptLink function, boolean logProcess, int timeoutSeconds) throws BGException {
            super(function, logProcess);
            this.seconds = timeoutSeconds;
        }

        @Override
        protected void runScriptImpl(final EventListenerContext context, final ConnectionSet set, final Event event, final PrintStream outPrintStream, final PrintStream errPrintStream) throws Exception {
            final Subject subject = Subject.getSubject(AccessController.getContext());
            final AtomicReference thread = new AtomicReference();
            Future<Object> future = executorService.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    thread.set(Thread.currentThread());
                    Object parentContext = ThreadContext.get();
                    ThreadContext.set(context);
                    try {
                        if (subject != null) {
                            Object object = Subject.doAs(subject, new PrivilegedExceptionAction<Object>(){

                                @Override
                                public Object run() throws Exception {
                                    ThreadedScriptEventListener.super.runScriptImpl(context, set, event, outPrintStream, errPrintStream);
                                    return null;
                                }
                            });
                            return object;
                        }
                        ThreadedScriptEventListener.super.runScriptImpl(context, set, event, outPrintStream, errPrintStream);
                        Object var2_3 = null;
                        return var2_3;
                    }
                    finally {
                        ThreadContext.set(parentContext);
                    }
                }
            });
            try {
                future.get(this.seconds, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                e.setStackTrace(((Thread)thread.get()).getStackTrace());
                future.cancel(true);
                ((Thread)thread.get()).stop();
                throw new ExecutionException("The script execution took more than " + this.seconds + " seconds and was interrupted!", e);
            }
        }
    }
}

