/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event.events.system;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.bgbilling.kernel.event.LocalEvent;
import ru.bitel.common.TimeUtils;

public class ContractWrapEvent
extends LocalEvent {
    private int toContractId;
    private Date dateClose;
    private Date dateOpen;
    private boolean check;
    private String error;
    private Map<Integer, Integer> objectMap = new HashMap<Integer, Integer>();
    private Map<Integer, Map<Integer, Integer>> moduleEntityMap = new HashMap<Integer, Map<Integer, Integer>>();

    public ContractWrapEvent(int userId, int cid, int cidTo, Date dateClose, Date dateOpen, boolean check) {
        super(0, cid, userId);
        this.toContractId = cidTo;
        this.dateClose = dateClose;
        this.dateOpen = dateOpen;
        this.check = check;
    }

    public String getError() {
        return this.error;
    }

    public void setError(String error) {
        this.error = error;
    }

    public Date getDateOpen() {
        return this.dateOpen;
    }

    public boolean isCheck() {
        return this.check;
    }

    public Date getDateClose() {
        return this.dateClose;
    }

    public void setDateClose(Date dateClose) {
        this.dateClose = dateClose;
    }

    public int getToContractId() {
        return this.toContractId;
    }

    public Map<Integer, Integer> getObjectMap() {
        return this.objectMap;
    }

    public void addToEntityMap(int mid, int oldEntityId, int newEntityId) {
        Map<Integer, Integer> moduleMap = this.moduleEntityMap.get(mid);
        if (moduleMap == null) {
            moduleMap = new HashMap<Integer, Integer>();
            this.moduleEntityMap.put(mid, moduleMap);
        }
        moduleMap.put(oldEntityId, newEntityId);
    }

    public int getNewEntityId(int mid, int oldEntityId) {
        Integer result = null;
        Map<Integer, Integer> moduleMap = this.moduleEntityMap.get(mid);
        if (moduleMap != null) {
            result = moduleMap.get(oldEntityId);
        }
        return result == null ? 0 : result;
    }

    public boolean checkNeedWrap(Date date2) {
        return date2 == null || TimeUtils.dateBefore(this.dateClose, date2);
    }

    public void relinkEntry(Connection con, String tableName, int mid, int oldEid, int newEid) throws SQLException {
        String query = "UPDATE " + tableName + " SET eid=? WHERE cid=? AND emid=? AND eid=?";
        PreparedStatement psUpdate = con.prepareStatement(query);
        psUpdate.setInt(1, newEid);
        psUpdate.setInt(2, this.toContractId);
        psUpdate.setInt(3, mid);
        psUpdate.setInt(4, oldEid);
        psUpdate.executeUpdate();
    }

    public Map<Integer, Map<Integer, Integer>> getModuleEntityMap() {
        return this.moduleEntityMap;
    }
}

