/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean.parameter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.parameter.ContractParameterListItem;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractParameterListItemDao
extends AbstractIdDao<ContractParameterListItem>
implements Directory<ContractParameterListItem> {
    private int parameterTypeId;

    public ContractParameterListItemDao(Connection con, int parameterTypeId) {
        super(con, 0, "contract_parameter_type_7_values");
        this.parameterTypeId = parameterTypeId;
    }

    @Override
    protected ContractParameterListItem getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractParameterListItem result = new ContractParameterListItem();
        result.setId(rs.getInt("id"));
        result.setTitle(rs.getString("title"));
        return result;
    }

    @Override
    protected void updateImpl(ContractParameterListItem b2) throws BGException, SQLException {
        String query = null;
        PreparedStatement ps = null;
        if (b2.getId() <= 0) {
            query = "INSERT INTO " + this.tableName + " (title) VALUES (?)";
            ps = this.con.prepareStatement(query, 1);
        } else {
            query = "UPDATE " + this.tableName + " SET title=? WHERE id=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(2, b2.getId());
        }
        ps.setString(1, b2.getTitle());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    protected int deleteImpl(int id) throws BGException, SQLException {
        PreparedStatement ps = this.con.prepareStatement("SELECT cid FROM contract_parameter_type_7_values WHERE pid=? LIMIT 1");
        ps.setInt(1, id);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            rs.close();
            ps.close();
            throw new BGException("\u041d\u0435\u043b\u044c\u0437\u044f \u0443\u0434\u0430\u043b\u0438\u0442\u044c \u0434\u0430\u043d\u043d\u043e\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435, \u0442.\u043a. \u043e\u043d\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f.", "list.value.deleteError.isUsed");
        }
        rs.close();
        ps.close();
        int result = super.deleteImpl(id);
        return result;
    }

    @Override
    public void recycle() throws BGException {
        super.recycle();
    }

    @Override
    public ContractParameterListItem get(String title) throws BGException {
        return (ContractParameterListItem)super.get("title=?", title);
    }

    @Override
    public List<ContractParameterListItem> list() throws BGException {
        if (this.parameterTypeId > 0) {
            return super.list("pid=?", null, this.parameterTypeId);
        }
        return super.list(null, null, new Object[0]);
    }
}

