/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.security.server;

import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ru.bitel.bgbilling.kernel.container.security.server.HttpAction;
import ru.bitel.bgbilling.kernel.container.security.server.ModuleAction;
import ru.bitel.bgbilling.kernel.container.security.server.ServiceAction;

class ModuleInfo {
    final Map<Integer, ModuleAction> moduleActionMap;
    private final List<HttpAction> httpActionList;
    private final Map<String, List<ServiceAction>> serviceActionMap;

    public ModuleInfo(Map<Integer, ModuleAction> moduleActionMap, List<HttpAction> webActionList, Map<String, List<ServiceAction>> serviceActionMap) {
        this.moduleActionMap = moduleActionMap;
        this.httpActionList = webActionList;
        this.serviceActionMap = serviceActionMap;
    }

    ModuleAction findAction(String service, String operation, Map<String, Object> args) {
        List<ServiceAction> actions = this.serviceActionMap.get(service);
        if (actions == null) {
            return null;
        }
        int size = actions.size();
        for (int i = 0; i < size; ++i) {
            ServiceAction action = actions.get(i);
            if (!action.isCoincide(operation, args)) continue;
            return action;
        }
        return null;
    }

    public ModuleAction findAction(HttpServletRequest request) {
        for (HttpAction action : this.httpActionList) {
            if (!action.isCoincide(request)) continue;
            return action;
        }
        return null;
    }

    public ModuleAction findAction(Map<String, String> requestMap) {
        for (HttpAction action : this.httpActionList) {
            if (!action.isCoincide(requestMap)) continue;
            return action;
        }
        return null;
    }
}

