/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.messages4users.server;

import java.sql.Connection;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.messages4users.common.bean.Message;
import ru.bitel.bgbilling.kernel.admin.messages4users.server.dao.MessageForUsersDao;
import ru.bitel.bgbilling.kernel.module.common.bean.User;
import ru.bitel.bgbilling.kernel.module.server.bean.UserManager;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.model.IdTitle;

public class MessageForUsersManager {
    private Connection con = null;

    public MessageForUsersManager(Connection con) {
        this.con = con;
    }

    public List<Message> getMessageList() throws BGException {
        return new MessageForUsersDao(this.con).getMessageList();
    }

    public List<Message> getMessageList(int lastMessageId, int userId) throws BGException {
        return new MessageForUsersDao(this.con).getMessageList(lastMessageId, userId);
    }

    @Deprecated
    public List<Message> getMessageList(int lastMessageId, String userId) throws BGException {
        return new MessageForUsersDao(this.con).getMessageList(lastMessageId, userId);
    }

    public List<IdTitle> getGroupList() throws BGException {
        return new MessageForUsersDao(this.con).getGroupList();
    }

    public void updateMessage(Message message) throws BGException {
        new MessageForUsersDao(this.con).update(message);
    }

    public int getLastMessageId(int userId) throws BGException {
        User user = UserMap.getUser(userId);
        String user_config = user.getConfig();
        Preferences userConfig = new Preferences(user_config, "\r\n");
        int lastMessageId = userConfig.getInt("last_message_id", -1);
        if (lastMessageId == -1) {
            userConfig.set("last_message_id", "0");
            user_config = userConfig.toString();
            user.setConfig(user_config);
            UserManager um = new UserManager(this.con);
            um.update(user);
            lastMessageId = 0;
            UserMap.initUserMap(this.con);
        }
        return lastMessageId;
    }

    public void deleteMessage(int messageId) {
        new MessageForUsersDao(this.con).deleteMessage(messageId);
    }

    public void updateUserConfig(int lastMessageId, int userId) throws BGException {
        User user = UserMap.getUser(userId);
        String user_config = user.getConfig();
        Preferences userConfig = new Preferences(user_config, "\r\n");
        userConfig.set("last_message_id", String.valueOf(lastMessageId));
        user_config = userConfig.toString();
        user.setConfig(user_config);
        UserManager um = new UserManager(this.con);
        um.update(user);
        UserMap.initUserMap(this.con);
    }

    public Set<Integer> getUsersInGroup(Set<Integer> groups) {
        return new MessageForUsersDao(this.con).getUsersInGroup(groups);
    }
}

