/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.util.mikrotik;

import bitel.billing.server.util.mikrotik.Hasher;
import bitel.billing.server.util.mikrotik.ReadCommand;
import bitel.billing.server.util.mikrotik.WriteCommand;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import ru.bitel.common.Utils;

public class ApiConn {
    private Socket sock = null;
    private DataOutputStream out = null;
    private DataInputStream in = null;
    private String ipAddress;
    private int ipPort;
    private boolean connected = false;
    private ReadCommand readCommand = null;
    private WriteCommand writeCommand = null;
    private Thread listener = null;
    LinkedBlockingQueue queue = new LinkedBlockingQueue(40);
    protected String sourceHost = null;
    protected int sourcePort = 0;

    public ApiConn(String ipAddress, int ipPort) {
        this(ipAddress, ipPort, null, 0);
    }

    public ApiConn(String ipAddress, int ipPort, String sourceHost, int sourcePort) {
        this.ipAddress = ipAddress;
        this.ipPort = ipPort;
        this.sourceHost = sourceHost;
        this.sourcePort = sourcePort;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void disconnect() throws IOException {
        this.listener.interrupt();
        this.sock.close();
    }

    private void listen() {
        if (this.isConnected()) {
            if (this.readCommand == null) {
                this.readCommand = new ReadCommand(this.in, this.queue);
            }
            this.listener = new Thread(this.readCommand);
            this.listener.setDaemon(true);
            this.listener.setName("listener");
            this.listener.start();
        }
    }

    public InetAddress getIpAddress() {
        return this.sock == null ? null : this.sock.getInetAddress();
    }

    public InetAddress getLocalIpAddress() {
        return this.sock == null ? null : this.sock.getLocalAddress();
    }

    public int getPort() {
        return this.sock == null ? null : Integer.valueOf(this.sock.getPort());
    }

    public int getLocalPort() {
        return this.sock == null ? null : Integer.valueOf(this.sock.getLocalPort());
    }

    public boolean sendCommand(String s) {
        return this.writeCommand.setCommand(s).runCommand();
    }

    public boolean runCommand() {
        return this.writeCommand.runCommand();
    }

    public String getData() throws InterruptedException {
        String s = (String)this.queue.take();
        return s;
    }

    public String getCommand() {
        return this.writeCommand.getCommand();
    }

    public boolean login(String name, char[] password) {
        String[] tmp;
        this.sendCommand("/login");
        String s = "a";
        try {
            s = this.getData();
        }
        catch (InterruptedException ex) {
            return false;
        }
        if (!s.contains("!trap") && s.length() > 4 && (tmp = s.trim().split("\n")).length > 1) {
            tmp = tmp[1].split("=ret=");
            s = "";
            String transition = tmp[tmp.length - 1];
            String chal = "";
            chal = Hasher.hexStrToStr("00") + new String(password) + Hasher.hexStrToStr(transition);
            chal = Hasher.hashMD5(chal);
            String m = "/login\n=name=" + name + "\n=response=00" + chal;
            if (!this.sendCommand(m)) {
                return false;
            }
            try {
                s = this.getData();
            }
            catch (InterruptedException ex) {
                return false;
            }
            if (s.contains("!done") && !s.contains("!trap")) {
                return true;
            }
        }
        return false;
    }

    public void connect() throws IOException {
        this.connected = false;
        InetAddress ia = InetAddress.getByName(this.ipAddress);
        if (this.sourcePort > 0 || Utils.notBlankString(this.sourceHost)) {
            InetAddress sourceHostInet = null;
            if (this.sourceHost != null) {
                sourceHostInet = InetAddress.getByName(this.sourceHost);
            }
            this.sock = new Socket(ia, this.ipPort, sourceHostInet, this.sourcePort <= 0 ? 0 : this.sourcePort);
        } else {
            this.sock = new Socket(ia, this.ipPort);
        }
        this.in = new DataInputStream(this.sock.getInputStream());
        this.out = new DataOutputStream(this.sock.getOutputStream());
        this.connected = true;
        this.readCommand = new ReadCommand(this.in, this.queue);
        this.writeCommand = new WriteCommand(this.out);
        this.listen();
    }
}

