/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.task;

import bitel.billing.server.task.bean.RunTask;
import bitel.billing.server.task.bean.RunTaskDataManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class TaskRunProcessor
extends Thread {
    private static final Logger log = Logger.getLogger(TaskRunProcessor.class);
    private Setup setup;
    private static final String THREAD_COUNT_KEY = "scheduler.nonperiodic.thread.count";
    private ThreadPoolExecutor pool;

    public TaskRunProcessor(Setup setup) {
        this.setup = setup;
        int schedulerThreadCount = setup.getInt(THREAD_COUNT_KEY, 5);
        this.pool = new ThreadPoolExecutor(schedulerThreadCount, schedulerThreadCount, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        this.clearExecutingHardTasks();
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Connection con = this.setup.getDBConnectionFromPool();
            RunTaskDataManager rtm = new RunTaskDataManager(con);
            List<RunTask> tasks = null;
            try {
                tasks = rtm.getNextTasks();
                for (RunTask task : tasks) {
                    task.init(this.setup);
                    log.info((Object)("Running Task: " + task));
                    this.pool.execute(task);
                }
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                ServerUtils.closeConnection(con);
            }
            try {
                TaskRunProcessor.sleep(5000L);
                continue;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void clearExecutingHardTasks() {
        Connection con = this.setup.getDBConnectionFromPool();
        try {
            PreparedStatement ps = con.prepareStatement("DELETE FROM scheduled_task_run WHERE executed=1");
            ps.executeUpdate();
            ps.close();
        }
        catch (Exception ex) {
            log.error((Object)"error clear executing hard tasks", (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    public String getStatusString() {
        StringBuffer result = new StringBuffer(50);
        result.append("Urgent tasks executed: " + this.pool.getCompletedTaskCount() + "; ");
        result.append("active: " + this.pool.getActiveCount());
        result.append("\n");
        return result.toString();
    }
}

