/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff.voice.calc;

import bitel.billing.server.tariff.voice.bean.GeographicCode;
import bitel.billing.server.tariff.voice.bean.GeographicCodeManager;
import bitel.billing.server.tariff.voice.calc.FindItem;
import bitel.billing.server.tariff.voice.calc.ZoneDestFindRequest;
import java.sql.Connection;
import java.util.List;
import ru.bitel.common.Utils;

public class CodeFinder {
    private FindItem rootItem = new FindItem();

    public CodeFinder(Connection con, int mid) {
        this.load(con, mid);
    }

    private void load(Connection con, int mid) {
        GeographicCodeManager manager = new GeographicCodeManager(con, mid);
        GeographicCode root = manager.getRootCode();
        this.loadSubItems(root, this.rootItem, 1);
    }

    private void loadSubItems(GeographicCode code, FindItem root, int level) {
        List<GeographicCode> subList = code.getSubList();
        if (subList != null) {
            for (GeographicCode childCode : subList) {
                FindItem currentItem = root;
                String prefix = childCode.getCode();
                int size = prefix.length();
                for (int i = 0; i < size; ++i) {
                    int digit = Utils.parseInt(prefix.substring(i, i + 1));
                    FindItem item = currentItem.getSubItem(digit);
                    if (item == null) {
                        item = new FindItem();
                        currentItem.addSubItem(digit, item);
                    }
                    currentItem = item;
                    if (i != size - 1) continue;
                    currentItem.setId(childCode.getDestId());
                    currentItem.setLevel(level);
                    currentItem.setStartLevel(childCode.getStartLevel());
                    currentItem.setEndLevel(childCode.getEndLevel());
                }
                this.loadSubItems(childCode, root, level + 1);
            }
        }
    }

    public void find(ZoneDestFindRequest req) {
        req.currentPosition = 0;
        req.whatSet = 1;
        this.rootItem.find(req);
    }
}

