/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import bitel.billing.server.tariff.bean.TimeLimitSet;
import bitel.billing.server.tariff.bean.TimeTypeCache;
import java.util.Calendar;
import java.util.Map;
import ru.bitel.common.Utils;

public class TimeTypeFilterTariffTreeNode
extends DefaultTariffTreeNode {
    private int timeType;

    @Override
    public void init(String data, int deep, int nodeId) {
        super.init(data, deep, nodeId);
        Map<String, String> dataHash = this.getDataInHash();
        this.timeType = Utils.parseInt(dataHash.get("time_type"));
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        String paramName = "t_f_a_" + this._parent.getId();
        String timeFilterAccepted = (String)request.getResponseParam(paramName);
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (timeFilterAccepted == null) {
            Calendar time = (Calendar)request.getRequestParam("time");
            TimeLimitSet limitSet = TimeTypeCache.getLimitMap().get(this.timeType);
            if (time != null && limitSet != null && limitSet.checkTime(time)) {
                this.processForChilds(request);
                request.setResponseParam(paramName, "true");
            }
        }
    }
}

