/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.Map;
import ru.bitel.common.Utils;

public class ServiceCostTariffTreeNode
extends DefaultTariffTreeNode {
    private Float cost;
    private Long divisor;
    private Integer costType;

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> data = this.getDataInHash();
        String cost = data.get("cost");
        String col = data.get("col");
        String type = data.get("type");
        if (cost != null && col != null && type != null) {
            int costType;
            String _costType;
            int colInt = Utils.parseInt(col, 0);
            int typeInt = Utils.parseInt(type, 0);
            float costF = Utils.parseFloat(cost, 0.0f);
            if (colInt >= 0) {
                this.cost = new Float(costF);
                this.divisor = new Long(this.getServiceAmount(typeInt, colInt));
            }
            if ((_costType = data.get("costType")) != null && (costType = Utils.parseInt(_costType, 0)) > 0) {
                this.costType = new Integer(costType);
            }
        }
    }

    @Override
    public void processRequest(TariffRequest request) {
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("calculate") && this.cost != null && this.divisor != null) {
            request.setResponseParam("divisor", this.divisor);
            request.setResponseParam("cost", this.cost);
            if (this.costType != null) {
                request.setResponseParam("costType", this.costType);
            }
            request.setAccepted();
        }
    }
}

