/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import ru.bitel.common.TimeUtils;

public class PeriodTariffTreeNode
extends DefaultTariffTreeNode {
    private Calendar date1;
    private Calendar date2;
    protected boolean needCheckPeriodOnReset = false;

    @Override
    public void init(String dataStr, int deep, int nodeID) {
        super.init(dataStr, deep, nodeID);
        Map<String, String> map = this.getDataInHash();
        this.date1 = TimeUtils.parseCalendar(map.get("date1"), "dd.MM.yyyy");
        this.date2 = TimeUtils.parseCalendar(map.get("date2"), "dd.MM.yyyy");
    }

    @Override
    public void processRequest(TariffRequest request) {
        Object dateObject = request.getRequestParam("time");
        Calendar date = dateObject instanceof Calendar ? (Calendar)dateObject : TimeUtils.convertDateToCalendar((Date)dateObject);
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            if (!this.needCheckPeriodOnReset || date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq(this.date1, date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq(date, this.date2))) {
                this.processForChilds(request);
            }
        } else if (date != null && (this.date1 == null || TimeUtils.dateBeforeOrEq(this.date1, date)) && (this.date2 == null || TimeUtils.dateBeforeOrEq(date, this.date2))) {
            this.processForChilds(request);
        } else {
            request.addHistoryMsg("Not accepted on period 2 date=" + TimeUtils.formatDate(date) + "; date1=" + TimeUtils.formatDate(this.date1) + "; date2=" + TimeUtils.formatDate(this.date2) + "\n");
        }
    }
}

