/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.installer;

import bitel.billing.server.installer.ExecuteSQL;
import bitel.billing.server.installer.InstallationCall;
import bitel.billing.server.installer.ModuleInf;
import bitel.billing.server.installer.PutFile;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.bean.ModuleManager;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;

public class InstallerModule {
    protected static final String MESSAGE_ERROR = "ERROR";
    protected static final String MESSAGE_OK = "OK";
    private String init;
    private String uninstall;

    public InstallerModule(File zip, List<String> replacedFiles) {
        this(zip, replacedFiles, false);
    }

    public InstallerModule(File zip, List<String> replacedFiles, boolean onlyCopyFiles) {
        ModuleInf mi = InstallerModule.getModuleInf(zip);
        if (mi != null && !mi.hasErrors()) {
            boolean result = true;
            if (result) {
                result = this.takeClientZipAndInit(zip, mi.getName());
                System.out.println("Extract data => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                result = this.updateBase(mi);
                System.out.println("Base update => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                result = this.initModules(mi);
                System.out.println("Module Instance init => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result && !onlyCopyFiles) {
                this.executeCalls(mi, Setup.getSetup(), zip, replacedFiles);
                System.out.println("Execute calls => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result) {
                result = this.copyFiles(zip, replacedFiles, mi);
                System.out.println("File copy => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (result) {
                result = InstallerModule.removeLibs(mi);
                System.out.println("Remove libs => " + (result ? MESSAGE_OK : MESSAGE_ERROR));
            }
            if (!result) {
                System.out.println("Module was not installed.");
            } else {
                System.out.println("Module " + mi.getName() + " was successfull installed!");
                System.out.println("Please, restart BGBilling server.");
            }
        }
    }

    private static boolean removeLibs(ModuleInf mi) {
        if (!Utils.isEmptyString(mi.getLibsRemove())) {
            String[] removeList;
            for (String lib : removeList = mi.getLibsRemove().split(",")) {
                File file = new File("lib/ext/" + lib);
                if (!file.exists()) continue;
                System.out.println("Removing library  " + file.getAbsolutePath());
                file.delete();
            }
        }
        return true;
    }

    private static ModuleInf getModuleInf(File zip) {
        ModuleInf mi = null;
        try {
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().equals("module.xml")) continue;
                mi = new ModuleInf(XMLUtils.parseDocument(Utils.readByBlock(zis)));
                break;
            }
            if (mi == null) {
                System.err.println("Error: module.xml not found in zip");
            }
            fis.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mi;
    }

    private boolean takeClientZipAndInit(File zip, String name) {
        boolean result = false;
        try {
            FileInputStream fis = new FileInputStream(zip);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().equals("client.zip")) {
                    File clientJarDir = new File("client.jars");
                    if (!clientJarDir.exists()) {
                        clientJarDir.mkdir();
                    }
                    File nameJarDir = new File(clientJarDir, name);
                    ServerUtils.deleteDir(nameJarDir);
                    nameJarDir.mkdir();
                    ZipInputStream clientZipInputStream = new ZipInputStream(new ByteArrayInputStream(Utils.readByBlock(zis)));
                    ZipEntry clientZipEntry = null;
                    while ((clientZipEntry = clientZipInputStream.getNextEntry()) != null) {
                        if (!clientZipEntry.getName().endsWith(".jar")) continue;
                        File clientJar = new File(nameJarDir, clientZipEntry.getName());
                        FileOutputStream fos = new FileOutputStream(clientJar);
                        fos.write(Utils.readByBlock(clientZipInputStream));
                        fos.close();
                    }
                    clientZipInputStream.close();
                    continue;
                }
                if (ze.getName().equals("init")) {
                    this.init = new String(Utils.readByBlock(zis), "UTF-8");
                    continue;
                }
                if (!ze.getName().equals("uninstall")) continue;
                this.uninstall = new String(Utils.readByBlock(zis), "UTF-8");
            }
            fis.close();
            System.out.println("Data extract finished...");
            result = true;
        }
        catch (Exception ex) {
            System.err.println("Data extract error...");
            ex.printStackTrace();
        }
        return result;
    }

    private boolean copyFiles(File zip, List<String> replacedFiles, ModuleInf mi) {
        boolean result = false;
        String serverZip = "server.zip";
        File libDir = new File("lib/app");
        File xslDir = new File("webroot/xsl");
        String libExtPath = new File("lib/ext").getAbsolutePath();
        if (libDir.exists() && libDir.isDirectory() && xslDir.exists() && xslDir.isDirectory()) {
            try {
                String libPath = libDir.getAbsolutePath();
                FileInputStream fis = new FileInputStream(zip);
                ZipInputStream zis = new ZipInputStream(fis);
                ZipEntry ze = null;
                while ((ze = zis.getNextEntry()) != null) {
                    if (ze.getName().equals(serverZip)) {
                        byte[] serv_zip = Utils.readByBlock(zis);
                        ZipInputStream jarsZip = new ZipInputStream(new ByteArrayInputStream(serv_zip));
                        ZipEntry jarE = null;
                        while ((jarE = jarsZip.getNextEntry()) != null) {
                            FileOutputStream fos = null;
                            fos = "ext".equals(mi.getLibType()) ? new FileOutputStream(libExtPath + File.separator + jarE.getName()) : new FileOutputStream(libPath + File.separator + jarE.getName());
                            byte[] jarFile = Utils.readByBlock(jarsZip);
                            fos.write(jarFile);
                            fos.close();
                        }
                        continue;
                    }
                    if (!ze.getName().endsWith(".xsl") || ze.getName().contains("/")) continue;
                    PutFile putFile = new PutFile();
                    putFile.setReplacedList(replacedFiles);
                    putFile.call(Setup.getSetup(), zip, ze.getName() + ":webroot/xsl");
                }
                fis.close();
                System.out.println("File's copy finished...");
                result = true;
            }
            catch (Exception ex) {
                System.err.println("File's copy error.. ");
                ex.printStackTrace();
            }
        } else {
            System.err.println("Can't find xsl or lib path!");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initModules(ModuleInf mi) {
        boolean result = false;
        Connection con = Setup.getSetup().getDBConnectionFromPool();
        try {
            if (mi.getType().equals("module")) {
                System.out.println("Reinit module instanses");
                for (BGModule module : (ArrayList)new ModuleManager(con).getModules(mi.getName())) {
                    System.out.println("REINIT module => " + module.getId());
                    InstallerModule.initModule(con, mi.getName(), module.getId());
                }
            } else if (mi.getType().equals("plugin")) {
                System.out.println("Reinit plugin id=" + mi.getPluginId());
                InstallerModule.initModule(con, mi.getName(), mi.getPluginId());
            }
            result = true;
        }
        catch (Exception e) {
            System.err.println("Error of module reinit...");
            e.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateBase(ModuleInf mi) {
        boolean result = false;
        Connection con = null;
        try {
            con = Setup.getSetup().getDBConnection();
            String query = null;
            PreparedStatement ps = null;
            int recordId = 0;
            query = "SELECT id FROM installed_modules WHERE name=?";
            ps = con.prepareStatement(query);
            ps.setString(1, mi.getName());
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                recordId = rs.getInt(1);
            }
            rs.close();
            ps.close();
            if (recordId > 0) {
                query = "UPDATE installed_modules SET version=?, title=?, client_zip=?, init=?, uninstall=?, pack_server=?, pack_client=? WHERE name=?";
                ps = con.prepareStatement(query);
                ps.setString(1, "");
                ps.setString(2, mi.getTitle());
                ps.setBytes(3, new byte[0]);
                ps.setString(4, this.init);
                ps.setString(5, this.uninstall);
                ps.setString(6, mi.getPackageServer());
                ps.setString(7, mi.getPackageClient());
                ps.setString(8, mi.getName());
                ps.executeUpdate();
                ps.close();
            } else {
                query = "INSERT INTO installed_modules SET name=?, title=?, version=?, pack_server=?, pack_client=?, type=?, client_zip=?, init=?, uninstall=?";
                ps = con.prepareStatement(query, 1);
                ps.setString(1, mi.getName());
                ps.setString(2, mi.getTitle());
                ps.setString(3, "");
                ps.setString(4, mi.getPackageServer());
                ps.setString(5, mi.getPackageClient());
                ps.setString(6, mi.getType());
                ps.setBytes(7, new byte[0]);
                ps.setString(8, this.init);
                ps.setString(9, this.uninstall);
                ps.executeUpdate();
                recordId = ServerUtils.lastInsertId(ps);
                ps.close();
            }
            mi.setPluginId(recordId);
            System.out.println("Database updated...");
            ServerUtils.removeSetupValue(con, "20");
            query = "INSERT INTO setup ( id, value ) VALUES ( 20, 1 )";
            con.prepareStatement(query).executeUpdate();
            System.out.println("Install ticket inserted..");
            result = true;
        }
        catch (Exception ex) {
            System.err.println("Error of updating database.");
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
        return result;
    }

    private void executeCalls(ModuleInf mi, Setup setup, File zip, List<String> replacedFiles) {
        List<String[]> calls = mi.getCalls();
        for (String[] class_param : calls) {
            String callClass = class_param[0];
            String param = class_param[1];
            System.out.println("Executing call " + callClass + "; param: " + param);
            boolean result = false;
            try {
                StringBuffer fullClassName = new StringBuffer("bitel.billing.server.installer.");
                fullClassName.append(callClass);
                InstallationCall call = (InstallationCall)Class.forName(fullClassName.toString()).newInstance();
                if (call instanceof PutFile) {
                    ((PutFile)call).setReplacedList(replacedFiles);
                } else if (call instanceof ExecuteSQL) {
                    int id = 0;
                    if ("plugin".equals(mi.getType()) || "module".equals(mi.getType())) {
                        id = mi.getPluginId();
                    }
                    ((ExecuteSQL)call).setId(String.valueOf(id));
                }
                call.call(setup, zip, param);
                result = true;
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
            System.out.println("Result => " + result);
        }
    }

    public static void uninstallModuleInstance(Connection con, String name, int mid) {
        try {
            String query = "SELECT uninstall FROM installed_modules WHERE name=?";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            String uninstall = null;
            if (rs.next() && (uninstall = rs.getString(1)) != null) {
                String[] queries = uninstall.split(";\r*\n*");
                int size = queries.length;
                Statement st = con.createStatement();
                for (int i = 0; i < size; ++i) {
                    queries[i] = queries[i].trim();
                    if (queries[i].length() <= 0) continue;
                    query = queries[i].replaceAll("\\$mid", String.valueOf(mid));
                    try {
                        st.executeUpdate(query);
                        continue;
                    }
                    catch (Exception ex) {
                        System.err.println(ex.getMessage());
                    }
                }
                st.close();
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void initModule(Connection con, String name, int mid) {
        try {
            String query = "SELECT init, type FROM installed_modules WHERE name=? ";
            PreparedStatement ps = con.prepareStatement(query);
            ps.setString(1, name);
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                boolean isModule = "module".equals(rs.getString(2));
                String[] lines = rs.getString(1).split(";\r*\n*");
                for (int i = 0; i < lines.length; ++i) {
                    lines[i] = lines[i].trim();
                    if (lines[i].length() <= 0) continue;
                    lines[i] = lines[i].replaceAll("\\$mid", String.valueOf(mid));
                }
                String midStr = (isModule ? "m" : "") + mid;
                InstallerModule.executeSqlComands(con, lines, midStr);
            }
            rs.close();
            ps.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSqlComands(Connection con, String[] lines, String midStr) throws SQLException {
        List<String> hashes = InstallerModule.getQueryHashes(con, midStr);
        ArrayList<String> blockQueries = new ArrayList<String>();
        boolean blockStarted = false;
        boolean noHash = false;
        Statement st = con.createStatement();
        try {
            st.executeUpdate("SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i].trim();
                if (line.isEmpty()) continue;
                if (line.indexOf("#BLOCK#") >= 0) {
                    blockStarted = true;
                } else if (line.indexOf("#ENDB#") >= 0) {
                    blockStarted = false;
                    InstallerModule.tryExecuteBlock(con, blockQueries, hashes, st);
                    blockQueries.clear();
                } else if (line.indexOf("#NOHASH#") >= 0) {
                    noHash = true;
                } else if (line.indexOf("#ENDNO#") >= 0) {
                    noHash = false;
                }
                if (blockStarted) {
                    blockQueries.add(line);
                    continue;
                }
                if (noHash) {
                    try {
                        st.executeUpdate(line);
                    }
                    catch (SQLException ex) {
                        System.err.println("(" + ex.getErrorCode() + ") " + ex.getMessage());
                    }
                    continue;
                }
                String hash = InstallerModule.getHash(line);
                if (hashes.indexOf(hash) >= 0) continue;
                try {
                    st.executeUpdate(line);
                    hashes.add(hash);
                    continue;
                }
                catch (SQLException ex) {
                    hashes.add(hash);
                    System.err.println("(" + ex.getErrorCode() + ") " + ex.getMessage());
                }
            }
        }
        finally {
            st.executeUpdate("SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS");
            st.close();
        }
        InstallerModule.updateHashes(con, Utils.toString(hashes), midStr);
    }

    public static void tryExecuteBlock(Connection con, List<String> linesBlock, List<String> hashes, Statement st) {
        String hash = InstallerModule.getHash(Utils.toString(linesBlock));
        if (hashes.indexOf(hash) < 0) {
            for (String line : linesBlock) {
                try {
                    st.executeUpdate(line);
                    hashes.add(hash);
                }
                catch (SQLException ex) {
                    System.err.println("(" + ex.getErrorCode() + ") " + ex.getMessage());
                }
            }
        }
    }

    public static String getHash(String value) {
        return Utils.getDigest(value, "UTF-8");
    }

    public static List<String> getQueryHashes(Connection con, String mid) throws SQLException {
        List<String> result = new ArrayList<String>();
        if (!ServerUtils.tableExists(con, "sql_patches_history")) {
            InstallerModule.createSQLPatchesHistoryTable(con);
            return result;
        }
        String query = "SELECT versions FROM sql_patches_history WHERE mid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, mid);
        ResultSet rs = ps.executeQuery();
        if (rs.next()) {
            result = Utils.toList(rs.getString(1));
        }
        rs.close();
        ps.close();
        return result;
    }

    private static void createSQLPatchesHistoryTable(Connection con) throws SQLException {
        String sql = "CREATE TABLE  `sql_patches_history` (  `mid` varchar(10) NOT NULL,  `versions` text,  PRIMARY KEY  (`mid`) )";
        PreparedStatement ps = con.prepareStatement(sql);
        ps.executeUpdate();
        ps.close();
    }

    public static void updateHashes(Connection con, String versions, String mid) throws SQLException {
        String query = "UPDATE sql_patches_history SET versions=? WHERE mid=?";
        PreparedStatement ps = con.prepareStatement(query);
        ps.setString(1, versions);
        ps.setString(2, mid);
        if (ps.executeUpdate() == 0) {
            ps.close();
            query = "INSERT INTO sql_patches_history(versions, mid) VALUES (?,?)";
            ps = con.prepareStatement(query);
            ps.setString(1, versions);
            ps.setString(2, mid);
            ps.executeUpdate();
            ps.close();
        }
    }

    public static void replacedReport(List<String> replacedFiles) {
        if (replacedFiles.size() > 0) {
            System.out.println("REPLACED FILES:");
            for (String file : replacedFiles) {
                System.out.println(file);
            }
        }
    }

    public static void clearHashById(String hashid) {
        try {
            Connection con = Setup.getSetup().getDBConnectionFromPool();
            if (!ServerUtils.tableExists(con, "sql_patches_history")) {
                InstallerModule.createSQLPatchesHistoryTable(con);
                return;
            }
            String sql = "DELETE FROM sql_patches_history WHERE mid=?";
            PreparedStatement ps = con.prepareStatement(sql);
            ps.setString(1, hashid);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

