/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.bean;

import bitel.billing.server.contract.bean.CostSum;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import ru.bitel.common.Utils;

public class ServiceCostCache {
    private HashMap<String, CostSum> amounts = new HashMap(200, 100.0f);

    public synchronized void addAmount(CostSum value) {
        if (BigDecimal.ZERO.compareTo(value.cost) != 0) {
            String key = value.getKey();
            CostSum am = this.amounts.get(key);
            if (am == null) {
                am = value;
                this.amounts.put(key, am);
            } else {
                am.cost = am.cost.add(value.cost);
            }
        }
    }

    public Map<Integer, BigDecimal> getContractAccounts() {
        HashMap<Integer, BigDecimal> result = new HashMap<Integer, BigDecimal>();
        for (CostSum cs : this.amounts.values()) {
            BigDecimal currentAccount = Utils.maskNull((BigDecimal)result.get(cs.cid));
            currentAccount = currentAccount.add(Utils.roundBigDecimalSumm(cs.cost));
            result.put(cs.cid, currentAccount);
        }
        return result;
    }

    public CostSum getAmount(int cid, int sid) {
        CostSum value = new CostSum(cid, sid, BigDecimal.ZERO);
        return this.amounts.get(value.getKey());
    }

    public Collection<CostSum> getAmounts() {
        return this.amounts.values();
    }
}

