/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.logon.ContractLogonBase;
import bitel.billing.server.contract.logon.ContractLogonError;
import bitel.billing.server.contract.logon.ContractLogonOk;
import bitel.billing.server.contract.logon.LogonManager;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.model.SearchResult;

public class ActionWebContractLogonLog
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String logType = this.getParameter("logType", "ok");
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        LogonManager logonManager = new LogonManager(this.con);
        SearchResult<ContractLogonBase> searchResult = new SearchResult<ContractLogonBase>();
        searchResult.setPage(this.getPage());
        searchResult.setPeriod(this.getPeriod());
        if ("ok".equals(logType)) {
            Element row = null;
            logonManager.searchLogonOk(this.cid, searchResult);
            for (ContractLogonBase item : searchResult.getList()) {
                ContractLogonOk contractLogonOk = (ContractLogonOk)item;
                row = this.createElement(data, "row");
                row.setAttribute("ip", contractLogonOk.getRemoteIP());
                row.setAttribute("date", TimeUtils.format(contractLogonOk.getDateTime(), "dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("sessionId", contractLogonOk.getSessionId());
                row.setAttribute("passwordType", contractLogonOk.getPasswordType());
            }
        } else {
            Element row = null;
            logonManager.searchLogonError(this.cid, searchResult);
            for (ContractLogonBase item : searchResult.getList()) {
                ContractLogonError contractLogonError = (ContractLogonError)item;
                StringBuilder builder = new StringBuilder();
                builder.append("[");
                builder.append(contractLogonError.getErrorCode());
                builder.append("] ");
                builder.append(contractLogonError.getRequestData());
                row = this.createElement(data, "row");
                row.setAttribute("ip", contractLogonError.getRemoteIP());
                row.setAttribute("date", TimeUtils.format(contractLogonError.getDateTime(), "dd.MM.yyyy HH:mm:ss"));
                row.setAttribute("login", contractLogonError.getLogin());
                row.setAttribute("errorCode", builder.toString());
            }
        }
        this.setPageAttribute(table, searchResult.getPage());
    }
}

