/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.resource.action;

import bitel.billing.common.IPUtils;
import bitel.billing.server.admin.resource.action.base.ActionBase;
import bitel.billing.server.admin.resource.bean.ip.IPResourceRange;
import bitel.billing.server.ipn.bean.IPNResourceManager;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;
import java.util.Calendar;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public class ActionIPResourceTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        long ip2;
        long ip1;
        boolean maskMode;
        int categoryId = this.getIntParameter("category_id", -1);
        Calendar onDate = TimeUtils.convertDateToCalendar(this.getDateParameter("on_date"));
        String status = this.getParameter("status");
        String fromNumber = this.getParameter("range1");
        String toNumber = this.getParameter("range2");
        String net = this.getParameter("net");
        String mask = this.getParameter("mask");
        boolean bl = maskMode = net != null;
        if (maskMode) {
            ip1 = Utils.parseLong(net, 0L);
            ip2 = Utils.parseLong(mask, 0L);
        } else {
            ip1 = Utils.parseLong(fromNumber, 0L);
            ip2 = Utils.parseLong(toNumber, 0L);
        }
        if (categoryId < 0 || this.mid <= 0 || Utils.isBlankString(status)) {
            throw new BGIllegalArgumentException();
        }
        IPNResourceManager resourceManager = new IPNResourceManager(this.con, this.mid);
        Iterable resourceList = null;
        resourceList = status.equals("free") ? resourceManager.getFreeResourceIterator(categoryId, onDate) : (status.equals("busy") ? resourceManager.getBusyResourceIterator(categoryId, onDate, ip1, ip2, maskMode) : resourceManager.getResourceIterator(categoryId, ip1, ip2, maskMode));
        try {
            this.request.setAttribute("contentType", (Object)"binary");
            XMLOutputFactory factory = XMLOutputFactory.newInstance();
            XMLStreamWriter w = factory.createXMLStreamWriter((OutputStream)this.response.getOutputStream(), "UTF-8");
            w.writeStartDocument("UTF-8", "1.0");
            w.writeStartElement("data");
            w.writeAttribute("status", "ok");
            w.writeStartElement("table");
            w.writeStartElement("data");
            for (IPResourceRange resource : resourceList) {
                w.writeStartElement("row");
                w.writeAttribute("id", String.valueOf(resource.getId()));
                w.writeAttribute("period", TimeUtils.formatPeriod(resource.getDateFrom(), resource.getDateTo()));
                w.writeAttribute("ip1", IPUtils.convertLongIpToString(resource.getIp1()));
                w.writeAttribute("ip2", IPUtils.convertLongIpToString(resource.getIp2()));
                w.writeAttribute("item_id", String.valueOf(resource.getItemId()));
                w.writeEndElement();
            }
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndElement();
            w.writeEndDocument();
            w.flush();
        }
        catch (XMLStreamException e) {
            if (!(e.getCause() instanceof IOException)) {
                e.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

