/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.bgsecure.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ru.bitel.bgbilling.kernel.module.common.bean.BGSAction;

public class UserPermitionsManager {
    private Connection con;

    public UserPermitionsManager(Connection con) {
        this.con = con;
    }

    public List<BGSAction> getUserActions(int userId) {
        ArrayList<BGSAction> result = new ArrayList<BGSAction>();
        try {
            String query = "SELECT * FROM bgs_user_action WHERE uid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, userId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                BGSAction action = new BGSAction();
                this.loadFromRS(rs, action);
                result.add(action);
            }
            rs.close();
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public void updateUserActions(int userId, List<BGSAction> values) {
        try {
            String query = "DELETE FROM bgs_user_action WHERE uid=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, userId);
            ps.executeUpdate();
            ps.close();
            query = "INSERT INTO bgs_user_action ( uid, mid, aid ) VALUES (?, ?, ?)";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, userId);
            for (BGSAction action : values) {
                ps.setString(2, action.mid);
                ps.setInt(3, action.actionID);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadFromRS(ResultSet rs, BGSAction action) throws SQLException {
        action.mid = rs.getString("mid");
        action.actionID = rs.getInt("aid");
    }
}

