/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.contract.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Element;
import ru.bitel.common.Utils;

public class ActionGetArea
extends ActionBase {
    @Override
    public void doAction() throws SQLException {
        Element address = this.createElement(this.rootNode, "address");
        int streetid = this.getIntParameter("streetid", -1);
        int houseNumber = -1;
        String houseFrac = null;
        String houseAndFrac = this.getParameter("houseAndFrac", null);
        if (houseAndFrac != null) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < houseAndFrac.length(); ++i) {
                char ch = houseAndFrac.charAt(i);
                if (!Character.isDigit(ch)) {
                    houseFrac = houseAndFrac.substring(i);
                    break;
                }
                str.append(ch);
            }
            houseNumber = Utils.parseInt(str.toString(), 0);
        }
        int house = this.getIntParameter("house", houseNumber);
        String frac = this.getParameter("frac", houseFrac);
        if (streetid != -1 && house != -1) {
            ResultSet rs;
            StringBuilder query = new StringBuilder();
            query.append("SELECT t1.id, t3.title AS area, t2.title AS quarter, t1.box_index, t1.pod_diapazon AS pod_diapazon ");
            query.append("FROM address_house AS t1 ");
            query.append("LEFT JOIN address_quarter AS t2 ON t1.quarterid=t2.id ");
            query.append("LEFT JOIN address_area AS t3 ON t1.areaid=t3.id ");
            query.append("WHERE t1.streetid=? AND t1.house=? ");
            if (frac != null) {
                query.append(" AND t1.frac=?");
            } else {
                query.append(" AND ( t1.frac is null OR t1.frac='' )");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, streetid);
            ps.setInt(2, house);
            if (frac != null) {
                ps.setString(3, frac);
            }
            if ((rs = ps.executeQuery()).next()) {
                String temp = rs.getString("area");
                address.setAttribute("areaValue", temp);
                if (temp == null) {
                    temp = "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
                }
                address.setAttribute("area", temp);
                temp = rs.getString("quarter");
                address.setAttribute("quarterValue", temp);
                if (temp == null) {
                    temp = "\u041d\u0435 \u0443\u043a\u0430\u0437\u0430\u043d\u043e";
                }
                address.setAttribute("quarter", temp);
                address.setAttribute("box_index", rs.getString("box_index"));
                address.setAttribute("hid", rs.getString("id"));
                address.setAttribute("pod_diapazon", rs.getString("pod_diapazon"));
            }
            rs.close();
            ps.close();
        }
        address.setAttribute("canCreate", this.setup.get("address.create", null));
    }
}

